/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.jca.adapters.jdbc.util.Cache;
import org.jboss.jca.adapters.jdbc.util.CacheListener;

public class LRUCache<K, V>
implements Cache<K, V> {
    private ConcurrentMap<K, LRUCacheEntry<K, V>> mMap;
    private LRUList mList;
    private int mMaxCapacity;
    private CacheListener mListener;

    public LRUCache(int max) {
        this.mMaxCapacity = max;
        this.mMap = new ConcurrentHashMap<K, LRUCacheEntry<K, V>>();
        this.mList = new LRUList();
        this.mList.mMaxCapacity = this.mMaxCapacity;
        this.mList.mCapacity = this.mMaxCapacity;
        this.mListener = null;
    }

    @Override
    public V get(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Requesting an object using a null key");
        }
        LRUCacheEntry value = (LRUCacheEntry)this.mMap.get(key);
        if (value != null) {
            this.mList.promote(value);
            return value.getValue();
        }
        this.cacheMiss();
        return null;
    }

    @Override
    public V peek(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Requesting an object using a null key");
        }
        LRUCacheEntry value = (LRUCacheEntry)this.mMap.get(key);
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    @Override
    public void insert(K key, V o) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot insert a null object in the cache");
        }
        if (key == null) {
            throw new IllegalArgumentException("Cannot insert an object in the cache with null key");
        }
        if (this.mMap.containsKey(key)) {
            throw new IllegalStateException("Attempt to put in the cache an object that is already there");
        }
        this.mList.demote();
        LRUCacheEntry<K, V> entry = this.createCacheEntry(key, o);
        this.mMap.put(key, entry);
        this.mList.promote(entry);
    }

    @Override
    public void remove(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Removing an object using a null key");
        }
        LRUCacheEntry value = (LRUCacheEntry)this.mMap.remove(key);
        if (value != null) {
            this.mList.remove(value);
        }
    }

    @Override
    public void flush() {
        LRUCacheEntry entry = null;
        while ((entry = this.mList.mTail) != null) {
            this.ageOut(entry);
        }
    }

    @Override
    public int size() {
        return this.mList.mCount;
    }

    @Override
    public void setListener(CacheListener listener) {
        this.mListener = listener;
    }

    private void ageOut(LRUCacheEntry<K, V> entry) {
        if (this.mListener != null) {
            this.mListener.onEviction(entry.getValue());
        }
        this.remove(entry.getKey());
    }

    private void cacheMiss() {
        this.mList.entryCacheMiss();
    }

    private LRUCacheEntry<K, V> createCacheEntry(K key, V value) {
        return new LRUCacheEntry<K, V>(key, value);
    }

    public class LRUList {
        private int mMaxCapacity;
        private int mCapacity;
        private int mCount = 0;
        private LRUCacheEntry<K, V> mHead = null;
        private LRUCacheEntry<K, V> mTail = null;
        private int mCacheMiss = 0;

        protected LRUList() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void promote(LRUCacheEntry<K, V> entry) {
            if (entry == null) {
                throw new IllegalArgumentException("Trying to promote a null object");
            }
            if (this.mCapacity < 1) {
                throw new IllegalStateException("Can't work with capacity < 1");
            }
            this.entryPromotion(entry);
            entry.updateTimestamp();
            if (entry.mPrev == null) {
                if (entry.mNext != null) return;
                if (this.mCount == 0) {
                    this.mHead = entry;
                    this.mTail = entry;
                    ++this.mCount;
                    this.entryAdded(entry);
                    return;
                } else {
                    if (this.mCount == 1 && this.mHead == entry) return;
                    if (this.mCount < this.mCapacity) {
                        entry.mPrev = null;
                        entry.mNext = this.mHead;
                        this.mHead.mPrev = entry;
                        this.mHead = entry;
                        ++this.mCount;
                        this.entryAdded(entry);
                        return;
                    } else {
                        if (this.mCount >= this.mMaxCapacity) throw new IllegalStateException("Attempt to put a new cache entry on a full cache");
                        entry.mPrev = null;
                        entry.mNext = this.mHead;
                        this.mHead.mPrev = entry;
                        this.mHead = entry;
                        ++this.mCount;
                        int oldCapacity = this.mCapacity++;
                        this.entryAdded(entry);
                        this.capacityChanged(oldCapacity);
                    }
                }
                return;
            } else if (entry.mNext == null) {
                LRUCacheEntry beforeLast = entry.mPrev;
                beforeLast.mNext = null;
                entry.mPrev = null;
                entry.mNext = this.mHead;
                this.mHead.mPrev = entry;
                this.mHead = entry;
                this.mTail = beforeLast;
                return;
            } else {
                LRUCacheEntry previous = entry.mPrev;
                previous.mNext = entry.mNext;
                entry.mNext.mPrev = previous;
                entry.mPrev = null;
                entry.mNext = this.mHead;
                this.mHead.mPrev = entry;
                this.mHead = entry;
            }
        }

        protected void demote() {
            if (this.mCapacity < 1) {
                throw new IllegalStateException("Can't work with capacity < 1");
            }
            if (this.mCount > this.mMaxCapacity) {
                throw new IllegalStateException("Cache list entries number (" + this.mCount + ") > than the maximum allowed (" + this.mMaxCapacity + ")");
            }
            if (this.mCount == this.mMaxCapacity) {
                LRUCacheEntry entry = this.mTail;
                LRUCache.this.ageOut(entry);
            }
        }

        protected void remove(LRUCacheEntry<K, V> entry) {
            if (entry == null) {
                throw new IllegalArgumentException("Cannot remove a null entry from the cache");
            }
            if (this.mCount < 1) {
                throw new IllegalStateException("Trying to remove an entry from an empty cache");
            }
            entry.reset();
            if (this.mCount == 1) {
                this.mHead = null;
                this.mTail = null;
            } else if (entry.mPrev == null) {
                this.mHead = entry.mNext;
                this.mHead.mPrev = null;
                entry.mNext = null;
            } else if (entry.mNext == null) {
                this.mTail = entry.mPrev;
                this.mTail.mNext = null;
                entry.mPrev = null;
            } else {
                entry.mNext.mPrev = entry.mPrev;
                entry.mPrev.mNext = entry.mNext;
                entry.mPrev = null;
                entry.mNext = null;
            }
            --this.mCount;
            this.entryRemoved(entry);
        }

        protected void entryPromotion(LRUCacheEntry<K, V> entry) {
        }

        protected void entryAdded(LRUCacheEntry<K, V> entry) {
        }

        protected void entryRemoved(LRUCacheEntry<K, V> entry) {
        }

        protected void entryCacheMiss() {
            ++this.mCacheMiss;
        }

        protected void capacityChanged(int oldCapacity) {
        }

        protected void clear() {
            LRUCacheEntry entry = this.mHead;
            this.mHead = null;
            this.mTail = null;
            this.mCount = 0;
            while (entry != null) {
                this.entryRemoved(entry);
                entry = entry.mNext;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(Integer.toHexString(super.hashCode()));
            sb.append(" size: ").append(this.mCount);
            LRUCacheEntry entry = this.mHead;
            while (entry != null) {
                sb.append("\n").append(entry);
                entry = entry.mNext;
            }
            return sb.toString();
        }
    }

    public class LRUCacheEntry<K, V> {
        private LRUCacheEntry<K, V> mNext;
        private LRUCacheEntry<K, V> mPrev;
        private K mKey;
        private V mValue;
        private long mTime;

        protected LRUCacheEntry(K key, V value) {
            this.mKey = key;
            this.mValue = value;
            this.mNext = null;
            this.mPrev = null;
            this.mTime = 0L;
        }

        public K getKey() {
            return this.mKey;
        }

        public V getValue() {
            return this.mValue;
        }

        public void setNext(LRUCacheEntry<K, V> v) {
            this.mNext = v;
        }

        public void setPrev(LRUCacheEntry<K, V> v) {
            this.mPrev = v;
        }

        public void updateTimestamp() {
            this.mTime = System.currentTimeMillis();
        }

        public void reset() {
            this.mKey = null;
            this.mValue = null;
        }

        public String toString() {
            return "key: " + this.mKey + ", object: " + (this.mValue == null ? "null" : Integer.toHexString(this.mValue.hashCode())) + ", entry: " + Integer.toHexString(super.hashCode());
        }
    }
}

