/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.loading.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.mapper.pojo.loading.impl.PojoLoadingPlan;
import org.hibernate.search.mapper.pojo.loading.impl.PojoSingleLoaderLoadingPlan;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingStrategy;

public final class PojoMultiLoaderLoadingPlan<T>
implements PojoLoadingPlan<T> {
    private final PojoSelectionLoadingContext context;
    private final Map<PojoLoadingTypeContext<? extends T>, PojoSingleLoaderLoadingPlan<?>> planByType = new LinkedHashMap();
    private final Map<PojoSelectionLoadingStrategy<?>, PojoSingleLoaderLoadingPlan<?>> planByLoadingStrategy = new LinkedHashMap();

    public PojoMultiLoaderLoadingPlan(PojoSelectionLoadingContext context) {
        this.context = context;
    }

    @Override
    public <T2 extends T> int planLoading(PojoLoadingTypeContext<T2> expectedType, Object identifier) {
        return this.delegate(expectedType).planLoading(expectedType, identifier);
    }

    @Override
    public void loadBlocking(Deadline deadline) {
        this.context.checkOpen();
        for (PojoSingleLoaderLoadingPlan<?> delegate : this.planByLoadingStrategy.values()) {
            delegate.loadBlocking(deadline);
        }
    }

    @Override
    public <T2 extends T> T2 retrieve(PojoLoadingTypeContext<T2> expectedType, int ordinal) {
        return this.delegate(expectedType).retrieve(expectedType, ordinal);
    }

    @Override
    public void clear() {
        this.planByType.clear();
        this.planByLoadingStrategy.clear();
    }

    private <T2 extends T> PojoSingleLoaderLoadingPlan<? super T2> delegate(PojoLoadingTypeContext<T2> type) {
        PojoSingleLoaderLoadingPlan<Object> delegate = this.planByType.get(type);
        if (delegate != null) {
            return delegate;
        }
        PojoSelectionLoadingStrategy<T2> loadingStrategy = type.selectionLoadingStrategy();
        delegate = this.planByLoadingStrategy.get(loadingStrategy);
        if (delegate != null) {
            this.planByType.put(type, delegate);
            return delegate;
        }
        delegate = new PojoSingleLoaderLoadingPlan<T2>(this.context, loadingStrategy);
        this.planByType.put(type, delegate);
        this.planByLoadingStrategy.put(loadingStrategy, delegate);
        return delegate;
    }
}

