/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting.management;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementRequestTracker;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.remoting3.Registration;

public final class ManagementChannelRegistryService
implements Service {
    public static final ServiceName SERVICE_NAME = RemotingServices.REMOTING_BASE.append(new String[]{"management", "channel", "registry"});
    private final ArrayList<Registration> registrations = new ArrayList();
    private final ManagementRequestTracker trackerService = new ManagementRequestTracker();
    private final Consumer<ManagementChannelRegistryService> serviceConsumer;

    public static void addService(ServiceTarget serviceTarget, ServiceName endpointName) {
        ServiceBuilder sb = serviceTarget.addService(SERVICE_NAME);
        Consumer serviceConsumer = sb.provides(new ServiceName[]{SERVICE_NAME});
        sb.setInstance((Service)new ManagementChannelRegistryService(serviceConsumer));
        sb.requires(endpointName);
        sb.install();
    }

    protected ManagementChannelRegistryService(Consumer<ManagementChannelRegistryService> serviceConsumer) {
        this.serviceConsumer = serviceConsumer;
    }

    public void start(StartContext context) throws StartException {
        this.trackerService.reset();
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        this.trackerService.stop();
        ArrayList<Registration> registrations = this.registrations;
        for (Registration registration : registrations) {
            registration.close();
        }
        registrations.clear();
    }

    public ManagementRequestTracker getTrackerService() {
        return this.trackerService;
    }

    public void register(Registration registration) {
        this.registrations.add(registration);
    }
}

