/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.MessageFlowRecord;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExpireWhileLoadBalanceTest
extends ClusterTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupServer(0, this.isFileStorage(), true);
        this.setupServer(1, this.isFileStorage(), true);
        this.setupServer(2, this.isFileStorage(), true);
        for (int i = 0; i < 3; ++i) {
            this.servers[i].getConfiguration().setMessageExpiryScanPeriod(100L);
        }
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.STRICT, 1, true, 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.STRICT, 1, true, 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.STRICT, 1, true, 2, 0, 1);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, true);
        this.setupSessionFactory(1, true);
        this.setupSessionFactory(2, true);
    }

    @Test
    public void testSend() throws Exception {
        ExpireWhileLoadBalanceTest.waitForTopology(this.getServer(0), 3);
        ExpireWhileLoadBalanceTest.waitForTopology(this.getServer(1), 3);
        ExpireWhileLoadBalanceTest.waitForTopology(this.getServer(2), 3);
        SimpleString expiryQueue = SimpleString.of((String)"expiryQueue");
        AddressSettings as = new AddressSettings();
        as.setDeadLetterAddress(expiryQueue);
        as.setExpiryAddress(expiryQueue);
        for (int i = 0; i <= 2; ++i) {
            this.createQueue(i, "queues.testaddress", "queue0", null, true);
            this.getServer(i).createQueue(QueueConfiguration.of((SimpleString)expiryQueue).setRoutingType(RoutingType.ANYCAST));
            this.getServer(i).getAddressSettingsRepository().addMatch("#", (Object)as);
        }
        for (ClusterConnection clusterConnection : this.getServer(0).getClusterManager().getClusterConnections()) {
            for (MessageFlowRecord record : ((ClusterConnectionImpl)clusterConnection).getRecords().values()) {
                record.getBridge().pause();
            }
        }
        ClientSessionFactory sf = this.sfs[0];
        ClientSession session = sf.createSession(false, false);
        ClientProducer producer = session.createProducer("queues.testaddress");
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage(true);
            message.setExpiration(500L);
            producer.send((Message)message);
        }
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer("expiryQueue");
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = consumer.receive(2000L);
            Assertions.assertNotNull((Object)message);
            message.acknowledge();
        }
        session.commit();
        session.close();
    }
}

