/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.federation;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Collections;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationQueuePolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.federation.FederatedTestBase;
import org.apache.activemq.artemis.tests.integration.federation.FederatedTestUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FederatedQueuePullConsumerTest
extends FederatedTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.getServer(0).getConfiguration().addConnectorConfiguration("server-pull-1", "tcp://localhost:61617?consumerWindowSize=0;ackBatchSize=10");
    }

    @Override
    protected boolean isNetty() {
        return true;
    }

    @Override
    protected void configureQueues(ActiveMQServer server) throws Exception {
        server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)).setDefaultConsumerWindowSize(6000));
        this.createSimpleQueue(server, this.getName());
    }

    protected ConnectionFactory getCF(int i) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://" + i);
        factory.setConsumerWindowSize(0);
        return factory;
    }

    @Test
    public void testAddressFederatedConfiguredWithPullQueueConsumerEnabledNotAnOption() throws Exception {
        String connector = "server-pull-1";
        ((AddressSettings)this.getServer(0).getAddressSettingsRepository().getMatch("#")).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true));
        ((AddressSettings)this.getServer(1).getAddressSettingsRepository().getMatch("#")).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true));
        this.getServer(0).addAddressInfo(new AddressInfo(SimpleString.of((String)"source"), RoutingType.MULTICAST));
        this.getServer(1).addAddressInfo(new AddressInfo(SimpleString.of((String)"source"), RoutingType.MULTICAST));
        this.getServer(0).getConfiguration().getFederationConfigurations().add(new FederationConfiguration().setName("default").addFederationPolicy((FederationPolicy)new FederationAddressPolicyConfiguration().setName("myAddressPolicy").addInclude(new FederationAddressPolicyConfiguration.Matcher().setAddressMatch("#"))).addUpstreamConfiguration((FederationUpstreamConfiguration)((FederationUpstreamConfiguration)((FederationUpstreamConfiguration)new FederationUpstreamConfiguration().setName("server1-upstream")).addPolicyRef("myAddressPolicy")).setStaticConnectors(Collections.singletonList(connector))));
        this.getServer(0).getFederationManager().deploy();
        ConnectionFactory cf1 = this.getCF(0);
        ConnectionFactory cf2 = this.getCF(1);
        try (Connection consumer1Connection = cf1.createConnection();
             Connection producerConnection = cf2.createConnection();){
            consumer1Connection.start();
            Session session1 = consumer1Connection.createSession();
            Topic topic1 = session1.createTopic("source");
            MessageConsumer consumer1 = session1.createConsumer((Destination)topic1);
            Session session2 = producerConnection.createSession();
            Topic topic2 = session2.createTopic("source");
            MessageProducer producer = session2.createProducer((Destination)topic2);
            producer.send((Message)session2.createTextMessage("hello"));
            Assertions.assertTrue((boolean)this.waitForBindings(this.getServer(0), "source", true, 1, 1, 1000L));
            Assertions.assertFalse((boolean)this.waitForBindings(this.getServer(1), "source", true, 1, 1, 100L));
        }
    }

    @Test
    public void testFederatedQueuePullFromUpstream() throws Exception {
        String queueName = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createQueueUpstreamFederationConfiguration("server-pull-1", queueName);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        this.testFederatedQueuePullFromUpstream(queueName);
    }

    @Test
    public void testMultipleFederatedQueueRemoteConsumersUpstream() throws Exception {
        String connector = "server-pull-1";
        ((AddressSettings)this.getServer(0).getAddressSettingsRepository().getMatch("#")).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true));
        ((AddressSettings)this.getServer(1).getAddressSettingsRepository().getMatch("#")).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true));
        this.getServer(1).createQueue(QueueConfiguration.of((String)"Test.Q.1").setRoutingType(RoutingType.ANYCAST));
        this.getServer(1).createQueue(QueueConfiguration.of((String)"Test.Q.2").setRoutingType(RoutingType.ANYCAST));
        this.getServer(0).getConfiguration().getFederationConfigurations().add(new FederationConfiguration().setName("default").addFederationPolicy((FederationPolicy)new FederationQueuePolicyConfiguration().setName("myQueuePolicy").addInclude(new FederationQueuePolicyConfiguration.Matcher().setQueueMatch("#").setAddressMatch("Test.#"))).addUpstreamConfiguration((FederationUpstreamConfiguration)((FederationUpstreamConfiguration)((FederationUpstreamConfiguration)new FederationUpstreamConfiguration().setName("server1-upstream")).addPolicyRef("myQueuePolicy")).setStaticConnectors(Collections.singletonList(connector))));
        this.getServer(0).getFederationManager().deploy();
        ConnectionFactory cf1 = this.getCF(0);
        ConnectionFactory cf2 = this.getCF(0);
        ConnectionFactory cf3 = this.getCF(1);
        try (Connection consumer1Connection = cf1.createConnection();
             Connection consumer2Connection = cf2.createConnection();
             Connection producerConnection = cf3.createConnection();){
            consumer1Connection.start();
            Session session1 = consumer1Connection.createSession();
            Queue queue1 = session1.createQueue("Test.Q.1");
            MessageConsumer consumer1 = session1.createConsumer((Destination)queue1);
            consumer2Connection.start();
            Session session2 = consumer2Connection.createSession();
            Queue queue2 = session2.createQueue("Test.Q.2");
            MessageConsumer consumer2 = session2.createConsumer((Destination)queue2);
            Session session3 = producerConnection.createSession();
            MessageProducer producer = session3.createProducer((Destination)queue2);
            producer.send((Message)session3.createTextMessage("hello"));
            Assertions.assertNotNull((Object)consumer2.receive(1000L));
            consumer1Connection.close();
            producer.send((Message)session3.createTextMessage("hello"));
            Assertions.assertNotNull((Object)consumer2.receive(1000L));
        }
    }

    private void testFederatedQueuePullFromUpstream(String queueName) throws Exception {
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            int i;
            connection1.start();
            Session session1 = connection1.createSession();
            Queue queue1 = session1.createQueue(queueName);
            MessageProducer producer = session1.createProducer((Destination)queue1);
            producer.send((Message)session1.createTextMessage("1"));
            connection0.start();
            Session session0 = connection0.createSession();
            Queue queue0 = session0.createQueue(queueName);
            MessageProducer producer0 = session0.createProducer((Destination)queue1);
            producer0.send((Message)session0.createTextMessage("0"));
            MessageConsumer consumer0 = session0.createConsumer((Destination)queue0);
            this.waitForBindings(this.getServer(1), queueName, true, 1, 1, 2000L);
            Wait.assertEquals((int)1, () -> this.getMessageCount(this.getServer(0), queueName), (long)2000L, (long)100L);
            Wait.assertEquals((int)1, () -> this.getMessageCount(this.getServer(1), queueName), (long)2000L, (long)100L);
            Assertions.assertNotNull((Object)consumer0.receive(1000L));
            Assertions.assertNotNull((Object)consumer0.receive(4000L));
            Wait.assertEquals((Long)0L, () -> this.getMessageCount(this.getServer(0), queueName), (long)2000L, (long)100L);
            Wait.assertEquals((Long)0L, () -> this.getMessageCount(this.getServer(1), queueName), (long)2000L, (long)100L);
            Assertions.assertNull((Object)consumer0.receiveNoWait());
            int mumMessages = 150;
            for (i = 0; i < 150; ++i) {
                producer.send((Message)session1.createTextMessage("1-" + i));
            }
            Wait.assertTrue(() -> this.getMessageCount(this.getServer(1), queueName) > 100, (long)2000L, (long)200L);
            Wait.assertTrue(() -> this.getMessageCount(this.getServer(1), queueName) < 150, (long)2000L, (long)200L);
            Wait.assertTrue(() -> this.getMessageCount(this.getServer(0), queueName) > 10, (long)2000L, (long)100L);
            Wait.assertTrue(() -> this.getMessageCount(this.getServer(0), queueName) < 100, (long)2000L, (long)100L);
            for (i = 0; i < 150; ++i) {
                Assertions.assertNotNull((Object)consumer0.receive(4000L));
            }
            Assertions.assertNull((Object)consumer0.receiveNoWait());
            consumer0.close();
        }
    }
}

