/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class WildcardTest
extends JMSTestBase {
    private String topicA;
    private String topicB;
    private String topicWildcard;

    @Parameters(name="a={0},b={1},c={2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"test.topic.A", "test.topic.B", "test.topic.#"}, {"test.topic.A", "test.topic.B", "test.#"});
    }

    @Override
    protected Configuration createDefaultConfig(boolean netty) throws Exception {
        Configuration configuration = super.createDefaultConfig(netty).setJMXManagementEnabled(true);
        return configuration;
    }

    public WildcardTest(String topicA, String topicB, String topicWildcard) {
        this.topicA = topicA;
        this.topicB = topicB;
        this.topicWildcard = topicWildcard;
    }

    @TestTemplate
    public void testWildcard1Topic() throws Exception {
        Session sessionA = this.createSession();
        MessageProducer producerA = this.createProducer(sessionA, this.topicA);
        MessageConsumer consumerA = this.createConsumer(this.topicA);
        MessageConsumer consumerWC = this.createConsumer(this.topicWildcard);
        ObjectMessage message = sessionA.createObjectMessage((Serializable)Integer.valueOf(1));
        producerA.send((Message)message);
        ObjectMessage received1 = (ObjectMessage)consumerA.receive(500L);
        Assertions.assertNotNull((Object)received1);
        Assertions.assertNotNull((Object)received1.getObject());
        ObjectMessage received2 = (ObjectMessage)consumerWC.receive(500L);
        Assertions.assertNotNull((Object)received2);
        Assertions.assertNotNull((Object)received2.getObject());
        Assertions.assertEquals((Object)received1.getJMSMessageID(), (Object)received2.getJMSMessageID());
        Assertions.assertEquals((Object)received1.getObject(), (Object)received2.getObject());
    }

    @TestTemplate
    public void testWildcard2Topics() throws Exception {
        Session sessionA = this.createSession();
        MessageProducer producerA = this.createProducer(sessionA, this.topicA);
        Session sessionB = this.createSession();
        MessageProducer producerB = this.createProducer(sessionA, this.topicB);
        MessageConsumer consumerA = this.createConsumer(this.topicA);
        MessageConsumer consumerB = this.createConsumer(this.topicB);
        MessageConsumer consumerWC = this.createConsumer(this.topicWildcard);
        ObjectMessage message1 = sessionA.createObjectMessage((Serializable)Integer.valueOf(1));
        producerA.send((Message)message1);
        ObjectMessage message2 = sessionB.createObjectMessage((Serializable)Integer.valueOf(2));
        producerB.send((Message)message2);
        ObjectMessage received1 = (ObjectMessage)consumerA.receive(500L);
        Assertions.assertNotNull((Object)received1);
        Assertions.assertNotNull((Object)received1.getObject());
        ObjectMessage received2 = (ObjectMessage)consumerB.receive(500L);
        Assertions.assertNotNull((Object)received2);
        Assertions.assertNotNull((Object)received2.getObject());
        ObjectMessage received3 = (ObjectMessage)consumerWC.receive(500L);
        Assertions.assertNotNull((Object)received3);
        Assertions.assertNotNull((Object)received3.getObject());
        ObjectMessage received4 = (ObjectMessage)consumerWC.receive(500L);
        Assertions.assertNotNull((Object)received4);
        Assertions.assertNotNull((Object)received4.getObject());
        Assertions.assertEquals((Object)received1.getJMSMessageID(), (Object)received3.getJMSMessageID());
        Assertions.assertEquals((Object)received1.getObject(), (Object)received3.getObject());
        Assertions.assertEquals((Object)received2.getJMSMessageID(), (Object)received4.getJMSMessageID());
        Assertions.assertEquals((Object)received2.getObject(), (Object)received4.getObject());
    }

    @TestTemplate
    public void testNegativeAddressSizeOnWildcard1() throws Exception {
        this.testNegativeAddressSizeOnWildcard(1);
    }

    @TestTemplate
    public void testNegativeAddressSizeOnWildcard2() throws Exception {
        this.testNegativeAddressSizeOnWildcard(2);
    }

    @TestTemplate
    public void testNegativeAddressSizeOnWildcard10() throws Exception {
        this.testNegativeAddressSizeOnWildcard(10);
    }

    @TestTemplate
    public void testNegativeAddressSizeOnWildcard100() throws Exception {
        this.testNegativeAddressSizeOnWildcard(100);
    }

    @TestTemplate
    public void testNegativeAddressSizeOnWildcardAsync1() throws Exception {
        this.testNegativeAddressSizeOnWildcardAsync(1);
    }

    @TestTemplate
    public void testNegativeAddressSizeOnWildcardAsync2() throws Exception {
        this.testNegativeAddressSizeOnWildcardAsync(2);
    }

    @TestTemplate
    public void testNegativeAddressSizeOnWildcardAsync10() throws Exception {
        this.testNegativeAddressSizeOnWildcardAsync(10);
    }

    @TestTemplate
    public void testNegativeAddressSizeOnWildcardAsync100() throws Exception {
        this.testNegativeAddressSizeOnWildcardAsync(100);
    }

    private void testNegativeAddressSizeOnWildcard(int numMessages) throws Exception {
        int i;
        Session sessionA = this.createSession();
        MessageProducer producerA = this.createProducer(sessionA, this.topicA);
        MessageConsumer consumerA = this.createConsumer(this.topicA);
        MessageConsumer consumerWC = this.createConsumer(this.topicWildcard);
        for (i = 0; i < numMessages; ++i) {
            ObjectMessage message = sessionA.createObjectMessage((Serializable)Integer.valueOf(i));
            producerA.send((Message)message);
        }
        for (i = 0; i < numMessages; ++i) {
            ObjectMessage received1 = (ObjectMessage)consumerA.receive(500L);
            Assertions.assertNotNull((Object)received1, (String)("consumerA message - " + i + " is null"));
            Assertions.assertNotNull((Object)received1.getObject(), (String)("consumerA message - " + i + " is null"));
            ObjectMessage received2 = (ObjectMessage)consumerWC.receive(500L);
            Assertions.assertNotNull((Object)received2, (String)("consumerWC message - " + i + " is null"));
            Assertions.assertNotNull((Object)received2.getObject(), (String)("consumerWC message - " + i + " is null"));
        }
        long addressSizeA = (Long)this.mbeanServer.getAttribute(new ObjectName("org.apache.activemq.artemis:broker=\"localhost\",component=addresses,address=\"" + this.topicA + "\""), "AddressSize");
        long addressSizeWC = (Long)this.mbeanServer.getAttribute(new ObjectName("org.apache.activemq.artemis:broker=\"localhost\",component=addresses,address=\"" + this.topicWildcard + "\""), "AddressSize");
        Assertions.assertTrue((addressSizeA >= 0L ? 1 : 0) != 0, (String)(this.topicA + " AddressSize < 0"));
        Assertions.assertTrue((addressSizeWC >= 0L ? 1 : 0) != 0, (String)(this.topicWildcard + " AddressSize < 0"));
    }

    private void testNegativeAddressSizeOnWildcardAsync(int numMessages) throws Exception {
        Session sessionA = this.createSession();
        MessageProducer producerA = this.createProducer(sessionA, this.topicA);
        CountDownLatch latchA = new CountDownLatch(numMessages);
        MessageConsumer consumerA = this.createAsyncConsumer(this.topicA, latchA);
        CountDownLatch latchWC = new CountDownLatch(numMessages);
        MessageConsumer consumerWC = this.createAsyncConsumer(this.topicWildcard, latchWC);
        for (int i = 0; i < numMessages; ++i) {
            ObjectMessage message = sessionA.createObjectMessage((Serializable)Integer.valueOf(i));
            producerA.send((Message)message);
        }
        if (!latchA.await(5L, TimeUnit.SECONDS)) {
            Assertions.fail((String)("Waiting to receive " + latchA.getCount() + " messages on " + this.topicA));
        }
        if (!latchWC.await(5L, TimeUnit.SECONDS)) {
            Assertions.fail((String)("Waiting to receive " + latchWC.getCount() + " messages on " + this.topicWildcard));
        }
        long addressSizeA = (Long)this.mbeanServer.getAttribute(new ObjectName("org.apache.activemq.artemis:broker=\"localhost\",component=addresses,address=\"" + this.topicA + "\""), "AddressSize");
        long addressSizeWC = (Long)this.mbeanServer.getAttribute(new ObjectName("org.apache.activemq.artemis:broker=\"localhost\",component=addresses,address=\"" + this.topicWildcard + "\""), "AddressSize");
        Assertions.assertTrue((addressSizeA >= 0L ? 1 : 0) != 0, (String)(this.topicA + " AddressSize < 0"));
        Assertions.assertTrue((addressSizeWC >= 0L ? 1 : 0) != 0, (String)(this.topicWildcard + " AddressSize < 0"));
    }

    private Session createSession() throws Exception {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        return session;
    }

    private MessageProducer createProducer(Session session, String topicName) throws Exception {
        Topic topic = session.createTopic(topicName);
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.setDeliveryMode(1);
        return producer;
    }

    private MessageConsumer createConsumer(String topicName) throws Exception {
        Connection connection = this.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(topicName);
        MessageConsumer consumer = session.createConsumer((Destination)topic, null, false);
        return consumer;
    }

    private MessageConsumer createAsyncConsumer(String topicName, CountDownLatch latch) throws Exception {
        MessageConsumer consumer = this.createConsumer(topicName);
        consumer.setMessageListener(m -> {
            try {
                latch.countDown();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
        return consumer;
    }
}

