/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.connection;

import jakarta.jms.Connection;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExceptionListenerTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ActiveMQConnectionFactory cf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)false));
        this.server.start();
        this.cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        this.cf.setBlockOnDurableSend(true);
        this.cf.setPreAcknowledge(true);
    }

    @Test
    public void testListenerCalledForOneConnection() throws Exception {
        Connection conn = this.cf.createConnection();
        CountDownLatch latch = new CountDownLatch(1);
        MyExceptionListener listener = new MyExceptionListener(latch);
        conn.setExceptionListener((ExceptionListener)listener);
        ClientSessionInternal coreSession = (ClientSessionInternal)((ActiveMQConnection)conn).getInitialSession();
        coreSession.getConnection().fail((ActiveMQException)new ActiveMQInternalErrorException("blah"));
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)listener.numCalls);
        conn.close();
    }

    @Test
    public void testListenerCalledForOneConnectionAndSessions() throws Exception {
        Connection conn = this.cf.createConnection();
        CountDownLatch latch = new CountDownLatch(1);
        MyExceptionListener listener = new MyExceptionListener(latch);
        conn.setExceptionListener((ExceptionListener)listener);
        Session sess1 = conn.createSession(false, 1);
        Session sess2 = conn.createSession(false, 1);
        Session sess3 = conn.createSession(false, 1);
        ClientSessionInternal coreSession0 = (ClientSessionInternal)((ActiveMQConnection)conn).getInitialSession();
        ClientSessionInternal coreSession1 = (ClientSessionInternal)((ActiveMQSession)sess1).getCoreSession();
        ClientSessionInternal coreSession2 = (ClientSessionInternal)((ActiveMQSession)sess2).getCoreSession();
        ClientSessionInternal coreSession3 = (ClientSessionInternal)((ActiveMQSession)sess3).getCoreSession();
        coreSession0.getConnection().fail((ActiveMQException)new ActiveMQInternalErrorException("blah"));
        coreSession1.getConnection().fail((ActiveMQException)new ActiveMQInternalErrorException("blah"));
        coreSession2.getConnection().fail((ActiveMQException)new ActiveMQInternalErrorException("blah"));
        coreSession3.getConnection().fail((ActiveMQException)new ActiveMQInternalErrorException("blah"));
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)listener.numCalls);
        conn.close();
    }

    @Test
    public void testSetClientIdAfterSetExceptionListener() throws Exception {
        Connection conn = this.cf.createConnection();
        conn.setExceptionListener(e -> {});
        conn.setClientID("clientId");
        conn.close();
    }

    @Test
    public void testSetClientIdAfterGetExceptionListener() throws Exception {
        Connection conn = this.cf.createConnection();
        conn.getExceptionListener();
        conn.setClientID("clientId");
        conn.close();
    }

    private class MyExceptionListener
    implements ExceptionListener {
        volatile int numCalls;
        private final CountDownLatch latch;

        private MyExceptionListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public synchronized void onException(JMSException arg0) {
            ++this.numCalls;
            this.latch.countDown();
        }
    }
}

