/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.server.config;

import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.jms.server.config.JMSQueueConfiguration;
import org.apache.activemq.artemis.jms.server.config.TopicConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMSServerConfigParserTest
extends ActiveMQTestBase {
    @Test
    public void testParsing() throws Exception {
        Configuration config = this.createDefaultInVMConfig().addConnectorConfiguration("netty", new TransportConfiguration());
        String conf = "activemq-jms-for-JMSServerDeployerTest.xml";
        FileJMSConfiguration jmsconfig = new FileJMSConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(conf);
        deploymentManager.addDeployable((Deployable)jmsconfig);
        deploymentManager.readConfiguration();
        Assertions.assertEquals((int)1, (int)jmsconfig.getQueueConfigurations().size());
        JMSQueueConfiguration queueConfig = (JMSQueueConfiguration)jmsconfig.getQueueConfigurations().get(0);
        Assertions.assertEquals((Object)"fullConfigurationQueue", (Object)queueConfig.getName());
        Assertions.assertEquals((int)1, (int)jmsconfig.getTopicConfigurations().size());
        TopicConfiguration topicConfig = (TopicConfiguration)jmsconfig.getTopicConfigurations().get(0);
        Assertions.assertEquals((Object)"fullConfigurationTopic", (Object)topicConfig.getName());
    }
}

