/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5;

import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.Message;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImplAccessor;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeTestAccessor;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.Wait;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptionsBuilder;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.MqttSubscription;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.UserProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTT5Test
extends MQTT5TestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testSimpleSendReceive() throws Exception {
        String topic = RandomUtil.randomString();
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient subscriber = this.createPahoClient("subscriber");
        subscriber.connect();
        subscriber.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                logger.info("Message received from topic {}, message={}", (Object)topic, (Object)message);
                latch.countDown();
            }
        });
        subscriber.subscribe(topic, 1);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(topic, "myMessage".getBytes(StandardCharsets.UTF_8), 1, false);
        Assertions.assertTrue((boolean)latch.await(500L, TimeUnit.MILLISECONDS));
    }

    @Test
    @Timeout(value=60L)
    public void testTopicNameEscape() throws Exception {
        String topic = "foo1.0/bar/baz";
        final AtomicReference receivedTopic = new AtomicReference();
        MqttClient subscriber = this.createPahoClient("subscriber");
        subscriber.connect();
        subscriber.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String t, MqttMessage message) {
                receivedTopic.set(t);
            }
        });
        subscriber.subscribe("foo1.0/bar/baz", 1);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish("foo1.0/bar/baz", "myMessage".getBytes(StandardCharsets.UTF_8), 1, false);
        Wait.assertEquals((Object)"foo1.0/bar/baz", receivedTopic::get, (long)500L, (long)50L);
    }

    @Test
    @Timeout(value=60L)
    public void testTimestamp() throws Exception {
        String DESTINATION = RandomUtil.randomString();
        this.createJMSConnection();
        JMSContext context = this.cf.createContext();
        JMSConsumer consumer = context.createConsumer((Destination)context.createQueue(DESTINATION));
        long time = System.currentTimeMillis();
        MqttClient producer = this.createPahoClient(RandomUtil.randomString());
        producer.connect();
        producer.publish(DESTINATION, new byte[0], 1, false);
        producer.disconnect();
        producer.close();
        Message m = consumer.receive(200L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertTrue((m.getJMSTimestamp() > time ? (byte)1 : 0) != 0);
        context.close();
    }

    @Test
    @Timeout(value=60L)
    public void testResumeSubscriptionsAfterRestart() throws Exception {
        int SUBSCRIPTION_COUNT = 100;
        final ArrayList<CallSite> topicNames = new ArrayList<CallSite>(100);
        for (int i = 0; i < 100; ++i) {
            topicNames.add((CallSite)((Object)(this.getName() + i)));
        }
        final CountDownLatch latch = new CountDownLatch(100);
        MqttClient consumer = this.createPahoClient("myConsumerID");
        MqttConnectionOptions consumerOptions = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(999L)).build();
        consumer.connect(consumerOptions);
        ArrayList<MqttSubscription> subs = new ArrayList<MqttSubscription>(100);
        for (String string : topicNames) {
            subs.add(new MqttSubscription(string, 1));
        }
        consumer.subscribe(subs.toArray(new MqttSubscription[0]));
        consumer.disconnect();
        MqttClient producer = this.createPahoClient("myProducerID");
        MqttConnectionOptions mqttConnectionOptions = new MqttConnectionOptionsBuilder().sessionExpiryInterval(Long.valueOf(0L)).build();
        producer.connect(mqttConnectionOptions);
        for (String string : topicNames) {
            producer.publish(string, new byte[0], 1, false);
        }
        producer.disconnect();
        producer.close();
        Wait.assertEquals((Long)1L, () -> this.server.locateQueue("$sys.mqtt.sessions").getMessageCount(), (long)2000L, (long)100L);
        this.server.stop();
        this.server.start();
        Wait.assertEquals((Long)1L, () -> this.server.locateQueue("$sys.mqtt.sessions").getMessageCount(), (long)2000L, (long)100L);
        Wait.assertTrue(() -> this.getSessionStates().get("myConsumerID") != null, (long)2000L, (long)100L);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                if (topicNames.remove(topic)) {
                    latch.countDown();
                }
            }
        });
        consumerOptions = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(0L)).build();
        consumer.connect(consumerOptions);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.unsubscribe(topicNames.toArray(new String[0]));
        consumer.disconnect();
        consumer.close();
        Wait.assertEquals((Long)0L, () -> this.server.locateQueue("$sys.mqtt.sessions").getMessageCount(), (long)5000L, (long)100L);
    }

    @Test
    @Timeout(value=60L)
    public void testAddressAutoCreation() throws Exception {
        String DESTINATION = RandomUtil.randomString();
        this.server.getAddressSettingsRepository().addMatch(DESTINATION, (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)));
        MqttClient producer = this.createPahoClient(RandomUtil.randomString());
        producer.connect();
        producer.publish(DESTINATION, new byte[0], 0, false);
        producer.disconnect();
        producer.close();
        Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.of((String)DESTINATION)) != null, (long)2000L, (long)100L);
    }

    @Test
    @Timeout(value=60L)
    public void testAddressAutoCreationNegative() throws Exception {
        String DESTINATION = RandomUtil.randomString();
        this.server.getAddressSettingsRepository().addMatch(DESTINATION, (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)));
        MqttClient producer = this.createPahoClient(RandomUtil.randomString());
        producer.connect();
        producer.publish(DESTINATION, new byte[0], 0, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((this.server.getAddressInfo(SimpleString.of((String)DESTINATION)) == null ? (byte)1 : 0) != 0);
    }

    @Test
    @Timeout(value=60L)
    public void testWillMessageProperties() throws Exception {
        String[][] properties;
        byte[] WILL = RandomUtil.randomBytes();
        for (String[] property : properties = new String[10][2]) {
            property[0] = RandomUtil.randomString();
            property[1] = RandomUtil.randomString();
        }
        MqttClient client1 = this.createPahoClient("willConsumer");
        final CountDownLatch latch = new CountDownLatch(1);
        client1.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                int i = 0;
                for (UserProperty property : message.getProperties().getUserProperties()) {
                    Assertions.assertEquals((Object)properties[i][0], (Object)property.getKey());
                    Assertions.assertEquals((Object)properties[i][1], (Object)property.getValue());
                    ++i;
                }
                latch.countDown();
            }
        });
        client1.connect();
        client1.subscribe("/topic/foo", 1);
        MqttClient client2 = this.createPahoClient("willGenerator");
        MqttProperties willMessageProperties = new MqttProperties();
        ArrayList<UserProperty> userProperties = new ArrayList<UserProperty>();
        for (String[] property : properties) {
            userProperties.add(new UserProperty(property[0], property[1]));
        }
        willMessageProperties.setUserProperties(userProperties);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().will("/topic/foo", new MqttMessage(WILL)).build();
        options.setWillMessageProperties(willMessageProperties);
        client2.connect(options);
        client2.disconnectForcibly(0L, 0L, false);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    @Timeout(value=60L)
    public void testExpiryDelayOnDisconnect() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        MqttAsyncClient consumer = this.createAsyncPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().sessionExpiryInterval(Long.valueOf(300L)).build();
        consumer.connect(options).waitForCompletion();
        MqttProperties disconnectProperties = new MqttProperties();
        disconnectProperties.setSessionExpiryInterval(Long.valueOf(0L));
        consumer.disconnect(0L, null, null, 0, disconnectProperties).waitForCompletion();
        Wait.assertEquals((int)0, () -> this.getSessionStates().size(), (long)5000L, (long)10L);
    }

    @Test
    @Timeout(value=60L)
    public void testWillFlagFalseWithSessionExpiryDelay() throws Exception {
        this.server.createQueue(QueueConfiguration.of((String)"activemq.notifications"));
        this.server.createQueue(QueueConfiguration.of((String)"DLA"));
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setSendToDLAOnNoRoute(true).setDeadLetterAddress(SimpleString.of((String)"DLA")));
        MqttClient client = this.createPahoClient("willGenerator");
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().sessionExpiryInterval(Long.valueOf(1L)).build();
        client.connect(options);
        client.disconnectForcibly(0L, 0L, false);
        this.scanSessions();
        Assertions.assertEquals((long)0L, (long)this.server.locateQueue("DLA").getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testQueueCleanOnRestart() throws Exception {
        String topic = RandomUtil.randomString();
        String clientId = RandomUtil.randomString();
        MqttClient client = this.createPahoClient(clientId);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().sessionExpiryInterval(Long.valueOf(999L)).cleanStart(true).build();
        client.connect(options);
        client.subscribe(topic, 1);
        this.server.stop();
        this.server.start();
        org.apache.activemq.artemis.tests.util.Wait.assertTrue(() -> this.getSubscriptionQueue(topic, clientId) != null, (long)3000L, (long)10L);
    }

    @Test
    @Timeout(value=60L)
    public void testRecursiveWill() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            String WILL_QUEUE = "will";
            this.server.createQueue(QueueConfiguration.of((String)"will").setRoutingType(RoutingType.ANYCAST));
            PagingManagerImplAccessor.setDiskFull((PagingManagerImpl)this.server.getPagingManager(), true);
            MqttClient client = this.createPahoClient("willGenerator");
            MqttConnectionOptions options = new MqttConnectionOptionsBuilder().will("will", new MqttMessage(RandomUtil.randomBytes())).build();
            client.connect(options);
            client.disconnectForcibly(0L, 0L, false);
            Wait.assertTrue(() -> loggerHandler.findText(new String[]{"AMQ229119"}), (long)2000L, (long)100L);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSharedSubscriptionsWithSameName() throws Exception {
        String TOPIC1 = "myTopic1";
        String TOPIC2 = "myTopic2";
        String SUB_NAME = "mySub";
        String SHARED_SUB1 = "$share/mySub/myTopic1";
        String SHARED_SUB2 = "$share/mySub/myTopic2";
        CountDownLatch ackLatch1 = new CountDownLatch(1);
        CountDownLatch ackLatch2 = new CountDownLatch(1);
        MqttClient consumer1 = this.createPahoClient("consumer1");
        consumer1.connect();
        consumer1.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, ackLatch1));
        consumer1.subscribe("$share/mySub/myTopic1", 1);
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)"myTopic1")));
        Queue q1 = this.getSharedSubscriptionQueue("$share/mySub/myTopic1");
        Assertions.assertNotNull((Object)q1);
        Assertions.assertEquals((Object)"myTopic1", (Object)q1.getAddress().toString());
        Assertions.assertEquals((int)1, (int)q1.getConsumerCount());
        MqttClient consumer2 = this.createPahoClient("consumer2");
        consumer2.connect();
        consumer2.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, ackLatch2));
        consumer2.subscribe("$share/mySub/myTopic2", 1);
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)"myTopic2")));
        Queue q2 = this.getSharedSubscriptionQueue("$share/mySub/myTopic2");
        Assertions.assertNotNull((Object)q2);
        Assertions.assertEquals((Object)"myTopic2", (Object)q2.getAddress().toString());
        Assertions.assertEquals((int)1, (int)q2.getConsumerCount());
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish("myTopic1", new byte[0], 1, false);
        producer.publish("myTopic2", new byte[0], 1, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch1.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)ackLatch2.await(2L, TimeUnit.SECONDS));
        consumer1.unsubscribe("$share/mySub/myTopic1");
        Assertions.assertNull((Object)this.getSharedSubscriptionQueue("$share/mySub/myTopic1"));
        consumer2.unsubscribe("$share/mySub/myTopic2");
        Assertions.assertNull((Object)this.getSharedSubscriptionQueue("$share/mySub/myTopic2"));
        consumer1.disconnect();
        consumer1.close();
        consumer2.disconnect();
        consumer2.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSharedSubscriptionsWithSameName2() throws Exception {
        String TOPIC1 = "myTopic1";
        String TOPIC2 = "myTopic2";
        String SUB_NAME = "mySub";
        String[] SHARED_SUBS = new String[]{"$share/mySub/myTopic1", "$share/mySub/myTopic2"};
        CountDownLatch ackLatch = new CountDownLatch(2);
        MqttClient consumer = this.createPahoClient("consumer1");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, ackLatch));
        consumer.subscribe(SHARED_SUBS, new int[]{1, 1});
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)"myTopic1")));
        Queue q1 = this.getSharedSubscriptionQueue(SHARED_SUBS[0]);
        Assertions.assertNotNull((Object)q1);
        Assertions.assertEquals((Object)"myTopic1", (Object)q1.getAddress().toString());
        Assertions.assertEquals((int)1, (int)q1.getConsumerCount());
        Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)"myTopic2")));
        Queue q2 = this.getSharedSubscriptionQueue(SHARED_SUBS[1]);
        Assertions.assertNotNull((Object)q2);
        Assertions.assertEquals((Object)"myTopic2", (Object)q2.getAddress().toString());
        Assertions.assertEquals((int)1, (int)q2.getConsumerCount());
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish("myTopic1", new byte[0], 1, false);
        producer.publish("myTopic2", new byte[0], 1, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        consumer.unsubscribe(SHARED_SUBS);
        Assertions.assertNull((Object)this.getSharedSubscriptionQueue(SHARED_SUBS[0]));
        Assertions.assertNull((Object)this.getSharedSubscriptionQueue(SHARED_SUBS[1]));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSharedSubscriptionQueueRemoval() throws Exception {
        String TOPIC = "myTopic";
        String SUB_NAME = "myShare";
        String SHARED_SUB = "$share/myShare/myTopic";
        final ReusableLatch ackLatch = new ReusableLatch(1);
        MQTT5TestSupport.DefaultMqttCallback mqttCallback = new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                ackLatch.countDown();
            }
        };
        MqttClient consumer1 = this.createPahoClient("consumer1");
        consumer1.connect();
        consumer1.setCallback((MqttCallback)mqttCallback);
        consumer1.subscribe("$share/myShare/myTopic", 1);
        MqttClient consumer2 = this.createPahoClient("consumer2");
        consumer2.connect();
        consumer2.setCallback((MqttCallback)mqttCallback);
        consumer2.subscribe("$share/myShare/myTopic", 1);
        Queue sharedSubQueue = this.server.locateQueue("myShare".concat(".").concat("myTopic"));
        Assertions.assertNotNull((Object)sharedSubQueue);
        Assertions.assertEquals((Object)"myTopic", (Object)sharedSubQueue.getAddress().toString());
        Assertions.assertEquals((int)2, (int)sharedSubQueue.getConsumerCount());
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish("myTopic", new byte[0], 1, false);
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        consumer1.disconnect();
        sharedSubQueue = this.server.locateQueue("myShare".concat(".").concat("myTopic"));
        Assertions.assertNotNull((Object)sharedSubQueue);
        Assertions.assertEquals((Object)"myTopic", (Object)sharedSubQueue.getAddress().toString());
        Assertions.assertEquals((int)1, (int)sharedSubQueue.getConsumerCount());
        ackLatch.countUp();
        producer.publish("myTopic", new byte[0], 1, false);
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        consumer1.connect();
        consumer1.setCallback((MqttCallback)mqttCallback);
        consumer1.subscribe("$share/myShare/myTopic", 1);
        ackLatch.countUp();
        producer.publish("myTopic", new byte[0], 1, false);
        Assertions.assertTrue((boolean)ackLatch.await(2L, TimeUnit.SECONDS));
        producer.disconnect();
        producer.close();
        consumer1.disconnect();
        consumer1.close();
        consumer2.disconnect();
        consumer2.close();
        Wait.assertTrue(() -> this.server.locateQueue("myShare".concat(".").concat("myTopic")) == null, (long)2000L, (long)100L);
    }

    @Test
    @Timeout(value=60L)
    public void testAutoDeleteAddressWithWildcardSubscription() throws Exception {
        String prefix = "topic";
        this.server.getAddressSettingsRepository().addMatch(prefix + ".#", (Object)new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(true)).setAutoDeleteAddressesSkipUsageCheck(true));
        String topic = prefix + "/#";
        int MESSAGE_COUNT = 100;
        CountDownLatch latch = new CountDownLatch(100);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.subscribe(topic, 1);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        ArrayList<String> addresses = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            String string = prefix + "/" + RandomUtil.randomString();
            addresses.add(string.replace('/', '.'));
            producer.publish(string, new MqttMessage());
        }
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        for (String string : addresses) {
            Assertions.assertNotNull((Object)this.server.getAddressInfo(SimpleString.of((String)string)));
        }
        PostOfficeTestAccessor.sweepAndReapAddresses((PostOfficeImpl)this.server.getPostOffice());
        for (String string : addresses) {
            Assertions.assertNull((Object)this.server.getAddressInfo(SimpleString.of((String)string)));
        }
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConnectionStealingDisabled() throws Exception {
        this.setAcceptorProperty("allowLinkStealing=false");
        String CLIENT_ID = RandomUtil.randomString();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        client.connect();
        MqttClient client2 = this.createPahoClient(CLIENT_ID);
        try {
            client2.connect();
            Assertions.fail((String)"Should have thrown an exception on connect due to disabled link stealing");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Wait.assertEquals((int)1, () -> this.getSessionStates().size(), (long)2000L, (long)100L);
        Assertions.assertNotNull((Object)this.getSessionStates().get(CLIENT_ID));
        Assertions.assertTrue((boolean)client.isConnected());
        client.disconnect();
        client.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConnectionStealingOnMultipleAcceptors() throws Exception {
        int secondaryPort = 1884;
        String CLIENT_ID = RandomUtil.randomString();
        this.server.getRemotingService().createAcceptor(RandomUtil.randomString(), "tcp://localhost:" + secondaryPort);
        this.server.getRemotingService().startAcceptors();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        client.connect();
        MqttClient client2 = this.createPahoClient(CLIENT_ID, secondaryPort);
        client2.connect();
        Wait.assertEquals((int)1, () -> this.getSessionStates().size(), (long)2000L, (long)100L);
        Assertions.assertNotNull((Object)this.getSessionStates().get(CLIENT_ID));
        Assertions.assertFalse((boolean)client.isConnected());
        client.close();
        client2.disconnect();
        client2.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConnectionStealingDisabledOnMultipleAcceptors() throws Exception {
        int secondaryPort = 1884;
        String CLIENT_ID = RandomUtil.randomString();
        this.server.getRemotingService().createAcceptor(RandomUtil.randomString(), "tcp://localhost:" + secondaryPort + "?allowLinkStealing=false");
        this.server.getRemotingService().startAcceptors();
        MqttClient client = this.createPahoClient(CLIENT_ID);
        client.connect();
        MqttClient client2 = this.createPahoClient(CLIENT_ID, secondaryPort);
        try {
            client2.connect();
            Assertions.fail((String)"Should have thrown an exception on connect due to disabled link stealing");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Wait.assertEquals((int)1, () -> this.getSessionStates().size(), (long)2000L, (long)100L);
        Assertions.assertNotNull((Object)this.getSessionStates().get(CLIENT_ID));
        Assertions.assertTrue((boolean)client.isConnected());
        client.disconnect();
        client.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQueueCleanedUpOnConsumerFail() throws Exception {
        String topic = this.getName();
        String clientID = this.getName();
        this.server.getAddressSettingsRepository().addMatch(topic, (Object)new AddressSettings().setDefaultMaxConsumers(Integer.valueOf(0)));
        MqttClient client = this.createPahoClient(clientID);
        client.connect();
        try {
            client.subscribe(topic, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Wait.assertTrue(() -> this.getSubscriptionQueue(topic, clientID) == null, (long)2000L, (long)100L);
        if (client.isConnected()) {
            client.disconnect();
        }
        client.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSubscriptionQueueName() throws Exception {
        String topic = "a/b";
        String clientID = "myClientID";
        MqttClient client = this.createPahoClient("myClientID");
        client.connect();
        client.subscribe("a/b", 1);
        Wait.assertTrue(() -> this.getSubscriptionQueue("a/b", "myClientID") != null, (long)2000L, (long)100L);
        client.disconnect();
        client.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSubscriptionQueueCreatedWhenAutoCreateDisabled() throws Exception {
        String topic = "a/b";
        String clientID = "myClientID";
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("a/b")).setAutoCreateQueues(Boolean.valueOf(false));
        MqttClient client = this.createPahoClient("myClientID");
        client.connect();
        client.subscribe("a/b", 1);
        Wait.assertTrue(() -> this.getSubscriptionQueue("a/b", "myClientID") != null, (long)2000L, (long)100L);
        client.disconnect();
        client.close();
    }
}

