/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTStateManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MQTTStateManagerTest
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testNullClientID() throws Exception {
        this.testBadStateMessage(null);
    }

    @Test
    @Timeout(value=60L)
    public void testEmptyClientID() throws Exception {
        this.testBadStateMessage("");
    }

    @Test
    @Timeout(value=60L)
    public void testEmptyStateMessage() throws Exception {
        this.testBadStateMessage(RandomUtil.randomString());
    }

    private void testBadStateMessage(String clientId) throws Exception {
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocator((String)"vm://0"));
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession s = this.addClientSession(csf.createSession());
        ClientProducer p = this.addClientProducer(s.createProducer("$sys.mqtt.sessions"));
        ClientMessage m = s.createMessage(true);
        if (clientId != null) {
            m.putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME, clientId);
        }
        p.send((org.apache.activemq.artemis.api.core.Message)m);
        s.close();
        this.server.stop();
        this.server.start();
        Assertions.assertTrue((boolean)this.server.waitForActivation(3L, TimeUnit.SECONDS));
        Assertions.assertNotNull((Object)MQTTStateManager.getInstance((ActiveMQServer)this.server));
    }

    @Test
    public void testWrongStateMessageType() throws Exception {
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61616");
        Connection c = factory.createConnection();
        Session s = c.createSession();
        MessageProducer p = s.createProducer((Destination)s.createQueue("$sys.mqtt.sessions"));
        Message m = s.createMessage();
        m.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_LAST_VALUE_NAME.toString(), RandomUtil.randomString());
        p.send(m);
        c.close();
        this.server.stop();
        this.server.start();
        Assertions.assertTrue((boolean)this.server.waitForActivation(3L, TimeUnit.SECONDS));
        Assertions.assertNotNull((Object)MQTTStateManager.getInstance((ActiveMQServer)this.server));
    }
}

