/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RetroactiveAddressFailoverTest
extends FailoverTestBase {
    protected ServerLocator locator;
    protected ClientSessionFactoryInternal sf;
    String internalNamingPrefix = "$.artemis.internal.";
    String delimiter = ".";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.getServerLocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(300).setRetryInterval(100L);
        this.sf = this.createSessionFactoryAndWaitForTopology(this.locator, 2);
    }

    @Test
    public void testFailover() throws Exception {
        ClientMessage message;
        int j;
        int MESSAGE_COUNT = 10;
        int OFFSET = 5;
        ActiveMQServer primary = this.primaryServer.getServer();
        ActiveMQServer backup = this.backupServer.getServer();
        ClientSession session = this.addClientSession(this.sf.createSession(true, true));
        SimpleString queueName = SimpleString.of((String)"simpleQueue");
        SimpleString addressName = SimpleString.of((String)"myAddress");
        SimpleString divertQueue = ResourceNames.getRetroactiveResourceQueueName((String)this.internalNamingPrefix, (String)this.delimiter, (SimpleString)addressName, (RoutingType)RoutingType.MULTICAST);
        primary.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        backup.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setRetroactiveMessageCount(10L));
        primary.addAddressInfo(new AddressInfo(addressName));
        ClientProducer producer = this.addClientProducer(session.createProducer(addressName));
        for (j = 0; j < 5; ++j) {
            message = session.createMessage(true);
            message.putIntProperty("xxx", j);
            producer.send((Message)message);
        }
        Wait.assertTrue(() -> primary.locateQueue(divertQueue).getMessageCount() == 5L);
        this.crash(session);
        Wait.assertTrue(() -> backup.locateQueue(divertQueue).getMessageCount() == 5L);
        for (j = 5; j < 15; ++j) {
            message = session.createMessage(true);
            message.putIntProperty("xxx", j);
            producer.send((Message)message);
        }
        Wait.assertTrue(() -> backup.locateQueue(divertQueue).getMessageCount() == 10L);
        session.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> backup.locateQueue(queueName) != null);
        Wait.assertTrue(() -> backup.locateQueue(queueName).getMessageCount() == 10L);
        ClientConsumer consumer = session.createConsumer(queueName);
        for (int j2 = 5; j2 < 15; ++j2) {
            session.start();
            ClientMessage message2 = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message2);
            message2.acknowledge();
            Assertions.assertEquals((int)j2, (int)message2.getIntProperty("xxx"));
        }
        consumer.close();
        session.deleteQueue(queueName);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }
}

