/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyValueOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class ReplaceIfUnmodifiedOperation<V>
extends AbstractKeyValueOperation<VersionedOperationResponse<V>> {
    private final long version;

    public ReplaceIfUnmodifiedOperation(InternalRemoteCache<?, ?> remoteCache, byte[] keyBytes, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, long version) {
        super(remoteCache, keyBytes, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
        this.version = version;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        ByteBufUtil.writeArray(buf, this.keyBytes);
        codec.writeExpirationParams(buf, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        buf.writeLong(this.version);
        ByteBufUtil.writeArray(buf, this.valueBytes);
    }

    @Override
    public VersionedOperationResponse<V> createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        return this.returnVersionedOperationResponse(buf, status, codec, unmarshaller);
    }

    @Override
    public void handleStatsCompletion(ClientStatistics statistics, long startTime, short status, VersionedOperationResponse<V> responseValue) {
        if (HotRodConstants.isSuccess(status)) {
            statistics.dataStore(startTime, 1);
        }
    }

    @Override
    public short requestOpCode() {
        return 9;
    }

    @Override
    public short responseOpCode() {
        return 10;
    }
}

