/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import org.wildfly.clustering.context.Contextualizer;
import org.wildfly.clustering.context.ThreadContextReference;

public class ContextualThreadFactory<C>
implements ThreadFactory {
    private final ThreadFactory factory;
    private final C targetContext;
    private final ThreadContextReference<C> reference;
    private final Contextualizer contextualizer;

    public ContextualThreadFactory(ThreadFactory factory, C targetContext, ThreadContextReference<C> reference) {
        this(factory, targetContext, reference, Contextualizer.withContextProvider(reference.provide(targetContext)));
    }

    ContextualThreadFactory(ThreadFactory factory, C targetContext, ThreadContextReference<C> reference, Contextualizer contextualizer) {
        this.factory = factory;
        this.targetContext = targetContext;
        this.reference = reference;
        this.contextualizer = contextualizer;
    }

    @Override
    public Thread newThread(final Runnable task) {
        Thread thread = AccessController.doPrivileged(new PrivilegedAction<Thread>(this){
            final /* synthetic */ ContextualThreadFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Thread run() {
                return this.this$0.factory.newThread(this.this$0.contextualizer.contextualize(task));
            }
        });
        this.reference.accept(thread, this.targetContext);
        return thread;
    }
}

