/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.util.Reflections;
import org.jboss.modules.ClassDefiner;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.weld.interceptor.proxy.LifecycleMixin;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.proxy.WeldConstruct;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ProxyServicesImpl
implements ProxyServices {
    private static String[] REQUIRED_WELD_DEPENDENCIES = new String[]{"org.jboss.weld.core", "org.jboss.weld.spi", "org.jboss.weld.api"};
    private static String[] WELD_CLASSES = new String[]{BeanIdentifier.class.getName(), LifecycleMixin.class.getName(), WeldConstruct.class.getName()};
    private final Module module;
    private final ConcurrentMap<String, Boolean> processedStaticModules = new ConcurrentHashMap<String, Boolean>();
    private final ClassDefiner classDefiner;

    public ProxyServicesImpl(Module module) {
        this.module = module;
        this.classDefiner = ClassDefiner.getInstance();
    }

    public ClassLoader getClassLoader(final Class<?> proxiedBeanType) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ProxyServicesImpl.this._getClassLoader(proxiedBeanType);
                }
            });
        }
        return this._getClassLoader(proxiedBeanType);
    }

    private ClassLoader _getClassLoader(Class<?> proxiedBeanType) {
        if (proxiedBeanType.getName().startsWith("java")) {
            return this.module.getClassLoader();
        }
        if (proxiedBeanType.getClassLoader() instanceof ModuleClassLoader) {
            ModuleClassLoader loader = (ModuleClassLoader)proxiedBeanType.getClassLoader();
            if (loader.getModule().getModuleLoader() instanceof ServiceModuleLoader) {
                return proxiedBeanType.getClassLoader();
            }
            Module definingModule = loader.getModule();
            Boolean hasWeldDependencies = (Boolean)this.processedStaticModules.get(definingModule.getName());
            boolean logWarning = false;
            if (hasWeldDependencies == null) {
                hasWeldDependencies = ProxyServicesImpl.canLoadWeldProxies(definingModule);
                boolean bl = logWarning = this.processedStaticModules.putIfAbsent(definingModule.getName(), hasWeldDependencies) == null;
            }
            if (hasWeldDependencies.booleanValue()) {
                return proxiedBeanType.getClassLoader();
            }
            if (logWarning) {
                WeldLogger.ROOT_LOGGER.loadingProxiesUsingDeploymentClassLoader(definingModule.getName(), Arrays.toString(REQUIRED_WELD_DEPENDENCIES));
            }
            return this.module.getClassLoader();
        }
        return proxiedBeanType.getClassLoader();
    }

    private Module getModule(Class<?> originalClass) {
        if (originalClass.getName().startsWith("java")) {
            return this.module;
        }
        Module definingModule = Module.forClass(originalClass);
        Boolean hasWeldDependencies = (Boolean)this.processedStaticModules.get(definingModule.getName());
        boolean logWarning = false;
        if (hasWeldDependencies == null) {
            hasWeldDependencies = ProxyServicesImpl.canLoadWeldProxies(definingModule);
            boolean bl = logWarning = this.processedStaticModules.putIfAbsent(definingModule.getName(), hasWeldDependencies) == null;
        }
        if (hasWeldDependencies.booleanValue()) {
            return definingModule;
        }
        if (logWarning) {
            WeldLogger.ROOT_LOGGER.loadingProxiesUsingDeploymentClassLoader(definingModule.getName(), Arrays.toString(REQUIRED_WELD_DEPENDENCIES));
        }
        return this.module;
    }

    private static boolean canLoadWeldProxies(Module module) {
        for (String weldClass : WELD_CLASSES) {
            if (Reflections.isAccessible((String)weldClass, (ClassLoader)module.getClassLoader())) continue;
            return false;
        }
        return true;
    }

    public void cleanup() {
        this.processedStaticModules.clear();
    }

    public Class<?> loadBeanClass(final String className) {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return Class.forName(className, true, ProxyServicesImpl.this.getClassLoader(this.getClass()));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw BeanLogger.LOG.cannotLoadClass((Object)className, (Throwable)pae.getException());
        }
    }

    public Class<?> defineClass(Class<?> originalClass, String s, byte[] bytes, int i, int i1) throws ClassFormatError {
        return this.defineClass(originalClass, s, bytes, i, i1, this.getProtectionDomain(originalClass));
    }

    public Class<?> defineClass(Class<?> originalClass, String s, byte[] bytes, int i, int i1, ProtectionDomain protectionDomain) throws ClassFormatError {
        return this.classDefiner.defineClass(this.getModule(originalClass), s, protectionDomain, bytes, i, i1);
    }

    public Class<?> loadClass(Class<?> originalClass, String classBinaryName) throws ClassNotFoundException {
        Module module = this.getModule(originalClass);
        if (module == null) {
            throw WeldLogger.ROOT_LOGGER.originalClassDoesNotHaveAModule(originalClass);
        }
        return module.getClassLoader().loadClass(classBinaryName);
    }

    public boolean supportsClassDefining() {
        return true;
    }

    private ProtectionDomain getProtectionDomain(Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(clazz::getProtectionDomain);
        }
        return clazz.getProtectionDomain();
    }
}

