/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.connector.deployers.ra.processors.IronJacamarDeploymentParsingProcessor;
import org.jboss.as.connector.deployers.ra.processors.ParsedRaDeploymentProcessor;
import org.jboss.as.connector.deployers.ra.processors.RaDeploymentParsingProcessor;
import org.jboss.as.connector.deployers.ra.processors.RaNativeProcessor;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.common.CredentialImpl;
import org.jboss.as.connector.metadata.common.SecurityImpl;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.resourceadapter.WorkManagerSecurityImpl;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.metadata.xmldescriptors.IronJacamarXmlDescriptor;
import org.jboss.as.connector.services.resourceadapters.deployment.InactiveResourceAdapterDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.ResourceAdapterXmlDeploymentService;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableAdminObject;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableConnDef;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.connector.util.ModelNodeUtil;
import org.jboss.as.connector.util.RaServicesFactory;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.UninterruptibleCountDownLatch;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.annotation.ResourceRootIndexer;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.Index;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.AdminObject;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManager;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManagerSecurity;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.PoolImpl;
import org.jboss.jca.common.metadata.common.TimeOutImpl;
import org.jboss.jca.common.metadata.common.ValidationImpl;
import org.jboss.jca.common.metadata.common.XaPoolImpl;
import org.jboss.jca.common.metadata.resourceadapter.WorkManagerImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.source.CredentialSource;

public class RaOperationUtil {
    private static final ServiceName SECURITY_DOMAIN_SERVICE = ServiceName.JBOSS.append(new String[]{"security", "security-domain"});
    public static final ServiceName RAR_MODULE = ServiceName.of((String[])new String[]{"rarinsidemodule"});

    public static ModifiableResourceAdapter buildResourceAdaptersObject(String id, OperationContext context, ModelNode operation, String archiveOrModule) throws OperationFailedException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        ArrayList<ConnectionDefinition> connectionDefinitions = new ArrayList<ConnectionDefinition>(0);
        ArrayList<AdminObject> adminObjects = new ArrayList<AdminObject>(0);
        String transactionSupportResolved = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.TRANSACTION_SUPPORT);
        TransactionSupportEnum transactionSupport = operation.hasDefined(Constants.TRANSACTION_SUPPORT.getName()) ? TransactionSupportEnum.valueOf((String)ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.TRANSACTION_SUPPORT)) : null;
        String bootstrapContext = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.BOOTSTRAP_CONTEXT);
        List beanValidationGroups = Constants.BEANVALIDATION_GROUPS.unwrap((ExpressionResolver)context, operation);
        boolean wmSecurity = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.WM_SECURITY);
        WorkManagerImpl workManager = null;
        if (wmSecurity) {
            boolean mappingRequired = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.WM_SECURITY_MAPPING_REQUIRED);
            String elytronDomain = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.WM_ELYTRON_SECURITY_DOMAIN);
            if (elytronDomain == null) {
                throw new OperationFailedException(ConnectorLogger.SUBSYSTEM_RA_LOGGER.legacySecurityNotSupported());
            }
            String domain = elytronDomain;
            String defaultPrincipal = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.WM_SECURITY_DEFAULT_PRINCIPAL);
            List defaultGroups = Constants.WM_SECURITY_DEFAULT_GROUPS.unwrap((ExpressionResolver)context, operation);
            Map<String, String> groups = ModelNodeUtil.extractMap(operation, Constants.WM_SECURITY_MAPPING_GROUPS, Constants.WM_SECURITY_MAPPING_FROM, Constants.WM_SECURITY_MAPPING_TO);
            Map<String, String> users = ModelNodeUtil.extractMap(operation, Constants.WM_SECURITY_MAPPING_USERS, Constants.WM_SECURITY_MAPPING_FROM, Constants.WM_SECURITY_MAPPING_TO);
            workManager = new WorkManagerImpl((WorkManagerSecurity)new WorkManagerSecurityImpl(mappingRequired, domain, elytronDomain != null, defaultPrincipal, defaultGroups, users, groups));
        }
        ModifiableResourceAdapter ra = new ModifiableResourceAdapter(id, archiveOrModule, transactionSupport, (List<ConnectionDefinition>)connectionDefinitions, (List<AdminObject>)adminObjects, (Map<String, String>)configProperties, beanValidationGroups, bootstrapContext, (WorkManager)workManager);
        return ra;
    }

    public static ModifiableConnDef buildConnectionDefinitionObject(OperationContext context, ModelNode connDefModel, String poolName, boolean isXa, ExceptionSupplier<CredentialSource, Exception> recoveryCredentialSourceSupplier) throws OperationFailedException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        String className = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, Constants.CLASS_NAME);
        String jndiName = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME);
        boolean enabled = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.ENABLED);
        boolean connectable = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.CONNECTABLE);
        Boolean tracking = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.TRACKING);
        boolean useJavaContext = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT);
        boolean useCcm = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.USE_CCM);
        boolean sharable = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.SHARABLE);
        boolean enlistment = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.ENLISTMENT);
        String mcp = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, Constants.MCP);
        Boolean enlistmentTrace = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.ENLISTMENT_TRACE);
        int maxPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE);
        int minPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE);
        Integer initialPoolSize = ModelNodeUtil.getIntIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE);
        boolean prefill = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL);
        boolean fair = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FAIR);
        boolean useStrictMin = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN);
        String flushStrategyString = org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.resolveModelAttribute(context, connDefModel).asString();
        FlushStrategy flushStrategy = FlushStrategy.forName((String)flushStrategyString);
        Boolean isSameRM = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.SAME_RM_OVERRIDE);
        boolean interlivng = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.INTERLEAVING);
        boolean padXid = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.PAD_XID);
        boolean wrapXaResource = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.WRAP_XA_RESOURCE);
        boolean noTxSeparatePool = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.NOTXSEPARATEPOOL);
        Integer allocationRetry = ModelNodeUtil.getIntIfSetOrGetDefault(context, connDefModel, Constants.ALLOCATION_RETRY);
        Long allocationRetryWaitMillis = ModelNodeUtil.getLongIfSetOrGetDefault(context, connDefModel, Constants.ALLOCATION_RETRY_WAIT_MILLIS);
        Long blockingTimeoutMillis = ModelNodeUtil.getLongIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS);
        Long idleTimeoutMinutes = ModelNodeUtil.getLongIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES);
        Integer xaResourceTimeout = ModelNodeUtil.getIntIfSetOrGetDefault(context, connDefModel, Constants.XA_RESOURCE_TIMEOUT);
        TimeOutImpl timeOut = new TimeOutImpl(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
        Extension incrementer = ModelNodeUtil.extractExtension(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES);
        Extension decrementer = ModelNodeUtil.extractExtension(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES);
        Capacity capacity = new Capacity(incrementer, decrementer);
        Object pool = isXa ? new XaPoolImpl(Integer.valueOf(minPoolSize), initialPoolSize, Integer.valueOf(maxPoolSize), Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, capacity, Boolean.valueOf(fair), isSameRM, Boolean.valueOf(interlivng), Boolean.valueOf(padXid), Boolean.valueOf(wrapXaResource), Boolean.valueOf(noTxSeparatePool)) : new PoolImpl(Integer.valueOf(minPoolSize), initialPoolSize, Integer.valueOf(maxPoolSize), Boolean.valueOf(prefill), Boolean.valueOf(useStrictMin), flushStrategy, capacity, Boolean.valueOf(fair));
        String securityDomain = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, Constants.SECURITY_DOMAIN);
        String securityDomainAndApplication = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, Constants.SECURITY_DOMAIN_AND_APPLICATION);
        if (securityDomain != null || securityDomainAndApplication != null) {
            throw new OperationFailedException(ConnectorLogger.SUBSYSTEM_RA_LOGGER.legacySecurityNotSupported());
        }
        String authenticationContext = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, Constants.AUTHENTICATION_CONTEXT);
        String authenticationContextAndApplication = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, Constants.AUTHENTICATION_CONTEXT_AND_APPLICATION);
        boolean application = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.APPLICATION);
        SecurityImpl security = null;
        if (authenticationContext != null || authenticationContextAndApplication != null || application) {
            security = new SecurityImpl(authenticationContext, authenticationContextAndApplication, application);
        }
        Long backgroundValidationMillis = ModelNodeUtil.getLongIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS);
        Boolean backgroundValidation = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION);
        boolean useFastFail = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL);
        Boolean validateOnMatch = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, org.jboss.as.connector.subsystems.common.pool.Constants.VALIDATE_ON_MATCH);
        ValidationImpl validation = new ValidationImpl(validateOnMatch, backgroundValidation, backgroundValidationMillis, Boolean.valueOf(useFastFail));
        String recoveryUsername = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, Constants.RECOVERY_USERNAME);
        String recoveryPassword = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, Constants.RECOVERY_PASSWORD);
        String recoverySecurityDomain = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, Constants.RECOVERY_SECURITY_DOMAIN);
        if (recoverySecurityDomain != null) {
            throw new OperationFailedException(ConnectorLogger.SUBSYSTEM_RA_LOGGER.legacySecurityNotSupported());
        }
        String recoveryAuthenticationContext = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, connDefModel, Constants.RECOVERY_AUTHENTICATION_CONTEXT);
        Boolean noRecovery = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, connDefModel, Constants.NO_RECOVERY);
        Recovery recovery = null;
        if (recoveryUsername != null && (recoveryPassword != null || recoveryCredentialSourceSupplier != null) || recoveryAuthenticationContext != null || noRecovery != null) {
            CredentialImpl credential = null;
            if (recoveryUsername != null && (recoveryPassword != null || recoveryCredentialSourceSupplier != null) || recoveryAuthenticationContext != null) {
                credential = new CredentialImpl(recoveryUsername, recoveryPassword, recoveryAuthenticationContext, recoveryCredentialSourceSupplier);
            }
            Extension recoverPlugin = ModelNodeUtil.extractExtension(context, connDefModel, Constants.RECOVER_PLUGIN_CLASSNAME, Constants.RECOVER_PLUGIN_PROPERTIES);
            if (noRecovery == null) {
                noRecovery = Boolean.FALSE;
            }
            recovery = new Recovery((Credential)credential, recoverPlugin, noRecovery);
        }
        ModifiableConnDef connectionDefinition = new ModifiableConnDef(configProperties, className, jndiName, poolName, enabled, useJavaContext, useCcm, (Pool)pool, (TimeOut)timeOut, (Validation)validation, security, recovery, sharable, enlistment, connectable, tracking, mcp, enlistmentTrace);
        return connectionDefinition;
    }

    public static ModifiableAdminObject buildAdminObjects(OperationContext context, ModelNode operation, String poolName) throws OperationFailedException, ValidateException {
        HashMap<String, String> configProperties = new HashMap<String, String>(0);
        String className = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, operation, Constants.CLASS_NAME);
        String jndiName = ModelNodeUtil.getResolvedStringIfSetOrGetDefault(context, operation, org.jboss.as.connector.subsystems.common.jndi.Constants.JNDI_NAME);
        boolean enabled = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, operation, Constants.ENABLED);
        boolean useJavaContext = ModelNodeUtil.getBooleanIfSetOrGetDefault(context, operation, org.jboss.as.connector.subsystems.common.jndi.Constants.USE_JAVA_CONTEXT);
        ModifiableAdminObject adminObject = new ModifiableAdminObject(configProperties, className, jndiName, poolName, enabled, useJavaContext);
        return adminObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceName restartIfPresent(OperationContext context, String raName, final String id) throws OperationFailedException {
        ServiceName raDeploymentServiceName = ConnectorServices.getDeploymentServiceName(raName, id);
        final ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController raServiceController = registry.getService(raDeploymentServiceName);
        if (raServiceController != null) {
            final ServiceController.Mode originalMode = raServiceController.getMode();
            final UninterruptibleCountDownLatch latch = new UninterruptibleCountDownLatch(1);
            raServiceController.addListener(new LifecycleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleEvent(ServiceController controller, LifecycleEvent event) {
                    latch.awaitUninterruptibly();
                    if (event == LifecycleEvent.DOWN) {
                        try {
                            ServiceController RaxmlController = registry.getService(ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{id}));
                            Activation raxml = (Activation)RaxmlController.getValue();
                            ((ResourceAdapterXmlDeploymentService)controller.getService()).setRaxml(raxml);
                            controller.compareAndSetMode(ServiceController.Mode.NEVER, originalMode);
                        }
                        finally {
                            controller.removeListener((LifecycleListener)this);
                        }
                    }
                }
            });
            try {
                raServiceController.setMode(ServiceController.Mode.NEVER);
            }
            finally {
                latch.countDown();
            }
            return raDeploymentServiceName;
        }
        return null;
    }

    public static boolean removeIfActive(OperationContext context, String raName, String id) throws OperationFailedException {
        boolean wasActive = false;
        ServiceName raDeploymentServiceName = raName == null ? ConnectorServices.getDeploymentServiceName(id) : ConnectorServices.getDeploymentServiceName(raName, id);
        if (context.getServiceRegistry(true).getService(raDeploymentServiceName) != null) {
            context.removeService(raDeploymentServiceName);
            wasActive = true;
        }
        return wasActive;
    }

    public static void activate(OperationContext context, String raName, String archiveName) throws OperationFailedException {
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController inactiveRaController = registry.getService(ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{archiveName}));
        CapabilityServiceSupport support = context.getCapabilityServiceSupport();
        if (inactiveRaController == null && (inactiveRaController = registry.getService(ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{raName}))) == null) {
            throw ConnectorLogger.ROOT_LOGGER.RARNotYetDeployed(raName);
        }
        InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment inactive = (InactiveResourceAdapterDeploymentService.InactiveResourceAdapterDeployment)inactiveRaController.getValue();
        ServiceController RaxmlController = registry.getService(ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{raName}));
        Activation raxml = (Activation)RaxmlController.getValue();
        RaServicesFactory.createDeploymentService(inactive.getRegistration(), inactive.getConnectorXmlDescriptor(), inactive.getModule(), inactive.getServiceTarget(), archiveName, inactive.getDeploymentUnitServiceName(), inactive.getDeployment(), raxml, inactive.getResource(), registry, support);
    }

    public static ServiceName installRaServices(OperationContext context, String name, ModifiableResourceAdapter resourceAdapter, List<ServiceController<?>> newControllers) {
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceController resourceAdaptersService = context.getServiceRegistry(false).getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
        if (resourceAdaptersService == null) {
            newControllers.add(serviceTarget.addService(ConnectorServices.RESOURCEADAPTERS_SERVICE, (Service)new ResourceAdaptersService()).setInitialMode(ServiceController.Mode.ACTIVE).install());
        }
        ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{name});
        ServiceController service = context.getServiceRegistry(true).getService(raServiceName);
        if (service == null) {
            String securityDomainName;
            WorkManagerSecurity workManagerSecurity;
            ResourceAdapterService raService = new ResourceAdapterService(resourceAdapter, name);
            ServiceBuilder builder = serviceTarget.addService(raServiceName, (Service)raService).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ConnectorServices.RESOURCEADAPTERS_SERVICE, ResourceAdaptersService.ModifiableResourceAdaptors.class, raService.getResourceAdaptersInjector()).addDependency(ConnectorServices.RESOURCEADAPTERS_SUBSYSTEM_SERVICE, ResourceAdaptersSubsystemService.class, raService.getResourceAdaptersSubsystemInjector());
            for (ConnectionDefinition cd : resourceAdapter.getConnectionDefinitions()) {
                Security security = cd.getSecurity();
                if (security == null) continue;
                if (security.getSecurityDomain() != null) {
                    builder.requires(context.getCapabilityServiceName("org.wildfly.security.authentication-context", security.getSecurityDomain(), AuthenticationContext.class));
                }
                if (security.getSecurityDomainAndApplication() != null) {
                    builder.requires(context.getCapabilityServiceName("org.wildfly.security.authentication-context", security.getSecurityDomainAndApplication(), AuthenticationContext.class));
                }
                if (cd.getRecovery() == null || cd.getRecovery().getCredential() == null || cd.getRecovery().getCredential().getSecurityDomain() == null) continue;
                builder.requires(context.getCapabilityServiceName("org.wildfly.security.authentication-context", cd.getRecovery().getCredential().getSecurityDomain(), AuthenticationContext.class));
            }
            if (resourceAdapter.getWorkManager() != null && (workManagerSecurity = resourceAdapter.getWorkManager().getSecurity()) != null && (securityDomainName = workManagerSecurity.getDomain()) != null) {
                builder.requires(context.getCapabilityServiceName("org.wildfly.security.security-domain", securityDomainName, SecurityDomain.class));
            }
            newControllers.add(builder.install());
        }
        return raServiceName;
    }

    public static void installRaServicesAndDeployFromModule(OperationContext context, String name, ModifiableResourceAdapter resourceAdapter, String fullModuleName, List<ServiceController<?>> newControllers) throws OperationFailedException {
        Module module;
        String moduleName;
        ServiceName raServiceName = RaOperationUtil.installRaServices(context, name, resourceAdapter, newControllers);
        boolean resolveProperties = true;
        ServiceTarget serviceTarget = context.getServiceTarget();
        CapabilityServiceSupport support = context.getCapabilityServiceSupport();
        String slot = "main";
        if (fullModuleName.contains(":")) {
            slot = fullModuleName.substring(fullModuleName.indexOf(":") + 1);
            moduleName = fullModuleName.substring(0, fullModuleName.indexOf(":"));
        } else {
            moduleName = fullModuleName;
        }
        try {
            String moduleId = ModuleIdentifierUtil.canonicalModuleIdentifier((String)moduleName, (String)slot);
            module = Module.getCallerModuleLoader().loadModule(moduleId);
        }
        catch (ModuleNotFoundException e) {
            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.raModuleNotFound(moduleName, e.getMessage()), (Throwable)e);
        }
        catch (ModuleLoadException e) {
            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToLoadModuleRA(moduleName, e.getMessage()), (Throwable)e);
        }
        URL path = module.getExportedResource("META-INF/ra.xml");
        Closeable closable = null;
        try {
            String rarName;
            MountHandle mountHandle;
            if (path.getPath().contains("!")) {
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.compressedRarNotSupportedInModuleRA(moduleName));
            }
            VirtualFile child = VFS.getChild((String)path.getPath().split("META-INF")[0]);
            ResourceRoot resourceRoot = new ResourceRoot(child, mountHandle = MountHandle.create((Closeable)(closable = VFS.mountReal((File)new File(path.getPath().split("META-INF")[0]), (VirtualFile)child))));
            VirtualFile deploymentRoot = resourceRoot.getRoot();
            if (deploymentRoot == null || !deploymentRoot.exists()) {
                return;
            }
            ConnectorXmlDescriptor connectorXmlDescriptor = RaDeploymentParsingProcessor.process(true, deploymentRoot, null, name);
            IronJacamarXmlDescriptor ironJacamarXmlDescriptor = IronJacamarDeploymentParsingProcessor.process(deploymentRoot, true);
            RaNativeProcessor.process(deploymentRoot);
            HashMap<ResourceRoot, Index> annotationIndexes = new HashMap<ResourceRoot, Index>();
            ResourceRootIndexer.indexResourceRoot((ResourceRoot)resourceRoot);
            Index index = (Index)resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index != null) {
                annotationIndexes.put(resourceRoot, index);
            }
            List jarChildren = deploymentRoot.getChildren((VirtualFileFilter)new SuffixMatchFilter(".jar", VisitorAttributes.LEAVES_ONLY));
            for (VirtualFile subJarRoot : jarChildren) {
                Closeable subClosable = VFS.mountZip((File)subJarRoot.getPhysicalFile(), (VirtualFile)subJarRoot, (TempFileProvider)TempFileProviderService.provider());
                ResourceRoot subResRoot = new ResourceRoot(subJarRoot, MountHandle.create((Closeable)subClosable));
                ResourceRootIndexer.indexResourceRoot((ResourceRoot)subResRoot);
                Index subIndex = (Index)subResRoot.getAttachment(Attachments.ANNOTATION_INDEX);
                if (subIndex == null) continue;
                annotationIndexes.put(subResRoot, subIndex);
            }
            if (ironJacamarXmlDescriptor != null) {
                ConnectorLogger.SUBSYSTEM_RA_LOGGER.forceIJToNull();
                ironJacamarXmlDescriptor = null;
            }
            ServiceName deployerServiceName = ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()});
            ServiceController deployerService = context.getServiceRegistry(true).getService(deployerServiceName);
            if (deployerService == null) {
                ServiceBuilder<ResourceAdapterDeployment> builder = ParsedRaDeploymentProcessor.process(connectorXmlDescriptor, ironJacamarXmlDescriptor, (ClassLoader)module.getClassLoader(), serviceTarget, annotationIndexes, RAR_MODULE.append(new String[]{name}), null, null, support);
                builder.requires(raServiceName);
                newControllers.add(builder.setInitialMode(ServiceController.Mode.ACTIVE).install());
            }
            if (fullModuleName.equals(rarName = resourceAdapter.getArchive())) {
                ServiceName serviceName = ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{name});
                InactiveResourceAdapterDeploymentService service = new InactiveResourceAdapterDeploymentService(connectorXmlDescriptor, module, name, name, RAR_MODULE.append(new String[]{name}), null, serviceTarget, null);
                newControllers.add(serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install());
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToLoadModuleRA(moduleName, e.getMessage()), (Throwable)e);
        }
        finally {
            if (closable != null) {
                try {
                    closable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

