/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.TextMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.ChildDocIds;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;

public abstract class JoiningTextMultiValuesSource
extends TextMultiValuesSource {
    protected final NestedDocsProvider nestedDocsProvider;

    public static JoiningTextMultiValuesSource fromField(String field, NestedDocsProvider nested) {
        return new FieldTextMultiValuesSource(field, nested);
    }

    protected JoiningTextMultiValuesSource(NestedDocsProvider nestedDocsProvider) {
        this.nestedDocsProvider = nestedDocsProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoiningTextMultiValuesSource that = (JoiningTextMultiValuesSource)o;
        return Objects.equals(this.nestedDocsProvider, that.nestedDocsProvider);
    }

    public int hashCode() {
        return this.nestedDocsProvider.hashCode();
    }

    @Override
    public TextMultiValues getValues(LeafReaderContext ctx) throws IOException {
        SortedSetDocValues values = this.getSortedSetDocValues(ctx);
        if (this.nestedDocsProvider == null) {
            return TextMultiValues.fromDocValues(values);
        }
        return this.select(values, this.nestedDocsProvider.childDocs(ctx, (DocIdSetIterator)values));
    }

    protected abstract SortedSetDocValues getSortedSetDocValues(LeafReaderContext var1) throws IOException;

    protected TextMultiValues select(SortedSetDocValues values, final ChildDocIds childDocsWithValues) {
        if (childDocsWithValues == null) {
            return TextMultiValues.EMPTY;
        }
        return new TextMultiValues.DocValuesTextMultiValues(values){
            private int currentParentDoc;
            {
                super(values);
                this.currentParentDoc = -1;
            }

            @Override
            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.currentParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.currentParentDoc) {
                    return this.hasNextValue();
                }
                this.currentParentDoc = parentDoc;
                boolean found = childDocsWithValues.advanceExactParent(parentDoc);
                if (found) {
                    childDocsWithValues.nextChild();
                }
                this.updateRemaining(found);
                return found;
            }

            @Override
            public boolean hasNextValue() throws IOException {
                if (super.hasNextValue()) {
                    return true;
                }
                boolean hasNextChildDocWithValue = childDocsWithValues.nextChild() != Integer.MAX_VALUE;
                this.updateRemaining(hasNextChildDocWithValue);
                return hasNextChildDocWithValue;
            }
        };
    }

    private static class FieldTextMultiValuesSource
    extends JoiningTextMultiValuesSource {
        private final String field;

        public FieldTextMultiValuesSource(String field, NestedDocsProvider nestedDocsProvider) {
            super(nestedDocsProvider);
            this.field = field;
        }

        public String toString() {
            return "Long(" + this.field + "," + String.valueOf(this.nestedDocsProvider) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            FieldTextMultiValuesSource that = (FieldTextMultiValuesSource)o;
            return Objects.equals(this.field, that.field);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.field);
        }

        @Override
        protected SortedSetDocValues getSortedSetDocValues(LeafReaderContext ctx) throws IOException {
            return DocValues.getSortedSet((LeafReader)ctx.reader(), (String)this.field);
        }
    }
}

