/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.cs.NioServer;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.BasicTCP;

public class TCP_NIO2
extends BasicTCP {
    protected NioServer server;
    @Property(description="The max number of outgoing messages that can get queued for a given peer connection (before dropping them). Most messages will get retransmitted; this is mainly used at startup, e.g. to prevent dropped discovery requests or responses (sent unreliably, without retransmission).")
    protected int max_send_buffers = 10;
    @Property(description="If true, a partial write will make a copy of the data so a buffer can be reused")
    protected boolean copy_on_partial_write = true;
    @Property(description="Number of ms a reader thread on a given connection can be idle (not receiving any messages) until it terminates. New messages will start a new reader", type=AttributeType.TIME)
    protected long reader_idle_time = 5000L;

    public int getMaxSendBuffers() {
        return this.max_send_buffers;
    }

    public TCP_NIO2 setMaxSendBuffers(int m) {
        this.max_send_buffers = m;
        return this;
    }

    public boolean copyOnPartialWrite() {
        return this.copy_on_partial_write;
    }

    public TCP_NIO2 copyOnPartialWrite(boolean c) {
        this.copy_on_partial_write = c;
        return this;
    }

    public long getReaderIdleTime() {
        return this.reader_idle_time;
    }

    public TCP_NIO2 setReaderIdleTime(long r) {
        this.reader_idle_time = r;
        return this;
    }

    @ManagedAttribute
    public int getOpenConnections() {
        return this.server.getNumConnections();
    }

    @Override
    @ManagedOperation
    public String printConnections() {
        return this.server.printConnections();
    }

    @ManagedOperation(description="Prints send and receive buffers for all connections")
    public String printBuffers() {
        return this.server.printBuffers();
    }

    @ManagedOperation(description="Clears all connections (they will get re-established). For testing only, don't use !")
    public void clearConnections() {
        this.server.clearConnections();
    }

    @ManagedAttribute(description="Is the selector open")
    public boolean isSelectorOpen() {
        return this.server != null && this.server.selectorOpen();
    }

    @ManagedAttribute(description="Is the acceptor thread (calling select()) running")
    public boolean isAcceptorRunning() {
        return this.server != null && this.server.acceptorRunning();
    }

    @ManagedAttribute(description="Number of times select() was called")
    public int numSelects() {
        return this.server != null ? this.server.numSelects() : -1;
    }

    @ManagedAttribute(description="Number of partial writes for all connections (not all bytes were written)")
    public int numPartialWrites() {
        return this.server.numPartialWrites();
    }

    @ManagedAttribute(description="Number of ms a reader thread on a given connection can be idle (not receiving any messages) until it terminates. New messages will start a new reader")
    public void readerIdleTime(long t) {
        this.reader_idle_time = t;
        this.server.readerIdleTime(t);
    }

    @Override
    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        if (this.server != null) {
            try {
                this.server.send(dest, data, offset, length);
            }
            catch (CancelledKeyException | ClosedChannelException exception) {
            }
            catch (Throwable ex) {
                this.log.trace("%s: failed sending message to %s: %s", this.local_addr, dest, ex);
            }
        }
    }

    @Override
    public void retainAll(Collection<Address> members) {
        this.server.retainAll(members);
    }

    @Override
    public void start() throws Exception {
        this.server = new NioServer(this.getThreadFactory(), this.getSocketFactory(), this.bind_addr, this.bind_port, this.bind_port + this.port_range, this.external_addr, this.external_port, this.recv_buf_size);
        this.server.receiver(this).timeService(this.time_service).socketConnectionTimeout(this.sock_conn_timeout).tcpNodelay(this.tcp_nodelay).linger(this.linger).clientBindAddress(this.client_bind_addr).clientBindPort(this.client_bind_port).deferClientBinding(this.defer_client_bind_addr).log(this.log).logDetails(this.log_details);
        this.server.maxSendBuffers(this.max_send_buffers).usePeerConnections(true);
        this.server.copyOnPartialWrite(this.copy_on_partial_write).readerIdleTime(this.reader_idle_time).addConnectionListener(this);
        if (this.send_buf_size > 0) {
            this.server.sendBufferSize(this.send_buf_size);
        }
        if (this.recv_buf_size > 0) {
            this.server.receiveBufferSize(this.recv_buf_size);
        }
        if (this.reaper_interval > 0L || this.conn_expire_time > 0L) {
            if (this.reaper_interval == 0L) {
                this.reaper_interval = 5000L;
                this.log.warn("reaper_interval was 0, set it to %d", this.reaper_interval);
            }
            if (this.conn_expire_time == 0L) {
                this.conn_expire_time = 300000L;
                this.log.warn("conn_expire_time was 0, set it to %d", this.conn_expire_time);
            }
            this.server.connExpireTimeout(this.conn_expire_time).reaperInterval(this.reaper_interval);
        }
        if (this.max_length > 0) {
            this.server.setMaxLength(this.max_length);
        }
        super.start();
    }

    @Override
    public void stop() {
        this.log.debug("closing sockets and stopping threads");
        this.server.stop();
        super.stop();
    }

    @Override
    protected void handleConnect() throws Exception {
        this.server.start();
    }

    @Override
    protected void handleDisconnect() {
        this.server.stop();
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.server != null ? (PhysicalAddress)this.server.localAddress() : null;
    }
}

