/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.reporting.impl.ElasticsearchSearchHints;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;

class ElasticsearchDocumentReferenceProjection
extends AbstractElasticsearchProjection<DocumentReference>
implements ElasticsearchSearchProjection.Extractor<DocumentReference, DocumentReference> {
    private final DocumentReferenceExtractionHelper helper;

    ElasticsearchDocumentReferenceProjection(ElasticsearchSearchIndexScope<?> scope, DocumentReferenceExtractionHelper helper) {
        super(scope);
        this.helper = helper;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<?, DocumentReference> request(JsonObject requestBody, ProjectionRequestContext context) {
        context.checkNotNested(ProjectionTypeKeys.DOCUMENT_REFERENCE, ElasticsearchSearchHints.INSTANCE.documentReferenceProjectionNestingNotSupportedHint());
        this.helper.request(requestBody, context);
        return this;
    }

    @Override
    public DocumentReference extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
        return this.helper.extract(hit, context);
    }

    @Override
    public DocumentReference transform(LoadingResult<?> loadingResult, DocumentReference extractedData, ProjectionTransformContext context) {
        return extractedData;
    }
}

