/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.addressing;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoWaysRemoveAddressTest
extends ActiveMQTestBase {
    private static Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testDeadLock() throws Throwable {
        ActiveMQServer server = this.addServer(this.createServer(false));
        server.start();
        int retries = 10;
        CyclicBarrier barrier = new CyclicBarrier(2);
        AtomicInteger errors = new AtomicInteger(0);
        Thread createAndDestroy1 = new Thread(() -> {
            try {
                barrier.await(10L, TimeUnit.SECONDS);
                for (int i = 0; i < 10; ++i) {
                    logger.debug("Removed queue on thread 1 ::{}", (Object)i);
                    server.createQueue(QueueConfiguration.of((String)("queueName_1_" + i)).setAddress("address_1_" + i).setRoutingType(RoutingType.ANYCAST));
                    server.destroyQueue(SimpleString.of((String)("queueName_1_" + i)));
                }
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                errors.incrementAndGet();
            }
        });
        Thread createAndDestroy2 = new Thread(() -> {
            try {
                barrier.await(10L, TimeUnit.SECONDS);
                for (int i = 0; i < 10; ++i) {
                    logger.debug("Removed queue on thread 2 ::{}", (Object)i);
                    server.createQueue(QueueConfiguration.of((String)("queueName_2_" + i)).setAddress("address_2_" + i).setRoutingType(RoutingType.ANYCAST));
                    server.removeAddressInfo(SimpleString.of((String)("address_2_" + i)), null, true);
                }
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                errors.incrementAndGet();
            }
        });
        createAndDestroy1.start();
        createAndDestroy2.start();
        createAndDestroy1.join(10000L);
        createAndDestroy2.join(10000L);
        Assertions.assertFalse((boolean)createAndDestroy1.isAlive());
        Assertions.assertFalse((boolean)createAndDestroy2.isAlive());
        Assertions.assertEquals((int)0, (int)errors.get());
    }
}

