/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMSTransactedRedeliveryBugTest
extends JMSClientTestSupport {
    private static final String INITIAL_QUEUE_NAME = "InitialQueue";
    private static final String FINAL_QUEUE_NAME = "FinalQueue";
    private static final SimpleString INITIAL_QUEUE_SS = SimpleString.of((String)"InitialQueue");
    private static final SimpleString FINAL_QUEUE_SS = SimpleString.of((String)"FinalQueue");

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getAddressSettingsRepository().addMatch(INITIAL_QUEUE_NAME, (Object)new AddressSettings().setExpiryAddress(FINAL_QUEUE_SS));
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        super.createAddressAndQueues(server);
        server.addAddressInfo(new AddressInfo(INITIAL_QUEUE_SS, RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)INITIAL_QUEUE_SS).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(FINAL_QUEUE_SS, RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((SimpleString)FINAL_QUEUE_SS).setRoutingType(RoutingType.ANYCAST));
    }

    @Override
    protected String getJmsConnectionURIOptions() {
        return "amqp.traceFrames=true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAMQPProducerAMQPConsumer() throws Exception {
        Connection producerConnection = this.createConnection();
        Connection consumerConnection = this.createConnection();
        try {
            Session producerSession = producerConnection.createSession(false, 1);
            Queue producerQueue = producerSession.createQueue(INITIAL_QUEUE_NAME);
            MessageProducer producer = producerSession.createProducer((Destination)producerQueue);
            TextMessage sentMessage = producerSession.createTextMessage();
            sentMessage.setStringProperty("something", "KEY");
            sentMessage.setText("how are you");
            producer.send((Message)sentMessage, 2, 4, 10L);
            Wait.assertTrue((String)"Message should have expired", () -> this.getProxyToQueue(FINAL_QUEUE_NAME).getMessageCount() == 1L);
            Session consumerSession = consumerConnection.createSession(true, 0);
            Queue consumerQueue = consumerSession.createQueue(FINAL_QUEUE_NAME);
            MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue);
            Message msg = consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)"1", (Object)msg.getStringProperty("JMSXDeliveryCount"));
            Assertions.assertEquals((Object)"KEY", (Object)msg.getStringProperty("something"));
            Assertions.assertEquals((Object)"how are you", (Object)((TextMessage)msg).getText());
            consumerSession.rollback();
            msg = consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)"2", (Object)msg.getStringProperty("JMSXDeliveryCount"));
            Assertions.assertEquals((Object)"KEY", (Object)msg.getStringProperty("something"));
            Assertions.assertEquals((Object)"how are you", (Object)((TextMessage)msg).getText());
            consumerSession.rollback();
            msg = consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)"3", (Object)msg.getStringProperty("JMSXDeliveryCount"));
            Assertions.assertEquals((Object)"KEY", (Object)msg.getStringProperty("something"));
            Assertions.assertEquals((Object)"how are you", (Object)((TextMessage)msg).getText());
            consumerSession.rollback();
            msg = consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)"4", (Object)msg.getStringProperty("JMSXDeliveryCount"));
            Assertions.assertEquals((Object)"KEY", (Object)msg.getStringProperty("something"));
            Assertions.assertEquals((Object)"how are you", (Object)((TextMessage)msg).getText());
            consumerSession.rollback();
            msg = consumer.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((Object)"5", (Object)msg.getStringProperty("JMSXDeliveryCount"));
            Assertions.assertEquals((Object)"KEY", (Object)msg.getStringProperty("something"));
            Assertions.assertEquals((Object)"how are you", (Object)((TextMessage)msg).getText());
            consumerSession.commit();
            consumer.close();
        }
        finally {
            producerConnection.close();
            consumerConnection.close();
        }
    }
}

