/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AutoDeleteJmsDestinationTest
extends JMSTestBase {
    @Override
    protected void extraServerConfig(ActiveMQServer server) {
        super.extraServerConfig(server);
        server.getConfiguration().setAddressQueueScanPeriod(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDeleteQueue() throws Exception {
        try (Connection connection = this.cf.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = ActiveMQJMSClient.createQueue((String)"test");
            MessageProducer producer = session.createProducer((Destination)queue);
            int numMessages = 100;
            for (int i = 0; i < 100; ++i) {
                TextMessage mess = session.createTextMessage("msg" + i);
                producer.send((Message)mess);
            }
            producer.close();
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            connection.start();
            for (int i = 0; i < 99; ++i) {
                Message m = messageConsumer.receive(5000L);
                Assertions.assertNotNull((Object)m);
            }
            Wait.waitFor(() -> {
                Binding binding = this.server.getPostOffice().getBinding(SimpleString.of((String)"test"));
                if (binding == null) {
                    return false;
                }
                return binding.getBindable() != null;
            });
            Queue q = (Queue)this.server.getPostOffice().getBinding(SimpleString.of((String)"test")).getBindable();
            Wait.assertEquals((long)1L, () -> ((Queue)q).getMessageCount());
            Assertions.assertEquals((long)100L, (long)q.getMessagesAdded());
            session = connection.createSession(false, 1);
            MessageConsumer messageConsumer2 = session.createConsumer((Destination)queue);
            messageConsumer.close();
            Message m = messageConsumer2.receive(5000L);
            Assertions.assertNotNull((Object)m);
            connection.close();
            SimpleString qname = SimpleString.of((String)"test");
            Wait.waitFor(() -> this.server.getPostOffice().getBinding(qname) == null);
            Assertions.assertNull((Object)this.server.getPostOffice().getBinding(SimpleString.of((String)"test")));
            Assertions.assertNull((Object)this.server.getManagementService().getResource("test"));
            messageConsumer2.close();
        }
    }

    @Test
    public void testAutoDeleteNegative() throws Exception {
        Message m;
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoDeleteQueues(Boolean.valueOf(false)));
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = ActiveMQJMSClient.createQueue((String)"test");
        MessageProducer producer = session.createProducer((Destination)queue);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            TextMessage mess = session.createTextMessage("msg" + i);
            producer.send((Message)mess);
        }
        producer.close();
        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        connection.start();
        for (int i = 0; i < 99; ++i) {
            m = messageConsumer.receive(5000L);
            Assertions.assertNotNull((Object)m);
        }
        session.close();
        Queue q = (Queue)this.server.getPostOffice().getBinding(SimpleString.of((String)"test")).getBindable();
        Assertions.assertEquals((long)1L, (long)q.getMessageCount());
        Assertions.assertEquals((long)100L, (long)q.getMessagesAdded());
        session = connection.createSession(false, 1);
        messageConsumer = session.createConsumer((Destination)queue);
        m = messageConsumer.receive(5000L);
        Assertions.assertNotNull((Object)m);
        connection.close();
        Assertions.assertNotNull((Object)this.server.getPostOffice().getBinding(SimpleString.of((String)"test")));
    }

    @Test
    public void testAutoDeleteTopic() throws Exception {
        int i;
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        Topic topic = ActiveMQJMSClient.createTopic((String)"test");
        MessageConsumer messageConsumer = session.createConsumer((Destination)topic);
        MessageProducer producer = session.createProducer((Destination)topic);
        int numMessages = 100;
        for (i = 0; i < 100; ++i) {
            TextMessage mess = session.createTextMessage("msg" + i);
            producer.send((Message)mess);
        }
        producer.close();
        connection.start();
        for (i = 0; i < 100; ++i) {
            Message m = messageConsumer.receive(5000L);
            Assertions.assertNotNull((Object)m);
        }
        connection.close();
        SimpleString qName = SimpleString.of((String)"test");
        Wait.waitFor(() -> this.server.locateQueue(qName) == null);
        Assertions.assertNull((Object)this.server.locateQueue(qName));
        Assertions.assertNull((Object)this.server.getManagementService().getResource("jtest"));
    }

    @Test
    public void testAutoDeleteTopicNegative() throws Exception {
        int i;
        int numMessages = 100;
        SimpleString addressName = SimpleString.of((String)"test");
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(false)));
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(addressName.toString());
        MessageConsumer messageConsumer = session.createConsumer((Destination)topic);
        MessageProducer producer = session.createProducer((Destination)topic);
        for (i = 0; i < 100; ++i) {
            TextMessage mess = session.createTextMessage("msg" + i);
            producer.send((Message)mess);
        }
        producer.close();
        Assertions.assertNotNull((Object)this.server.getAddressInfo(addressName));
        connection.start();
        for (i = 0; i < 100; ++i) {
            Message m = messageConsumer.receive(5000L);
            Assertions.assertNotNull((Object)m);
        }
        connection.close();
        Assertions.assertFalse((boolean)Wait.waitFor(() -> this.server.getAddressInfo(addressName) == null, (long)2000L, (long)100L));
    }

    @Test
    public void testAutoDeleteTopicDurableSubscriber() throws Exception {
        int i;
        Connection connection = this.cf.createConnection();
        connection.setClientID("myClientID");
        Session session = connection.createSession(false, 1);
        Topic topic = ActiveMQJMSClient.createTopic((String)"test");
        MessageConsumer messageConsumer = session.createDurableConsumer(topic, "mySub");
        MessageProducer producer = session.createProducer((Destination)topic);
        int numMessages = 100;
        for (i = 0; i < 100; ++i) {
            TextMessage mess = session.createTextMessage("msg" + i);
            producer.send((Message)mess);
        }
        producer.close();
        connection.start();
        for (i = 0; i < 100; ++i) {
            Message m = messageConsumer.receive(5000L);
            Assertions.assertNotNull((Object)m);
        }
        messageConsumer.close();
        session.unsubscribe("mySub");
        connection.close();
        Assertions.assertNull((Object)this.server.locateQueue(SimpleString.of((String)"test")));
        Assertions.assertNull((Object)this.server.getManagementService().getResource("test"));
    }
}

