/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AutomaticColocatedQuorumVoteTest
extends ActiveMQTestBase {
    private final boolean replicated;

    @Parameters(name="replicated={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public AutomaticColocatedQuorumVoteTest(boolean replicated) {
        this.replicated = replicated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSimpleDistributionBackupStrategyFull() throws Exception {
        ActiveMQServer server0 = this.createServer(0, 1, false);
        ActiveMQServer server1 = this.createServer(1, 0, false);
        TransportConfiguration primaryConnector0 = this.getConnectorTransportConfiguration("primaryConnector0", 0);
        TransportConfiguration primaryConnector1 = this.getConnectorTransportConfiguration("primaryConnector1", 1);
        try (ServerLocator serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{primaryConnector0});){
            server0.start();
            server1.start();
            ClientSessionFactory sessionFactory0 = serverLocator.createSessionFactory(primaryConnector0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup(sessionFactory0, 10);
            ClientSessionFactory sessionFactory1 = serverLocator.createSessionFactory(primaryConnector1);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup(sessionFactory1, 10);
            Topology topology = serverLocator.getTopology();
            Collection members = topology.getMembers();
            Assertions.assertEquals((int)members.size(), (int)2);
            Map backupServers0 = server0.getClusterManager().getHAManager().getBackupServers();
            Assertions.assertEquals((int)backupServers0.size(), (int)1);
            Map backupServers1 = server1.getClusterManager().getHAManager().getBackupServers();
            Assertions.assertEquals((int)backupServers1.size(), (int)1);
            ActiveMQServer backupServer0 = (ActiveMQServer)backupServers0.values().iterator().next();
            ActiveMQServer backupServer1 = (ActiveMQServer)backupServers1.values().iterator().next();
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization(backupServer0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization(backupServer1);
            Assertions.assertEquals((Object)server0.getNodeID(), (Object)backupServer1.getNodeID());
            Assertions.assertEquals((Object)server1.getNodeID(), (Object)backupServer0.getNodeID());
            Set backupAcceptors0 = backupServer0.getConfiguration().getAcceptorConfigurations();
            Assertions.assertEquals((int)1, (int)backupAcceptors0.size());
            Assertions.assertEquals((Object)"61716", ((TransportConfiguration)backupAcceptors0.iterator().next()).getParams().get("port"));
            Set backupAcceptors1 = backupServer1.getConfiguration().getAcceptorConfigurations();
            Assertions.assertEquals((int)1, (int)backupAcceptors1.size());
            Assertions.assertEquals((Object)"61717", ((TransportConfiguration)backupAcceptors1.iterator().next()).getParams().get("port"));
            Map connectorConfigurations0 = backupServer0.getConfiguration().getConnectorConfigurations();
            Assertions.assertEquals((int)2, (int)connectorConfigurations0.size());
            Assertions.assertEquals((Object)"61716", ((TransportConfiguration)connectorConfigurations0.get("primaryConnector0")).getParams().get("port"));
            Assertions.assertEquals((Object)"61617", ((TransportConfiguration)connectorConfigurations0.get("remoteConnector0")).getParams().get("port"));
            Map connectorConfigurations1 = backupServer1.getConfiguration().getConnectorConfigurations();
            Assertions.assertEquals((int)2, (int)connectorConfigurations1.size());
            Assertions.assertEquals((Object)"61717", ((TransportConfiguration)connectorConfigurations1.get("primaryConnector1")).getParams().get("port"));
            Assertions.assertEquals((Object)"61616", ((TransportConfiguration)connectorConfigurations1.get("remoteConnector1")).getParams().get("port"));
            if (!this.replicated) {
                Assertions.assertEquals((Object)server0.getConfiguration().getJournalDirectory(), (Object)backupServer1.getConfiguration().getJournalDirectory());
                Assertions.assertEquals((Object)server0.getConfiguration().getBindingsDirectory(), (Object)backupServer1.getConfiguration().getBindingsDirectory());
                Assertions.assertEquals((Object)server0.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer1.getConfiguration().getLargeMessagesDirectory());
                Assertions.assertEquals((Object)server0.getConfiguration().getPagingDirectory(), (Object)backupServer1.getConfiguration().getPagingDirectory());
                Assertions.assertEquals((Object)server1.getConfiguration().getJournalDirectory(), (Object)backupServer0.getConfiguration().getJournalDirectory());
                Assertions.assertEquals((Object)server1.getConfiguration().getBindingsDirectory(), (Object)backupServer0.getConfiguration().getBindingsDirectory());
                Assertions.assertEquals((Object)server1.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer0.getConfiguration().getLargeMessagesDirectory());
                Assertions.assertEquals((Object)server1.getConfiguration().getPagingDirectory(), (Object)backupServer0.getConfiguration().getPagingDirectory());
            } else {
                Assertions.assertNotEquals((Object)server0.getConfiguration().getJournalDirectory(), (Object)backupServer1.getConfiguration().getJournalDirectory());
                Assertions.assertNotEquals((Object)server0.getConfiguration().getBindingsDirectory(), (Object)backupServer1.getConfiguration().getBindingsDirectory());
                Assertions.assertNotEquals((Object)server0.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer1.getConfiguration().getLargeMessagesDirectory());
                Assertions.assertNotEquals((Object)server0.getConfiguration().getPagingDirectory(), (Object)backupServer1.getConfiguration().getPagingDirectory());
                Assertions.assertNotEquals((Object)server1.getConfiguration().getJournalDirectory(), (Object)backupServer0.getConfiguration().getJournalDirectory());
                Assertions.assertNotEquals((Object)server1.getConfiguration().getBindingsDirectory(), (Object)backupServer0.getConfiguration().getBindingsDirectory());
                Assertions.assertNotEquals((Object)server1.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer0.getConfiguration().getLargeMessagesDirectory());
                Assertions.assertNotEquals((Object)server1.getConfiguration().getPagingDirectory(), (Object)backupServer0.getConfiguration().getPagingDirectory());
            }
        }
        finally {
            try {
                server0.stop();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSimpleDistributionBackupStrategyScaleDown() throws Exception {
        ActiveMQServer server0 = this.createServer(0, 1, true);
        ActiveMQServer server1 = this.createServer(1, 0, true);
        TransportConfiguration primaryConnector0 = this.getConnectorTransportConfiguration("primaryConnector0", 0);
        TransportConfiguration primaryConnector1 = this.getConnectorTransportConfiguration("primaryConnector1", 1);
        try (ServerLocator serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{primaryConnector0});){
            server0.start();
            server1.start();
            ClientSessionFactory sessionFactory0 = serverLocator.createSessionFactory(primaryConnector0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup(sessionFactory0, 10);
            ClientSessionFactory sessionFactory1 = serverLocator.createSessionFactory(primaryConnector1);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup(sessionFactory1, 10);
            Topology topology = serverLocator.getTopology();
            Collection members = topology.getMembers();
            Assertions.assertEquals((int)members.size(), (int)2);
            Map backupServers0 = server0.getClusterManager().getHAManager().getBackupServers();
            Assertions.assertEquals((int)backupServers0.size(), (int)1);
            Map backupServers1 = server1.getClusterManager().getHAManager().getBackupServers();
            Assertions.assertEquals((int)backupServers1.size(), (int)1);
            ActiveMQServer backupServer0 = (ActiveMQServer)backupServers0.values().iterator().next();
            ActiveMQServer backupServer1 = (ActiveMQServer)backupServers1.values().iterator().next();
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization(backupServer0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization(backupServer1);
            Assertions.assertEquals((Object)server0.getNodeID(), (Object)backupServer1.getNodeID());
            Assertions.assertEquals((Object)server1.getNodeID(), (Object)backupServer0.getNodeID());
            Set backupAcceptors0 = backupServer0.getConfiguration().getAcceptorConfigurations();
            Assertions.assertEquals((int)0, (int)backupAcceptors0.size());
            Set backupAcceptors1 = backupServer1.getConfiguration().getAcceptorConfigurations();
            Assertions.assertEquals((int)0, (int)backupAcceptors1.size());
            Map connectorConfigurations0 = backupServer0.getConfiguration().getConnectorConfigurations();
            Assertions.assertEquals((int)2, (int)connectorConfigurations0.size());
            Assertions.assertEquals((Object)"61616", ((TransportConfiguration)connectorConfigurations0.get("primaryConnector0")).getParams().get("port"));
            Assertions.assertEquals((Object)"61617", ((TransportConfiguration)connectorConfigurations0.get("remoteConnector0")).getParams().get("port"));
            Map connectorConfigurations1 = backupServer1.getConfiguration().getConnectorConfigurations();
            Assertions.assertEquals((int)2, (int)connectorConfigurations1.size());
            Assertions.assertEquals((Object)"61617", ((TransportConfiguration)connectorConfigurations1.get("primaryConnector1")).getParams().get("port"));
            Assertions.assertEquals((Object)"61616", ((TransportConfiguration)connectorConfigurations1.get("remoteConnector1")).getParams().get("port"));
            if (!this.replicated) {
                Assertions.assertEquals((Object)server0.getConfiguration().getJournalDirectory(), (Object)backupServer1.getConfiguration().getJournalDirectory());
                Assertions.assertEquals((Object)server0.getConfiguration().getBindingsDirectory(), (Object)backupServer1.getConfiguration().getBindingsDirectory());
                Assertions.assertEquals((Object)server0.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer1.getConfiguration().getLargeMessagesDirectory());
                Assertions.assertEquals((Object)server0.getConfiguration().getPagingDirectory(), (Object)backupServer1.getConfiguration().getPagingDirectory());
                Assertions.assertEquals((Object)server1.getConfiguration().getJournalDirectory(), (Object)backupServer0.getConfiguration().getJournalDirectory());
                Assertions.assertEquals((Object)server1.getConfiguration().getBindingsDirectory(), (Object)backupServer0.getConfiguration().getBindingsDirectory());
                Assertions.assertEquals((Object)server1.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer0.getConfiguration().getLargeMessagesDirectory());
                Assertions.assertEquals((Object)server1.getConfiguration().getPagingDirectory(), (Object)backupServer0.getConfiguration().getPagingDirectory());
            } else {
                Assertions.assertNotEquals((Object)server0.getConfiguration().getJournalDirectory(), (Object)backupServer1.getConfiguration().getJournalDirectory());
                Assertions.assertNotEquals((Object)server0.getConfiguration().getBindingsDirectory(), (Object)backupServer1.getConfiguration().getBindingsDirectory());
                Assertions.assertNotEquals((Object)server0.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer1.getConfiguration().getLargeMessagesDirectory());
                Assertions.assertNotEquals((Object)server0.getConfiguration().getPagingDirectory(), (Object)backupServer1.getConfiguration().getPagingDirectory());
                Assertions.assertNotEquals((Object)server1.getConfiguration().getJournalDirectory(), (Object)backupServer0.getConfiguration().getJournalDirectory());
                Assertions.assertNotEquals((Object)server1.getConfiguration().getBindingsDirectory(), (Object)backupServer0.getConfiguration().getBindingsDirectory());
                Assertions.assertNotEquals((Object)server1.getConfiguration().getLargeMessagesDirectory(), (Object)backupServer0.getConfiguration().getLargeMessagesDirectory());
                Assertions.assertNotEquals((Object)server1.getConfiguration().getPagingDirectory(), (Object)backupServer0.getConfiguration().getPagingDirectory());
            }
        }
        finally {
            try {
                server0.stop();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            server1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSimpleDistributionOfBackupsMaxBackupsExceeded() throws Exception {
        ActiveMQServer server0 = this.createServer(0, 1, false);
        ActiveMQServer server1 = this.createServer(1, 0, false);
        ActiveMQServer server2 = this.createServer(2, 0, false);
        ActiveMQServer server3 = this.createServer(3, 0, false);
        TransportConfiguration primaryConnector0 = this.getConnectorTransportConfiguration("primaryConnector0", 0);
        TransportConfiguration primaryConnector1 = this.getConnectorTransportConfiguration("primaryConnector1", 1);
        TransportConfiguration primaryConnector2 = this.getConnectorTransportConfiguration("primaryConnector2", 2);
        TransportConfiguration primaryConnector3 = this.getConnectorTransportConfiguration("primaryConnector3", 3);
        try (ServerLocator serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{primaryConnector0});){
            server0.start();
            server1.start();
            ClientSessionFactory sessionFactory0 = serverLocator.createSessionFactory(primaryConnector0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup(sessionFactory0, 10);
            ClientSessionFactory sessionFactory1 = serverLocator.createSessionFactory(primaryConnector1);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup(sessionFactory1, 10);
            Topology topology = serverLocator.getTopology();
            Collection members = topology.getMembers();
            Assertions.assertEquals((int)members.size(), (int)2);
            Map backupServers0 = server0.getClusterManager().getHAManager().getBackupServers();
            Assertions.assertEquals((int)backupServers0.size(), (int)1);
            Map backupServers1 = server1.getClusterManager().getHAManager().getBackupServers();
            Assertions.assertEquals((int)backupServers1.size(), (int)1);
            ActiveMQServer backupServer0 = (ActiveMQServer)backupServers0.values().iterator().next();
            ActiveMQServer backupServer1 = (ActiveMQServer)backupServers1.values().iterator().next();
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization(backupServer0);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization(backupServer1);
            Assertions.assertEquals((Object)server0.getNodeID(), (Object)backupServer1.getNodeID());
            Assertions.assertEquals((Object)server1.getNodeID(), (Object)backupServer0.getNodeID());
            server2.start();
            ClientSessionFactory sessionFactory2 = serverLocator.createSessionFactory(primaryConnector2);
            server3.start();
            ClientSessionFactory sessionFactory3 = serverLocator.createSessionFactory(primaryConnector3);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup(sessionFactory2, 10);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackup(sessionFactory3, 10);
            Assertions.assertEquals((int)members.size(), (int)2);
            Map backupServers2 = server2.getClusterManager().getHAManager().getBackupServers();
            Assertions.assertEquals((int)backupServers2.size(), (int)1);
            Map backupServers3 = server3.getClusterManager().getHAManager().getBackupServers();
            Assertions.assertEquals((int)backupServers3.size(), (int)1);
            ActiveMQServer backupServer2 = (ActiveMQServer)backupServers2.values().iterator().next();
            ActiveMQServer backupServer3 = (ActiveMQServer)backupServers3.values().iterator().next();
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization(backupServer2);
            AutomaticColocatedQuorumVoteTest.waitForRemoteBackupSynchronization(backupServer3);
            Assertions.assertEquals((Object)server0.getNodeID(), (Object)backupServer1.getNodeID());
            Assertions.assertEquals((Object)server1.getNodeID(), (Object)backupServer0.getNodeID());
            Assertions.assertEquals((Object)server2.getNodeID(), (Object)backupServer3.getNodeID());
            Assertions.assertEquals((Object)server3.getNodeID(), (Object)backupServer2.getNodeID());
        }
        finally {
            server0.stop();
            server1.stop();
            server2.stop();
            server3.stop();
        }
    }

    private ActiveMQServer createServer(int node, int remoteNode, boolean scaleDown) throws Exception {
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration("primaryConnector" + node, node);
        TransportConfiguration remoteConnector = this.getConnectorTransportConfiguration("remoteConnector" + node, remoteNode);
        TransportConfiguration primaryAcceptor = this.getAcceptorTransportConfiguration(node);
        Configuration liveConfiguration = this.getConfiguration("server" + node, scaleDown, primaryConnector, primaryAcceptor, remoteConnector);
        ActiveMQServerImpl server = new ActiveMQServerImpl(liveConfiguration);
        server.setIdentity("server" + node);
        return server;
    }

    private Configuration getConfiguration(String identity, boolean scaleDown, TransportConfiguration primaryConnector, TransportConfiguration primaryAcceptor, TransportConfiguration ... otherPrimaryNodes) throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(primaryAcceptor).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).setJournalDirectory(this.getJournalDir() + identity).setBindingsDirectory(this.getBindingsDir() + identity).setLargeMessagesDirectory(this.getLargeMessagesDir() + identity).setPagingDirectory(this.getPageDir() + identity).addQueueConfiguration(QueueConfiguration.of((String)"testQueue"));
        ArrayList<String> transportConfigurationList = new ArrayList<String>();
        ColocatedPolicyConfiguration haPolicy = new ColocatedPolicyConfiguration();
        for (TransportConfiguration otherPrimaryNode : otherPrimaryNodes) {
            configuration.addConnectorConfiguration(otherPrimaryNode.getName(), otherPrimaryNode);
            transportConfigurationList.add(otherPrimaryNode.getName());
            haPolicy.getExcludedConnectors().add(otherPrimaryNode.getName());
        }
        String[] input = new String[transportConfigurationList.size()];
        transportConfigurationList.toArray(input);
        configuration.addClusterConfiguration(AutomaticColocatedQuorumVoteTest.basicClusterConnectionConfig(primaryConnector.getName(), input));
        haPolicy.setBackupPortOffset(100);
        haPolicy.setBackupRequestRetries(-1);
        haPolicy.setBackupRequestRetryInterval(500L);
        haPolicy.setMaxBackups(1);
        haPolicy.setRequestBackup(true);
        configuration.setHAPolicyConfiguration((HAPolicyConfiguration)haPolicy);
        if (!this.replicated) {
            SharedStorePrimaryPolicyConfiguration ssmc = new SharedStorePrimaryPolicyConfiguration();
            SharedStoreBackupPolicyConfiguration sssc = new SharedStoreBackupPolicyConfiguration();
            haPolicy.setPrimaryConfig((HAPolicyConfiguration)ssmc);
            haPolicy.setBackupConfig((HAPolicyConfiguration)sssc);
            if (scaleDown) {
                sssc.setScaleDownConfiguration(new ScaleDownConfiguration());
            }
        } else {
            ReplicatedPolicyConfiguration rpc = new ReplicatedPolicyConfiguration();
            ReplicaPolicyConfiguration rpc2 = new ReplicaPolicyConfiguration();
            haPolicy.setPrimaryConfig((HAPolicyConfiguration)rpc);
            haPolicy.setBackupConfig((HAPolicyConfiguration)rpc2);
            if (scaleDown) {
                rpc2.setScaleDownConfiguration(new ScaleDownConfiguration());
            }
        }
        return configuration;
    }

    private TransportConfiguration getAcceptorTransportConfiguration(int node) {
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        params.put("port", (CallSite)((Object)("" + (61616 + node))));
        return new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params);
    }

    private TransportConfiguration getConnectorTransportConfiguration(String name, int node) {
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        params.put("port", (CallSite)((Object)("" + (61616 + node))));
        return new TransportConfiguration(NETTY_CONNECTOR_FACTORY, params, name);
    }
}

