/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.cluster;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.JMSClusteredTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class LargeMessageOverBridgeTest
extends JMSClusteredTestBase {
    public static final String QUEUE = "jms.Q1";
    private final boolean persistent;

    @Override
    protected boolean enablePersistence() {
        return this.persistent;
    }

    @Parameters(name="persistent={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    protected final ConfigurationImpl createBasicConfig(int serverID) {
        ConfigurationImpl configuration = super.createBasicConfig(serverID);
        configuration.setJournalFileSize(0x100000);
        return configuration;
    }

    public LargeMessageOverBridgeTest(boolean persistent) {
        this.persistent = persistent;
    }

    @TestTemplate
    public void testSendHalfLargeTextMessage() throws Exception {
        int i;
        this.createQueue(QUEUE);
        Queue queue = (Queue)this.context1.lookup("queue/jms.Q1");
        Connection conn1 = this.cf1.createConnection();
        Session session1 = conn1.createSession(false, 1);
        MessageProducer prod1 = session1.createProducer((Destination)queue);
        Connection conn2 = this.cf2.createConnection();
        Session session2 = conn2.createSession(false, 1);
        MessageConsumer cons2 = session2.createConsumer((Destination)queue);
        conn2.start();
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < 51180; ++i) {
            buffer.append('a');
        }
        for (i = 0; i < 10; ++i) {
            TextMessage msg = session1.createTextMessage(buffer.toString());
            prod1.send((Message)msg);
        }
        TextMessage msg2 = (TextMessage)cons2.receive(5000L);
        Assertions.assertNotNull((Object)msg2);
        Assertions.assertEquals((Object)buffer.toString(), (Object)msg2.getText());
        conn1.close();
        conn2.close();
    }

    @TestTemplate
    public void testSendMapMessageOverCluster() throws Exception {
        MapMessage msg;
        int i;
        this.createQueue("jms.jms.Q1");
        Queue queue = (Queue)this.context1.lookup("queue/jms.jms.Q1");
        Connection conn1 = this.cf1.createConnection();
        Session session1 = conn1.createSession(false, 1);
        MessageProducer prod1 = session1.createProducer((Destination)queue);
        Connection conn2 = this.cf2.createConnection();
        Session session2 = conn2.createSession(false, 1);
        MessageConsumer cons2 = session2.createConsumer((Destination)queue);
        conn2.start();
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < 3810002; ++i2) {
            buffer.append('a');
        }
        boolean NUMBER_OF_MESSAGES = true;
        for (i = 0; i < 1; ++i) {
            msg = session1.createMapMessage();
            msg.setString("str", buffer.toString());
            msg.setIntProperty("i", i);
            prod1.send((Message)msg);
        }
        for (i = 0; i < 1; ++i) {
            msg = (MapMessage)cons2.receive(5000L);
            Assertions.assertEquals((Object)buffer.toString(), (Object)msg.getString("str"));
        }
        Assertions.assertNull((Object)cons2.receiveNoWait());
        conn1.close();
        conn2.close();
    }

    private void installHack(Configuration config) {
        if (this.getName().equals("testSendBytesAsLargeOnBridgeOnly")) {
            for (ClusterConnectionConfiguration conn : config.getClusterConfigurations()) {
                conn.setMinLargeMessageSize(1000);
            }
        }
    }

    @Override
    protected Configuration createConfigServer(int source, int destination) throws Exception {
        Configuration config = super.createConfigServer(source, destination);
        this.installHack(config);
        return config;
    }

    @TestTemplate
    public void testSendBytesAsLargeOnBridgeOnly() throws Exception {
        int i;
        this.createQueue(QUEUE);
        Queue queue = (Queue)this.context1.lookup("queue/jms.Q1");
        Connection conn1 = this.cf1.createConnection();
        Session session1 = conn1.createSession(true, 0);
        MessageProducer prod1 = session1.createProducer((Destination)queue);
        Connection conn2 = this.cf2.createConnection();
        Session session2 = conn2.createSession(false, 1);
        MessageConsumer cons2 = session2.createConsumer((Destination)queue);
        conn2.start();
        byte[] bytes = new byte[10240];
        for (i = 0; i < bytes.length; ++i) {
            bytes[i] = LargeMessageOverBridgeTest.getSamplebyte(i);
        }
        for (i = 0; i < 10; ++i) {
            BytesMessage msg = session1.createBytesMessage();
            msg.writeBytes(bytes);
            prod1.send((Message)msg);
        }
        session1.commit();
        for (i = 0; i < 5; ++i) {
            BytesMessage msg2 = (BytesMessage)cons2.receive(5000L);
            Assertions.assertNotNull((Object)msg2);
            msg2.acknowledge();
            for (int j = 0; j < bytes.length; ++j) {
                Assertions.assertEquals((byte)msg2.readByte(), (byte)bytes[j], (String)("Position " + i));
            }
        }
        conn1.close();
        conn2.close();
    }

    @TestTemplate
    public void testSendLargeForBridge() throws Exception {
        int i;
        this.createQueue(QUEUE);
        Queue queue = (Queue)this.context1.lookup("queue/jms.Q1");
        ActiveMQConnectionFactory cf1 = ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY, this.generateInVMParams(1))});
        cf1.setMinLargeMessageSize(204800);
        Connection conn1 = cf1.createConnection();
        Session session1 = conn1.createSession(true, 0);
        MessageProducer prod1 = session1.createProducer((Destination)queue);
        Connection conn2 = this.cf2.createConnection();
        Session session2 = conn2.createSession(false, 1);
        MessageConsumer cons2 = session2.createConsumer((Destination)queue);
        conn2.start();
        byte[] bytes = new byte[153600];
        for (i = 0; i < bytes.length; ++i) {
            bytes[i] = LargeMessageOverBridgeTest.getSamplebyte(i);
        }
        for (i = 0; i < 10; ++i) {
            BytesMessage msg = session1.createBytesMessage();
            msg.writeBytes(bytes);
            prod1.send((Message)msg);
        }
        session1.commit();
        for (i = 0; i < 5; ++i) {
            BytesMessage msg2 = (BytesMessage)cons2.receive(5000L);
            Assertions.assertNotNull((Object)msg2);
            msg2.acknowledge();
            for (int j = 0; j < bytes.length; ++j) {
                Assertions.assertEquals((byte)msg2.readByte(), (byte)bytes[j], (String)("Position " + i));
            }
        }
        conn1.close();
        conn2.close();
    }
}

