/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5;

import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import jakarta.jms.ConnectionFactory;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.remoting.impl.AbstractAcceptor;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTT5TestSupport
extends ActiveMQTestBase {
    protected static final String TCP = "tcp";
    protected static final String WS = "ws";
    protected static final String SSL = "ssl";
    protected static final String WSS = "wss";
    protected static final SimpleString DEAD_LETTER_ADDRESS = SimpleString.of((String)"DLA");
    protected static final SimpleString EXPIRY_ADDRESS = SimpleString.of((String)"EXPIRY");
    protected static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final long DEFAULT_TIMEOUT_SEC = 60L;
    protected ActiveMQServer server;
    protected int port = 1883;
    protected int sslPort = 8883;
    protected ConnectionFactory cf;
    protected LinkedList<Throwable> exceptions = new LinkedList();
    protected boolean persistent;
    protected String protocolScheme = "mqtt";
    protected static final int NUM_MESSAGES = 250;
    public static final int AT_MOST_ONCE = 0;
    public static final int AT_LEAST_ONCE = 1;
    public static final int EXACTLY_ONCE = 2;
    protected String noprivUser = "noprivs";
    protected String noprivPass = "noprivs";
    protected String createAddressUser = "createAddress";
    protected String createAddressPass = "createAddress";
    protected String browseUser = "browser";
    protected String browsePass = "browser";
    protected String guestUser = "guest";
    protected String guestPass = "guest";
    protected String fullUser = "user";
    protected String fullPass = "pass";
    protected String noDeleteUser = "noDelete";
    protected String noDeletePass = "noDelete";

    protected MqttClient createPahoClient(String clientId) throws org.eclipse.paho.mqttv5.common.MqttException {
        return this.createPahoClient(TCP, clientId);
    }

    protected MqttClient createPahoClient(String protocol, String clientId) throws org.eclipse.paho.mqttv5.common.MqttException {
        return this.createPahoClient(protocol, clientId, this.isUseSsl() ? this.getSslPort() : this.getPort());
    }

    protected MqttClient createPahoClient(String clientId, int port) throws org.eclipse.paho.mqttv5.common.MqttException {
        return this.createPahoClient(TCP, clientId, port);
    }

    protected MqttClient createPahoClient(String protocol, String clientId, int port) throws org.eclipse.paho.mqttv5.common.MqttException {
        return new MqttClient(protocol + "://localhost:" + port, clientId, (org.eclipse.paho.mqttv5.client.MqttClientPersistence)new org.eclipse.paho.mqttv5.client.persist.MemoryPersistence());
    }

    protected org.eclipse.paho.client.mqttv3.MqttClient createPaho3_1_1Client(String clientId) throws MqttException {
        return new org.eclipse.paho.client.mqttv3.MqttClient("tcp://localhost:" + (this.isUseSsl() ? this.getSslPort() : this.getPort()), clientId, (MqttClientPersistence)new MemoryPersistence());
    }

    protected MqttAsyncClient createAsyncPahoClient(String clientId) throws org.eclipse.paho.mqttv5.common.MqttException {
        return new MqttAsyncClient("tcp://localhost:" + (this.isUseSsl() ? this.getSslPort() : this.getPort()), clientId, (org.eclipse.paho.mqttv5.client.MqttClientPersistence)new org.eclipse.paho.mqttv5.client.persist.MemoryPersistence());
    }

    public File basedir() throws IOException {
        ProtectionDomain protectionDomain = ((Object)((Object)this)).getClass().getProtectionDomain();
        return new File(new File(protectionDomain.getCodeSource().getLocation().getPath()), "../..").getCanonicalFile();
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.exceptions.clear();
        this.startBroker();
        this.createJMSConnection();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.stopBroker();
        super.tearDown();
    }

    public void configureBroker() throws Exception {
        super.setUp();
        this.server = this.createServerForMQTT();
        this.addCoreConnector();
        this.addMQTTConnector();
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setMaxSizeBytes(999999999L);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(true));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(true));
        this.configureBrokerSecurity(this.server);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.server.getConfiguration().setMessageExpiryScanPeriod(500L);
    }

    protected void configureBrokerSecurity(ActiveMQServer server) {
        if (this.isSecurityEnabled()) {
            ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
            securityManager.getConfiguration().addUser(this.noprivUser, this.noprivPass);
            securityManager.getConfiguration().addRole(this.noprivUser, "nothing");
            securityManager.getConfiguration().addUser(this.createAddressUser, this.createAddressPass);
            securityManager.getConfiguration().addRole(this.createAddressUser, "createAddress");
            securityManager.getConfiguration().addUser(this.browseUser, this.browsePass);
            securityManager.getConfiguration().addRole(this.browseUser, "browser");
            securityManager.getConfiguration().addUser(this.guestUser, this.guestPass);
            securityManager.getConfiguration().addRole(this.guestUser, "guest");
            securityManager.getConfiguration().addUser(this.fullUser, this.fullPass);
            securityManager.getConfiguration().addRole(this.fullUser, "full");
            securityManager.getConfiguration().addUser(this.noDeleteUser, this.noDeleteUser);
            securityManager.getConfiguration().addRole(this.noDeleteUser, "noDelete");
            HierarchicalRepository securityRepository = server.getSecurityRepository();
            HashSet<Role> value = new HashSet<Role>();
            value.add(new Role("nothing", false, false, false, false, false, false, false, false, false, false, false, false));
            value.add(new Role("browser", false, false, false, false, false, false, false, true, false, false, false, false));
            value.add(new Role("guest", false, true, false, false, false, false, false, true, false, false, false, false));
            value.add(new Role("full", true, true, true, true, true, true, true, true, true, true, false, false));
            value.add(new Role("createAddress", false, false, false, false, false, false, false, false, true, false, false, false));
            value.add(new Role("noDelete", true, true, true, false, true, false, true, true, true, true, false, false));
            securityRepository.addMatch("#", value);
            server.getConfiguration().setSecurityEnabled(true);
        } else {
            server.getConfiguration().setSecurityEnabled(false);
        }
    }

    public void startBroker() throws Exception {
        this.configureBroker();
        this.server.start();
        this.server.waitForActivation(10L, TimeUnit.SECONDS);
    }

    public void createJMSConnection() throws Exception {
        this.cf = new ActiveMQConnectionFactory(false, new TransportConfiguration[]{new TransportConfiguration(ActiveMQTestBase.NETTY_CONNECTOR_FACTORY)});
    }

    private ActiveMQServer createServerForMQTT() throws Exception {
        Configuration defaultConfig = this.createDefaultConfig(true).setIncomingInterceptorClassNames(Collections.singletonList(MQTTIncomingInterceptor.class.getName())).setOutgoingInterceptorClassNames(Collections.singletonList(MQTTOutoingInterceptor.class.getName()));
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setDeadLetterAddress(DEAD_LETTER_ADDRESS);
        addressSettings.setExpiryAddress(EXPIRY_ADDRESS);
        defaultConfig.getAddressSettings().put("#", addressSettings);
        defaultConfig.setMqttSessionScanInterval(200L);
        return this.createServer(true, defaultConfig);
    }

    protected void addCoreConnector() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("port", "5445");
        params.put("protocols", "CORE");
        TransportConfiguration transportConfiguration = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params);
        this.server.getConfiguration().getAcceptorConfigurations().add(transportConfiguration);
        logger.debug("Added CORE connector to broker");
    }

    protected void addMQTTConnector() throws Exception {
        this.server.getConfiguration().addAcceptorConfiguration("MQTT", "tcp://localhost:" + (this.isUseSsl() ? this.sslPort : this.port) + "?protocols=MQTT;anycastPrefix=anycast:;multicastPrefix=multicast:" + (this.isUseSsl() ? "&sslEnabled=true&keyStorePath=server-keystore.p12&keyStorePassword=securepass" : "") + (this.isMutualSsl() ? "&needClientAuth=true&trustStorePath=client-ca-truststore.p12&trustStorePassword=securepass" : ""));
        this.server.getConfiguration().setConnectionTtlCheckInterval(100L);
        logger.debug("Added MQTT connector to broker");
    }

    public void stopBroker() throws Exception {
        if (this.server.isStarted()) {
            this.server.stop();
            this.server = null;
        }
    }

    protected String getQueueName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getTestMethodName();
    }

    protected String getTopicName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getTestMethodName();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public int getPort() {
        return this.port;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public boolean isSecurityEnabled() {
        return false;
    }

    public boolean isUseSsl() {
        return false;
    }

    public boolean isMutualSsl() {
        return false;
    }

    public Map<String, MQTTSessionState> getSessionStates() {
        MQTTProtocolManager protocolManager = this.getProtocolManager();
        if (protocolManager == null) {
            return Collections.emptyMap();
        }
        return protocolManager.getStateManager().getSessionStates();
    }

    public void scanSessions() {
        this.getProtocolManager().getStateManager().scanSessions();
    }

    public MQTTProtocolManager getProtocolManager() {
        ProtocolManager protocolManager;
        Acceptor acceptor = this.server.getRemotingService().getAcceptor("MQTT");
        if (acceptor instanceof AbstractAcceptor && (protocolManager = (ProtocolManager)((AbstractAcceptor)acceptor).getProtocolMap().get("MQTT")) instanceof MQTTProtocolManager) {
            return (MQTTProtocolManager)protocolManager;
        }
        return null;
    }

    protected Queue getSharedSubscriptionQueue(String mqttTopicFilter) {
        return this.getSubscriptionQueue(mqttTopicFilter, null);
    }

    protected Queue getSubscriptionQueue(String mqttTopicFilter, String clientId) {
        return this.server.locateQueue(MQTTUtil.getCoreQueueFromMqttTopic((String)mqttTopicFilter, (String)clientId, (WildcardConfiguration)this.server.getConfiguration().getWildcardConfiguration()));
    }

    protected Queue getRetainedMessageQueue(String mqttTopicFilter) {
        return this.server.locateQueue(MQTTUtil.getCoreRetainAddressFromMqttTopic((String)mqttTopicFilter, (WildcardConfiguration)this.server.getConfiguration().getWildcardConfiguration()));
    }

    protected void setAcceptorProperty(String property) throws Exception {
        this.server.getRemotingService().getAcceptor("MQTT").stop();
        this.server.getRemotingService().createAcceptor("MQTT", "tcp://localhost:" + this.port + "?protocols=MQTT;" + property).start();
    }

    protected MqttConnectionOptions getSslMqttConnectOptions() {
        MqttConnectionOptions connectionOptions = new MqttConnectionOptions();
        Properties properties = new Properties();
        properties.setProperty("com.ibm.ssl.trustStore", ClassloadingUtil.findResource((String)"server-ca-truststore.p12").getPath());
        properties.setProperty("com.ibm.ssl.trustStorePassword", "securepass");
        if (this.isMutualSsl()) {
            properties.setProperty("com.ibm.ssl.keyStore", ClassloadingUtil.findResource((String)"client-keystore.p12").getPath());
            properties.setProperty("com.ibm.ssl.keyStorePassword", "securepass");
        }
        connectionOptions.setSSLProperties(properties);
        return connectionOptions;
    }

    public static class MQTTIncomingInterceptor
    implements MQTTInterceptor {
        private static int messageCount = 0;

        public boolean intercept(MqttMessage packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getClass() == MqttPublishMessage.class) {
                ++messageCount;
            }
            return true;
        }

        public static void clear() {
            messageCount = 0;
        }

        public static int getMessageCount() {
            return messageCount;
        }
    }

    public static class MQTTOutoingInterceptor
    implements MQTTInterceptor {
        private static int messageCount = 0;

        public boolean intercept(MqttMessage packet, RemotingConnection connection) throws ActiveMQException {
            if (packet.getClass() == MqttPublishMessage.class) {
                ++messageCount;
            }
            return true;
        }

        public static void clear() {
            messageCount = 0;
        }

        public static int getMessageCount() {
            return messageCount;
        }
    }

    protected class LatchedMqttCallback
    implements DefaultMqttCallback {
        CountDownLatch latch;
        boolean fail;

        public LatchedMqttCallback(CountDownLatch latch) {
            this.latch = latch;
            this.fail = false;
        }

        public LatchedMqttCallback(CountDownLatch latch, boolean fail) {
            this.latch = latch;
            this.fail = fail;
        }

        @Override
        public void messageArrived(String topic, org.eclipse.paho.mqttv5.common.MqttMessage message) throws Exception {
            System.out.println("Message arrived: " + message);
            this.latch.countDown();
            if (this.fail) {
                throw new Exception();
            }
        }
    }

    protected static interface DefaultMqttCallback
    extends MqttCallback {
        default public void disconnected(MqttDisconnectResponse disconnectResponse) {
        }

        default public void mqttErrorOccurred(org.eclipse.paho.mqttv5.common.MqttException exception) {
        }

        default public void messageArrived(String topic, org.eclipse.paho.mqttv5.common.MqttMessage message) throws Exception {
        }

        default public void deliveryComplete(IMqttToken token) {
        }

        default public void connectComplete(boolean reconnect, String serverURI) {
        }

        default public void authPacketArrived(int reasonCode, MqttProperties properties) {
        }
    }

    protected static interface Task {
        public void run() throws Exception;
    }
}

