/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.config.PersistedSecuritySetting;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PersistedSecuritySettingTest {
    @Test
    public void testNPE() {
        PersistedSecuritySetting persistedSecuritySetting = new PersistedSecuritySetting();
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)persistedSecuritySetting.getEncodeSize());
        persistedSecuritySetting.encode(buffer);
        persistedSecuritySetting.decode(buffer);
        persistedSecuritySetting.getBrowseRoles();
        persistedSecuritySetting.getConsumeRoles();
        persistedSecuritySetting.getCreateAddressRoles();
        persistedSecuritySetting.getCreateDurableQueueRoles();
        persistedSecuritySetting.getCreateNonDurableQueueRoles();
        persistedSecuritySetting.getDeleteAddressRoles();
        persistedSecuritySetting.getDeleteDurableQueueRoles();
        persistedSecuritySetting.getDeleteNonDurableQueueRoles();
        persistedSecuritySetting.getManageRoles();
        persistedSecuritySetting.getSendRoles();
        persistedSecuritySetting.getViewRoles();
        persistedSecuritySetting.getEditRoles();
    }

    @Test
    public void testUpgradeAfterARTEMIS_4582() {
        SimpleString match = RandomUtil.randomSimpleString();
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)(SimpleString.sizeofNullableString((SimpleString)match) + 10));
        buffer.writeSimpleString(match);
        for (int i = 0; i < 10; ++i) {
            buffer.writeNullableSimpleString(null);
        }
        PersistedSecuritySetting persistedSecuritySetting = new PersistedSecuritySetting();
        persistedSecuritySetting.decode(buffer);
        Assertions.assertEquals((Object)match, (Object)persistedSecuritySetting.getAddressMatch());
        Assertions.assertNull((Object)persistedSecuritySetting.getBrowseRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getConsumeRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getCreateAddressRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getCreateDurableQueueRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getCreateNonDurableQueueRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getDeleteAddressRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getDeleteDurableQueueRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getDeleteNonDurableQueueRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getManageRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getSendRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getViewRoles());
        Assertions.assertNull((Object)persistedSecuritySetting.getEditRoles());
    }
}

