/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QueueQueryTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
    }

    @Test
    public void testQueueQueryDefaultsOnStaticQueue() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName));
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueName);
        Assertions.assertTrue((boolean)queueQueryResult.isExists());
        Assertions.assertEquals((Object)RoutingType.MULTICAST, (Object)queueQueryResult.getRoutingType());
        Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        Assertions.assertTrue((boolean)queueQueryResult.isAutoCreateQueues());
        Assertions.assertNull((Object)queueQueryResult.getFilterString());
        Assertions.assertFalse((boolean)queueQueryResult.isAutoCreated());
        Assertions.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
        Assertions.assertEquals((long)0L, (long)queueQueryResult.getMessageCount());
        Assertions.assertEquals((int)0, (int)queueQueryResult.getConsumerCount());
        Assertions.assertEquals((int)-1, (int)queueQueryResult.getMaxConsumers());
        Assertions.assertEquals((int)0, (int)queueQueryResult.getConsumersBeforeDispatch());
        Assertions.assertEquals((int)0x100000, (int)queueQueryResult.getDefaultConsumerWindowSize());
        Assertions.assertEquals((long)-1L, (long)queueQueryResult.getDelayBeforeDispatch());
        Assertions.assertNull((Object)queueQueryResult.getLastValueKey());
        Assertions.assertTrue((boolean)queueQueryResult.isDurable());
        Assertions.assertFalse((boolean)queueQueryResult.isPurgeOnNoConsumers());
        Assertions.assertFalse((boolean)queueQueryResult.isTemporary());
        Assertions.assertFalse((boolean)queueQueryResult.isExclusive());
        Assertions.assertFalse((boolean)queueQueryResult.isNonDestructive());
    }

    @Test
    public void testQueueQueryOnStaticQueueWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.of((String)"myAddress");
        SimpleString queueName = SimpleString.of((String)"myQueue");
        SimpleString fqqn = addressName.concat("::").concat(queueName);
        this.server.createQueue(QueueConfiguration.of((SimpleString)fqqn));
        QueueQueryResult queueQueryResult = this.server.queueQuery(fqqn);
        Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        Assertions.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
        queueQueryResult = this.server.queueQuery(queueName);
        Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        Assertions.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
    }

    @Test
    public void testQueueQueryNonDefaultsOnStaticQueue() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString filter = SimpleString.of((String)"x = 'y'");
        SimpleString lastValueKey = SimpleString.of((String)"myLastValueKey");
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setDefaultMaxConsumers(Integer.valueOf(1)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)).setDefaultConsumersBeforeDispatch(Integer.valueOf(13)).setDefaultConsumerWindowSize(51).setDefaultDelayBeforeDispatch(Long.valueOf(19L)).setDefaultLastValueQueue(true).setDefaultLastValueKey(lastValueKey).setDefaultExclusiveQueue(Boolean.valueOf(true)).setDefaultNonDestructive(true));
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(addressName).setRoutingType(RoutingType.ANYCAST).setFilterString(filter).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueName);
        Assertions.assertTrue((boolean)queueQueryResult.isExists());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)queueQueryResult.getRoutingType());
        Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        Assertions.assertTrue((boolean)queueQueryResult.isAutoCreateQueues());
        Assertions.assertEquals((Object)filter, (Object)queueQueryResult.getFilterString());
        Assertions.assertFalse((boolean)queueQueryResult.isAutoCreated());
        Assertions.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
        Assertions.assertEquals((long)0L, (long)queueQueryResult.getMessageCount());
        Assertions.assertEquals((int)0, (int)queueQueryResult.getConsumerCount());
        Assertions.assertEquals((int)1, (int)queueQueryResult.getMaxConsumers());
        Assertions.assertEquals((int)13, (int)queueQueryResult.getConsumersBeforeDispatch());
        Assertions.assertEquals((int)51, (int)queueQueryResult.getDefaultConsumerWindowSize());
        Assertions.assertEquals((long)19L, (long)queueQueryResult.getDelayBeforeDispatch());
        Assertions.assertTrue((boolean)queueQueryResult.isLastValue());
        Assertions.assertEquals((Object)lastValueKey, (Object)queueQueryResult.getLastValueKey());
        Assertions.assertFalse((boolean)queueQueryResult.isDurable());
        Assertions.assertTrue((boolean)queueQueryResult.isPurgeOnNoConsumers());
        Assertions.assertTrue((boolean)queueQueryResult.isTemporary());
        Assertions.assertTrue((boolean)queueQueryResult.isExclusive());
        Assertions.assertTrue((boolean)queueQueryResult.isNonDestructive());
    }

    @Test
    public void testQueueQueryDefaultsOnAutoCreatedQueue() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        this.server.getAddressSettingsRepository().addMatch(queueName.toString(), (Object)new AddressSettings());
        JMSContext c = new ActiveMQConnectionFactory("vm://0").createContext();
        c.createProducer().send((Destination)c.createQueue(queueName.toString()), c.createMessage());
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(queueName)).getMessageCount());
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueName);
        Assertions.assertTrue((boolean)queueQueryResult.isAutoCreateQueues());
        Assertions.assertNull((Object)queueQueryResult.getFilterString());
        Assertions.assertTrue((boolean)queueQueryResult.isAutoCreated());
        Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getAddress());
        Assertions.assertEquals((long)1L, (long)queueQueryResult.getMessageCount());
        Assertions.assertEquals((int)0, (int)queueQueryResult.getConsumerCount());
        Assertions.assertEquals((int)-1, (int)queueQueryResult.getMaxConsumers());
        Assertions.assertEquals((int)0, (int)queueQueryResult.getConsumersBeforeDispatch());
        Assertions.assertEquals((int)0x100000, (int)queueQueryResult.getDefaultConsumerWindowSize());
        Assertions.assertEquals((long)-1L, (long)queueQueryResult.getDelayBeforeDispatch());
        Assertions.assertNull((Object)queueQueryResult.getLastValueKey());
        Assertions.assertTrue((boolean)queueQueryResult.isDurable());
        Assertions.assertFalse((boolean)queueQueryResult.isPurgeOnNoConsumers());
        Assertions.assertFalse((boolean)queueQueryResult.isTemporary());
        Assertions.assertFalse((boolean)queueQueryResult.isExclusive());
        Assertions.assertFalse((boolean)queueQueryResult.isNonDestructive());
    }

    @Test
    public void testQueueQueryOnAutoCreatedQueueWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString fqqn = addressName.concat("::").concat(queueName);
        try (JMSContext c = new ActiveMQConnectionFactory("vm://0").createContext();){
            c.createProducer().send((Destination)c.createQueue(fqqn.toString()), c.createMessage());
            QueueQueryResult queueQueryResult = this.server.queueQuery(fqqn);
            Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
            Assertions.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
            Wait.assertEquals((long)1L, () -> this.server.queueQuery(fqqn).getMessageCount());
            queueQueryResult = this.server.queueQuery(queueName);
            Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
            Assertions.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
            Assertions.assertEquals((long)1L, (long)queueQueryResult.getMessageCount());
            c.createProducer().send((Destination)c.createQueue(addressName.toString()), c.createMessage());
            Wait.assertEquals((long)2L, () -> this.server.queueQuery(fqqn).getMessageCount());
            Wait.assertEquals((long)2L, () -> this.server.queueQuery(queueName).getMessageCount());
        }
    }

    @Test
    public void testQueueQueryNonDefaultsOnAutoCreatedQueue() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString lastValueKey = SimpleString.of((String)"myLastValueKey");
        this.server.getAddressSettingsRepository().addMatch(queueName.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true)).setDefaultMaxConsumers(Integer.valueOf(1)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)).setDefaultConsumersBeforeDispatch(Integer.valueOf(13)).setDefaultConsumerWindowSize(51).setDefaultDelayBeforeDispatch(Long.valueOf(19L)).setDefaultLastValueQueue(true).setDefaultLastValueKey(lastValueKey).setDefaultExclusiveQueue(Boolean.valueOf(true)).setDefaultNonDestructive(true));
        JMSContext c = new ActiveMQConnectionFactory("vm://0").createContext();
        c.createProducer().send((Destination)c.createQueue(queueName.toString()), c.createMessage());
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueName);
        Assertions.assertTrue((boolean)queueQueryResult.isExists());
        Assertions.assertEquals((Object)RoutingType.ANYCAST, (Object)queueQueryResult.getRoutingType());
        Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        Assertions.assertTrue((boolean)queueQueryResult.isAutoCreateQueues());
        Assertions.assertNull((Object)queueQueryResult.getFilterString());
        Assertions.assertTrue((boolean)queueQueryResult.isAutoCreated());
        Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getAddress());
        Assertions.assertEquals((long)0L, (long)queueQueryResult.getMessageCount());
        Assertions.assertEquals((int)0, (int)queueQueryResult.getConsumerCount());
        Assertions.assertEquals((int)1, (int)queueQueryResult.getMaxConsumers());
        Assertions.assertEquals((int)13, (int)queueQueryResult.getConsumersBeforeDispatch());
        Assertions.assertEquals((int)51, (int)queueQueryResult.getDefaultConsumerWindowSize());
        Assertions.assertEquals((long)19L, (long)queueQueryResult.getDelayBeforeDispatch());
        Assertions.assertTrue((boolean)queueQueryResult.isLastValue());
        Assertions.assertEquals((Object)lastValueKey, (Object)queueQueryResult.getLastValueKey());
        Assertions.assertTrue((boolean)queueQueryResult.isDurable());
        Assertions.assertTrue((boolean)queueQueryResult.isPurgeOnNoConsumers());
        Assertions.assertFalse((boolean)queueQueryResult.isTemporary());
        Assertions.assertTrue((boolean)queueQueryResult.isExclusive());
        Assertions.assertTrue((boolean)queueQueryResult.isNonDestructive());
    }

    @Test
    public void testQueueQueryNonExistentQueue() throws Exception {
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        QueueQueryResult queueQueryResult = this.server.queueQuery(queueName);
        Assertions.assertFalse((boolean)queueQueryResult.isExists());
        Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
    }

    @Test
    public void testQueueQueryNonExistentQueueWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString queueName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString fqqn = addressName.concat("::").concat(queueName);
        QueueQueryResult queueQueryResult = this.server.queueQuery(fqqn);
        Assertions.assertFalse((boolean)queueQueryResult.isExists());
        Assertions.assertEquals((Object)queueName, (Object)queueQueryResult.getName());
        Assertions.assertEquals((Object)addressName, (Object)queueQueryResult.getAddress());
    }
}

