/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow.metric;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.LongAdder;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractSinkConduit;
import org.xnio.conduits.SinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public class BytesSentStreamSinkConduit
extends AbstractSinkConduit
implements StreamSinkConduit {
    private final StreamSinkConduit next;
    private static final LongAdder bytesSent = new LongAdder();

    public BytesSentStreamSinkConduit(StreamSinkConduit next) {
        super((SinkConduit)next);
        this.next = next;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        long bytes = this.next.transferFrom(src, position, count);
        bytesSent.add(bytes);
        return bytes;
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        long bytes = this.next.transferFrom(source, count, throughBuffer);
        bytesSent.add(bytes);
        return bytes;
    }

    public int write(ByteBuffer src) throws IOException {
        int bytes = this.next.write(src);
        bytesSent.add(bytes);
        return bytes;
    }

    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long bytes = this.next.write(srcs, offs, len);
        bytesSent.add(bytes);
        return bytes;
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        int bytes = this.next.writeFinal(src);
        bytesSent.add(bytes);
        return bytes;
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long bytes = this.next.writeFinal(srcs, offset, length);
        bytesSent.add(bytes);
        return bytes;
    }

    public static long getBytesSent() {
        return bytesSent.longValue();
    }
}

