/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.lock.exception.ClusteredLockException;
import org.infinispan.lock.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String lockDeleted$str() {
        return "ISPN016001: The lock was deleted.";
    }

    @Override
    public final ClusteredLockException lockDeleted() {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.lockDeleted$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unlockFailed$str() {
        return "ISPN016003: LOCK[%s] Unlock failed from node %s";
    }

    @Override
    public final ClusteredLockException unlockFailed(String lockName, Object originator) {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.unlockFailed$str(), lockName, originator));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingName$str() {
        return "ISPN016004: Missing name for the clustered lock";
    }

    @Override
    public final ClusteredLockException missingName() {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.missingName$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNumOwners$str() {
        return "ISPN016005: Invalid number of owner. It must be higher than zero or -1 but it was %s";
    }

    @Override
    public final ClusteredLockException invalidNumOwners(Integer value) {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.invalidNumOwners$str(), value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidReliabilityMode$str() {
        return "ISPN016006: Invalid reliability mode. Modes are AVAILABLE or CONSISTENT";
    }

    @Override
    public final ClusteredLockException invalidReliabilityMode() {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.invalidReliabilityMode$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidScope$str() {
        return "ISPN016007: Invalid scope for tag <clustered-lock>. Expected CACHE_CONTAINER but was %s";
    }

    @Override
    public final ClusteredLockException invalidScope(String scope) {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.invalidScope$str(), scope));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String requireClustered$str() {
        return "ISPN016008: Cannot create clustered locks when clustering is not enabled";
    }

    @Override
    public final ClusteredLockException requireClustered() {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.requireClustered$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void configurationNotClustered() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.configurationNotClustered$str(), new Object[0]);
    }

    protected String configurationNotClustered$str() {
        return "ISPN016009: Configuration is not clustered, clustered locks are disabled";
    }

    protected String jmxRegistrationFailed$str() {
        return "ISPN016010: MBean registration failed";
    }

    @Override
    public final ClusteredLockException jmxRegistrationFailed(Throwable cause) {
        ClusteredLockException result = new ClusteredLockException(String.format(this.getLoggingLocale(), this.jmxRegistrationFailed$str(), new Object[0]));
        result.initCause(cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

