/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.io.IOException;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.protostream.MessageContext;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.jboss.logging.Logger;

public final class ProtobufMatcherEvalContext
extends MatcherEvalContext<Descriptor, FieldDescriptor, Integer>
implements TagHandler {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)ProtobufMatcherEvalContext.class.getName());
    private boolean payloadStarted = false;
    private int skipping = 0;
    private byte[] payload;
    private String entityTypeName;
    private Descriptor payloadMessageDescriptor;
    private MessageContext messageContext;
    private final SerializationContext serializationContext;

    public ProtobufMatcherEvalContext(Object userContext, Object eventType, Object key, Object instance, Object metadata, Descriptor wrappedMessageDescriptor, SerializationContext serializationContext) {
        super(userContext, eventType, key, instance, metadata);
        this.serializationContext = serializationContext;
        try {
            ProtobufParser.INSTANCE.parse((TagHandler)this, wrappedMessageDescriptor, (byte[])this.getInstance());
        }
        catch (IOException e) {
            throw log.errorParsingProtobuf(e);
        }
    }

    @Override
    public Descriptor getEntityType() {
        return this.payloadMessageDescriptor;
    }

    public void onStart(GenericDescriptor descriptor) {
    }

    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
        if (this.payloadStarted) {
            AttributeNode<FieldDescriptor, Integer> attrNode;
            if (this.skipping == 0 && (attrNode = this.currentNode.getChild(fieldNumber)) != null) {
                this.messageContext.markField(fieldNumber);
                attrNode.processValue(tagValue, this);
            }
        } else {
            switch (fieldNumber) {
                case 16: {
                    this.entityTypeName = (String)tagValue;
                    break;
                }
                case 19: {
                    this.entityTypeName = this.serializationContext.getDescriptorByTypeId((Integer)tagValue).getFullName();
                    break;
                }
                case 17: {
                    this.payload = (byte[])tagValue;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field : " + fieldNumber);
                }
            }
        }
    }

    public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        if (this.payloadStarted) {
            AttributeNode attrNode;
            if (this.skipping == 0 && (attrNode = this.currentNode.getChild(fieldNumber)) != null) {
                this.messageContext.markField(fieldNumber);
                this.pushContext(fieldDescriptor, fieldDescriptor.getMessageType());
                this.currentNode = attrNode;
                return;
            }
            ++this.skipping;
        } else {
            throw new IllegalStateException("No nested message is supported");
        }
    }

    public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        if (this.payloadStarted) {
            if (this.skipping == 0) {
                this.popContext();
                this.currentNode = this.currentNode.getParent();
            } else {
                --this.skipping;
            }
        } else {
            throw new IllegalStateException("No nested message is supported");
        }
    }

    public void onEnd() {
        if (this.payloadStarted) {
            this.processMissingFields();
        } else {
            this.payloadStarted = true;
            if (this.payload != null) {
                if (this.entityTypeName == null) {
                    throw new IllegalStateException("Descriptor name is missing");
                }
                this.payloadMessageDescriptor = this.serializationContext.getMessageDescriptor(this.entityTypeName);
                this.messageContext = new MessageContext(null, null, this.payloadMessageDescriptor);
            }
        }
    }

    @Override
    protected void processAttributes(AttributeNode<FieldDescriptor, Integer> node, Object instance) {
        try {
            ProtobufParser.INSTANCE.parse((TagHandler)this, this.payloadMessageDescriptor, this.payload);
            for (AttributeNode<FieldDescriptor, Integer> childAttribute : node.getChildren()) {
                if (childAttribute.getAttribute() < 150000) continue;
                Object attributeValue = node.cacheMetadataProjection(this.key, instance, this.metadata, childAttribute.getAttribute());
                childAttribute.processValue(attributeValue, this);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void pushContext(FieldDescriptor fieldDescriptor, Descriptor messageDescriptor) {
        this.messageContext = new MessageContext(this.messageContext, fieldDescriptor, messageDescriptor);
    }

    private void popContext() {
        this.processMissingFields();
        this.messageContext = this.messageContext.getParentContext();
    }

    private void processMissingFields() {
        for (FieldDescriptor fd : this.messageContext.getMessageDescriptor().getFields()) {
            AttributeNode<FieldDescriptor, Integer> attributeNode = this.currentNode.getChild(fd.getNumber());
            boolean fieldSeen = this.messageContext.isFieldMarked(fd.getNumber());
            if (attributeNode == null || !fd.isRepeated() && fieldSeen) continue;
            if (fd.isRepeated()) {
                if (fieldSeen) {
                    attributeNode.processValue(AttributeNode.DUMMY_VALUE, this);
                    continue;
                }
                this.processNullAttribute(attributeNode);
                continue;
            }
            if (fd.getJavaType() == JavaType.MESSAGE) {
                this.processNullAttribute(attributeNode);
                continue;
            }
            Object defaultValue = fd.hasDefaultValue() ? fd.getDefaultValue() : null;
            attributeNode.processValue(defaultValue, this);
        }
    }

    private void processNullAttribute(AttributeNode<FieldDescriptor, Integer> attributeNode) {
        attributeNode.processValue(null, this);
        for (AttributeNode<FieldDescriptor, Integer> childAttribute : attributeNode.getChildren()) {
            this.processNullAttribute(childAttribute);
        }
    }
}

