/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.persistence.xml.NamedResourceRegistrationXMLElement;
import org.jboss.as.controller.persistence.xml.ResourceRegistrationXMLElement;
import org.jboss.as.controller.persistence.xml.ResourceXMLChoice;
import org.jboss.as.controller.persistence.xml.ResourceXMLParticleFactory;
import org.jboss.as.controller.persistence.xml.SubsystemResourceRegistrationXMLElement;
import org.jboss.as.controller.persistence.xml.SubsystemResourceXMLSchema;
import org.jboss.as.controller.xml.VersionedFeature;
import org.jboss.as.controller.xml.VersionedNamespace;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLChoice;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.staxmapper.IntVersion;
import org.wildfly.extension.io.BufferPoolResourceDefinition;
import org.wildfly.extension.io.IOSubsystemResourceDefinitionRegistrar;
import org.wildfly.extension.io.OutboundBindAddressResourceDefinition;
import org.wildfly.extension.io.WorkerResourceDefinition;

public enum IOSubsystemSchema implements SubsystemResourceXMLSchema<IOSubsystemSchema>
{
    VERSION_1_1(1, 1),
    VERSION_2_0(2, 0),
    VERSION_3_0(3, 0),
    VERSION_4_0(4, 0);

    static final IOSubsystemSchema CURRENT;
    private final ResourceXMLParticleFactory factory = ResourceXMLParticleFactory.newInstance((SubsystemSchema)this);
    private final VersionedNamespace<IntVersion, IOSubsystemSchema> namespace;

    private IOSubsystemSchema(int major, int minor) {
        this.namespace = SubsystemSchema.createLegacySubsystemURN((String)IOSubsystemResourceDefinitionRegistrar.REGISTRATION.getName(), (IntVersion)new IntVersion(new int[]{major, minor}));
    }

    public VersionedNamespace<IntVersion, IOSubsystemSchema> getNamespace() {
        return this.namespace;
    }

    public SubsystemResourceRegistrationXMLElement getSubsystemXMLElement() {
        SubsystemResourceRegistrationXMLElement.Builder builder = this.factory.subsystemElement((ResourceRegistration)IOSubsystemResourceDefinitionRegistrar.REGISTRATION);
        if (this.since((VersionedFeature)VERSION_4_0)) {
            builder.addAttribute(IOSubsystemResourceDefinitionRegistrar.DEFAULT_WORKER);
        } else {
            builder.withDefaultValues(Map.of(IOSubsystemResourceDefinitionRegistrar.DEFAULT_WORKER, IOSubsystemResourceDefinitionRegistrar.LEGACY_DEFAULT_WORKER));
        }
        ResourceXMLChoice content = (ResourceXMLChoice)((ResourceXMLChoice.Builder)((ResourceXMLChoice.Builder)((ResourceXMLChoice.Builder)this.factory.choice().withCardinality((XMLCardinality)XMLCardinality.Unbounded.REQUIRED)).addElement((XMLElement)this.workerElement())).addElement((XMLElement)this.bufferPoolElement())).build();
        return (SubsystemResourceRegistrationXMLElement)((SubsystemResourceRegistrationXMLElement.Builder)builder.withContent((XMLChoice)content)).build();
    }

    private ResourceRegistrationXMLElement workerElement() {
        NamedResourceRegistrationXMLElement.Builder builder = (NamedResourceRegistrationXMLElement.Builder)this.factory.namedElement(ResourceRegistration.of((PathElement)WorkerResourceDefinition.PATH)).addAttributes(List.of(WorkerResourceDefinition.WORKER_IO_THREADS, WorkerResourceDefinition.WORKER_TASK_KEEPALIVE, WorkerResourceDefinition.WORKER_TASK_MAX_THREADS, WorkerResourceDefinition.STACK_SIZE));
        if (this.since((VersionedFeature)VERSION_3_0)) {
            builder.addAttribute((AttributeDefinition)WorkerResourceDefinition.WORKER_TASK_CORE_THREADS);
        }
        if (this.since((VersionedFeature)VERSION_2_0)) {
            builder.withContent((XMLChoice)((ResourceXMLChoice.Builder)((ResourceXMLChoice.Builder)this.factory.choice().withCardinality((XMLCardinality)XMLCardinality.Unbounded.OPTIONAL)).addElement((XMLElement)this.outboundBindAddressElement())).build());
        }
        return (ResourceRegistrationXMLElement)builder.build();
    }

    private ResourceRegistrationXMLElement outboundBindAddressElement() {
        return (ResourceRegistrationXMLElement)((NamedResourceRegistrationXMLElement.Builder)this.factory.namedElement(ResourceRegistration.of((PathElement)OutboundBindAddressResourceDefinition.PATH)).addAttributes(OutboundBindAddressResourceDefinition.ATTRIBUTES)).build();
    }

    private ResourceRegistrationXMLElement bufferPoolElement() {
        return (ResourceRegistrationXMLElement)((NamedResourceRegistrationXMLElement.Builder)this.factory.namedElement(ResourceRegistration.of((PathElement)BufferPoolResourceDefinition.PATH)).addAttributes(BufferPoolResourceDefinition.ATTRIBUTES)).build();
    }

    static {
        CURRENT = VERSION_4_0;
    }
}

