/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.runtime.impl;

import org.hibernate.search.engine.backend.types.converter.FromDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;

public final class PojoValueBridgeStringConverter<F>
implements ToDocumentValueConverter<String, F>,
FromDocumentValueConverter<F, String> {
    private final ValueBridge<?, F> bridge;

    public PojoValueBridgeStringConverter(ValueBridge<?, F> bridge) {
        this.bridge = bridge;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.bridge) + "]";
    }

    public F toDocumentValue(String value, ToDocumentValueConvertContext context) {
        return this.bridge.parse(value);
    }

    public String fromDocumentValue(F value, FromDocumentValueConvertContext context) {
        return this.bridge.format(value);
    }

    public boolean isCompatibleWith(ToDocumentValueConverter<?, ?> other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        PojoValueBridgeStringConverter castedOther = (PojoValueBridgeStringConverter)other;
        return this.bridge.isCompatibleWith(castedOther.bridge);
    }
}

