/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.config.ServerLocatorConfig;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.loadbalance.ConnectionLoadBalancingPolicy;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.AfterConnectInternalListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.cluster.DiscoveryEntry;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.core.cluster.DiscoveryListener;
import org.apache.activemq.artemis.core.protocol.core.impl.ActiveMQClientProtocolManagerFactory;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.remoting.Connector;
import org.apache.activemq.artemis.uri.ServerLocatorParser;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ActiveMQThreadPoolExecutor;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.ThreadDumpUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.actors.Actor;
import org.apache.activemq.artemis.utils.actors.OrderedExecutor;
import org.apache.activemq.artemis.utils.uri.FluentPropertyBeanIntrospectorWithIgnores;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerLocatorImpl
implements ServerLocatorInternal,
DiscoveryListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ClientProtocolManagerFactory protocolManagerFactory = new ActiveMQClientProtocolManagerFactory().setLocator(this);
    private final boolean ha;
    private boolean clusterConnection;
    private transient String identity;
    private boolean finalizeCheck;
    private final Set<ClientSessionFactoryInternal> factories = new HashSet<ClientSessionFactoryInternal>();
    private final Set<ClientSessionFactoryInternal> connectingFactories = new HashSet<ClientSessionFactoryInternal>();
    private volatile TransportConfiguration[] initialConnectors;
    private final DiscoveryGroupConfiguration discoveryGroupConfiguration;
    private final StaticConnector staticConnector = new StaticConnector();
    private Topology topology;
    private final Object topologyArrayGuard = new Object();
    private volatile Pair<TransportConfiguration, TransportConfiguration>[] topologyArray;
    private volatile boolean receivedTopology;
    private volatile boolean disableDiscoveryRetries = false;
    private transient boolean shutdownPool;
    private transient Executor threadPool;
    private transient Executor flowControlThreadPool;
    private transient ScheduledExecutorService scheduledThreadPool;
    private transient DiscoveryGroup discoveryGroup;
    private transient ConnectionLoadBalancingPolicy loadBalancingPolicy;
    private final Object discoveryGroupGuardian = new Object();
    private final Object stateGuard = new Object();
    private transient STATE state;
    private transient CountDownLatch latch;
    private final List<Interceptor> incomingInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private final List<Interceptor> outgoingInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private Executor startExecutor;
    private Actor<Long> updateArrayActor;
    private AfterConnectInternalListener afterConnectListener;
    private String groupID;
    private String nodeID;
    private TransportConfiguration clusterTransportConfiguration;
    private final Exception traceException = new Exception();
    private ServerLocatorConfig config = new ServerLocatorConfig();
    private String passwordCodec;

    public DiscoveryGroup getDiscoveryGroup() {
        return this.discoveryGroup;
    }

    public Set<ClientSessionFactoryInternal> getFactories() {
        return this.factories;
    }

    public static synchronized void clearThreadPools() {
        ActiveMQClient.clearThreadPools();
    }

    private synchronized void setThreadPools() {
        if (this.threadPool != null) {
            return;
        }
        if (this.config.useGlobalPools) {
            this.threadPool = ActiveMQClient.getGlobalThreadPool();
            this.flowControlThreadPool = ActiveMQClient.getGlobalFlowControlThreadPool();
            this.scheduledThreadPool = ActiveMQClient.getGlobalScheduledThreadPool();
        } else {
            this.shutdownPool = true;
            ThreadFactory factory = this.getThreadFactory("ActiveMQ-client-factory-threads-");
            this.threadPool = this.config.threadPoolMaxSize == -1 ? Executors.newCachedThreadPool(factory) : new ActiveMQThreadPoolExecutor(0, this.config.threadPoolMaxSize, 60L, TimeUnit.SECONDS, factory);
            factory = this.getThreadFactory("ActiveMQ-client-factory-flow-control-threads-");
            this.flowControlThreadPool = this.config.flowControlThreadPoolMaxSize == -1 ? Executors.newCachedThreadPool(factory) : new ActiveMQThreadPoolExecutor(0, this.config.flowControlThreadPoolMaxSize, 60L, TimeUnit.SECONDS, factory);
            factory = this.getThreadFactory("ActiveMQ-client-factory-pinger-threads-");
            this.scheduledThreadPool = Executors.newScheduledThreadPool(this.config.scheduledThreadPoolMaxSize, factory);
        }
        this.updateArrayActor = new Actor(this.threadPool, this::internalUpdateArray);
    }

    private ThreadFactory getThreadFactory(final String groupName) {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new ActiveMQThreadFactory(groupName + System.identityHashCode(this), true, ClientSessionFactoryImpl.class.getClassLoader());
            }
        });
    }

    @Override
    public synchronized boolean setThreadPools(Executor threadPool, ScheduledExecutorService scheduledThreadPool, Executor flowControlThreadPool) {
        if (threadPool == null || scheduledThreadPool == null) {
            return false;
        }
        if (this.threadPool == null && this.scheduledThreadPool == null && this.flowControlThreadPool == null) {
            this.config.useGlobalPools = false;
            this.shutdownPool = false;
            this.threadPool = threadPool;
            this.scheduledThreadPool = scheduledThreadPool;
            this.flowControlThreadPool = flowControlThreadPool;
            return true;
        }
        return false;
    }

    private void instantiateLoadBalancingPolicy() {
        if (this.config.connectionLoadBalancingPolicyClassName == null) {
            throw new IllegalStateException("Please specify a load balancing policy class name on the session factory");
        }
        AccessController.doPrivileged(() -> {
            this.loadBalancingPolicy = (ConnectionLoadBalancingPolicy)ClassloadingUtil.newInstanceFromClassLoader(ServerLocatorImpl.class, (String)this.config.connectionLoadBalancingPolicyClassName, ConnectionLoadBalancingPolicy.class);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initialize() throws ActiveMQException {
        if (this.state == STATE.INITIALIZED) {
            return;
        }
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state == STATE.CLOSING) {
                throw new ActiveMQIllegalStateException();
            }
            try {
                this.state = STATE.INITIALIZED;
                this.latch = new CountDownLatch(1);
                this.setThreadPools();
                this.topology.setExecutor((Executor)new OrderedExecutor(this.threadPool));
                this.instantiateLoadBalancingPolicy();
                this.startDiscovery();
            }
            catch (Exception e) {
                this.state = null;
                throw ActiveMQClientMessageBundle.BUNDLE.failedToInitialiseSessionFactory(e);
            }
        }
    }

    private void startDiscovery() throws ActiveMQException {
        if (this.discoveryGroupConfiguration != null) {
            try {
                this.discoveryGroup = ServerLocatorImpl.createDiscoveryGroup(this.nodeID, this.discoveryGroupConfiguration);
                this.discoveryGroup.registerListener(this);
                this.discoveryGroup.start();
            }
            catch (Exception e) {
                throw new ActiveMQInternalErrorException(e.getMessage(), e);
            }
        }
    }

    @Override
    public ServerLocatorConfig getLocatorConfig() {
        return this.config;
    }

    @Override
    public void setLocatorConfig(ServerLocatorConfig config) {
        this.config = config;
    }

    @Override
    public ServerLocator setPasswordCodec(String passwordCodec) {
        this.passwordCodec = passwordCodec;
        return this;
    }

    @Override
    public String getPasswordCodec() {
        return this.passwordCodec;
    }

    private static DiscoveryGroup createDiscoveryGroup(String nodeID, DiscoveryGroupConfiguration config) throws Exception {
        return new DiscoveryGroup(nodeID, config.getName(), config.getRefreshTimeout(), config.getBroadcastEndpointFactory(), null);
    }

    private ServerLocatorImpl(Topology topology, boolean useHA, DiscoveryGroupConfiguration discoveryGroupConfiguration, TransportConfiguration[] transportConfigs) {
        this.traceException.fillInStackTrace();
        this.topology = topology == null ? new Topology(this) : topology;
        this.ha = useHA;
        this.discoveryGroupConfiguration = discoveryGroupConfiguration;
        this.initialConnectors = transportConfigs;
        this.nodeID = UUIDGenerator.getInstance().generateStringUUID();
        this.clusterConnection = false;
    }

    public static ServerLocator newLocator(String uri) {
        try {
            ServerLocatorParser parser = new ServerLocatorParser();
            URI newURI = parser.expandURI(uri);
            return (ServerLocator)parser.newObject(newURI, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ServerLocator newLocator(URI uri) {
        try {
            ServerLocatorParser parser = new ServerLocatorParser();
            return (ServerLocator)parser.newObject(uri, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ServerLocatorImpl(boolean useHA, DiscoveryGroupConfiguration groupConfiguration) {
        this(new Topology(null), useHA, groupConfiguration, null);
        if (useHA) {
            this.topology.setOwner(this);
        }
    }

    public ServerLocatorImpl(boolean useHA, TransportConfiguration ... transportConfigs) {
        this(new Topology(null), useHA, (DiscoveryGroupConfiguration)null, transportConfigs);
        if (useHA) {
            this.topology.setOwner(this);
        }
    }

    public ServerLocatorImpl(Topology topology, boolean useHA, DiscoveryGroupConfiguration groupConfiguration) {
        this(topology, useHA, groupConfiguration, null);
    }

    public ServerLocatorImpl(Topology topology, boolean useHA, TransportConfiguration ... transportConfigs) {
        this(topology, useHA, (DiscoveryGroupConfiguration)null, transportConfigs);
    }

    @Override
    public void resetToInitialConnectors() {
        this.receivedTopology = false;
        this.topologyArray = null;
        this.topology.clear();
    }

    @Override
    public boolean allInVM() {
        for (TransportConfiguration config : this.getStaticTransportConfigurations()) {
            if (config.getFactoryClassName().contains("InVMConnectorFactory")) continue;
            return false;
        }
        return true;
    }

    private ServerLocatorImpl(ServerLocatorImpl locator) {
        this.ha = locator.ha;
        this.clusterConnection = locator.clusterConnection;
        this.initialConnectors = locator.initialConnectors;
        this.discoveryGroupConfiguration = locator.discoveryGroupConfiguration;
        this.topology = locator.topology;
        this.topologyArray = locator.topologyArray;
        this.receivedTopology = locator.receivedTopology;
        this.config = new ServerLocatorConfig(locator.config);
        this.startExecutor = locator.startExecutor;
        this.afterConnectListener = locator.afterConnectListener;
        this.groupID = locator.groupID;
        this.nodeID = locator.nodeID;
        this.clusterTransportConfiguration = locator.clusterTransportConfiguration;
    }

    private boolean useInitConnector() {
        return !this.config.useTopologyForLoadBalancing || !this.receivedTopology || this.topologyArray == null || this.topologyArray.length == 0;
    }

    @Override
    public Pair<TransportConfiguration, TransportConfiguration> selectNextConnectorPair() {
        return this.selectConnector(this.useInitConnector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Pair<TransportConfiguration, TransportConfiguration> selectConnector(boolean useInitConnector) {
        Pair<TransportConfiguration, TransportConfiguration>[] usedTopology;
        this.flushTopology();
        Object object = this.topologyArrayGuard;
        synchronized (object) {
            usedTopology = this.topologyArray;
        }
        object = this;
        synchronized (object) {
            if (usedTopology != null && this.config.useTopologyForLoadBalancing && !useInitConnector) {
                logger.trace("Selecting connector from topology.");
                int pos = this.loadBalancingPolicy.select(usedTopology.length);
                Pair<TransportConfiguration, TransportConfiguration> pair = usedTopology[pos];
                return pair;
            }
            logger.trace("Selecting connector from initial connectors.");
            int pos = this.loadBalancingPolicy.select(this.initialConnectors.length);
            if (this.initialConnectors.length == 0) {
                return null;
            }
            return new Pair((Object)this.initialConnectors[pos], null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectorsSize() {
        Pair<TransportConfiguration, TransportConfiguration>[] usedTopology;
        this.flushTopology();
        Object object = this.topologyArrayGuard;
        synchronized (object) {
            usedTopology = this.topologyArray;
        }
        object = this;
        synchronized (object) {
            if (usedTopology != null && this.config.useTopologyForLoadBalancing) {
                return usedTopology.length;
            }
            return this.initialConnectors.length;
        }
    }

    @Override
    public void start(Executor executor) throws Exception {
        this.initialize();
        this.startExecutor = executor;
        if (executor != null) {
            executor.execute(() -> {
                block2: {
                    try {
                        this.connect();
                    }
                    catch (Exception e) {
                        if (this.isClosed()) break block2;
                        ActiveMQClientLogger.LOGGER.errorConnectingToNodes(e);
                    }
                }
            });
        }
    }

    @Override
    public ClientProtocolManager newProtocolManager() {
        if (this.threadPool == null) {
            throw new NullPointerException("No Thread Pool");
        }
        return this.getProtocolManagerFactory().newProtocolManager().setExecutor((Executor)new OrderedExecutor(this.threadPool));
    }

    @Override
    public ClientProtocolManagerFactory getProtocolManagerFactory() {
        if (this.protocolManagerFactory == null) {
            this.protocolManagerFactory = new ActiveMQClientProtocolManagerFactory().setLocator(this);
        }
        return this.protocolManagerFactory;
    }

    @Override
    public ServerLocator setProtocolManagerFactory(ClientProtocolManagerFactory protocolManagerFactory) {
        this.protocolManagerFactory = protocolManagerFactory;
        protocolManagerFactory.setLocator(this);
        return this;
    }

    @Override
    public ClientSessionFactoryInternal connect() throws ActiveMQException {
        return this.connect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSessionFactoryInternal connect(boolean skipWarnings) throws ActiveMQException {
        this.disableDiscoveryRetries = true;
        ClientSessionFactoryInternal returnFactory = null;
        ServerLocatorImpl serverLocatorImpl = this;
        synchronized (serverLocatorImpl) {
            if (this.getNumInitialConnectors() > 0 && this.discoveryGroup == null) {
                returnFactory = (ClientSessionFactoryInternal)this.staticConnector.connect(skipWarnings);
            }
        }
        if (returnFactory != null) {
            this.addFactory(returnFactory);
            return returnFactory;
        }
        return (ClientSessionFactoryInternal)this.createSessionFactory();
    }

    @Override
    public ClientSessionFactoryInternal connectNoWarnings() throws ActiveMQException {
        return this.connect(true);
    }

    @Override
    public ServerLocatorImpl setAfterConnectionInternalListener(AfterConnectInternalListener listener) {
        this.afterConnectListener = listener;
        return this;
    }

    @Override
    public AfterConnectInternalListener getAfterConnectInternalListener() {
        return this.afterConnectListener;
    }

    @Override
    public ClientSessionFactory createSessionFactory(String nodeID) throws Exception {
        TopologyMemberImpl topologyMember = this.topology.getMember(nodeID);
        if (logger.isTraceEnabled()) {
            logger.trace("Creating connection factory towards {} = {}, topology={}", new Object[]{nodeID, topologyMember, this.topology.describe()});
        }
        if (topologyMember == null) {
            return null;
        }
        if (topologyMember.getPrimary() != null) {
            ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)this.createSessionFactory(topologyMember.getPrimary());
            if (topologyMember.getBackup() != null) {
                factory.setBackupConnector(topologyMember.getPrimary(), topologyMember.getBackup());
            }
            return factory;
        }
        if (topologyMember.getPrimary() == null && topologyMember.getBackup() != null) {
            return this.createSessionFactory(topologyMember.getBackup());
        }
        return null;
    }

    @Override
    public ClientSessionFactory createSessionFactory(TransportConfiguration transportConfiguration) throws Exception {
        return this.createSessionFactory(transportConfiguration, this.config.reconnectAttempts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory(TransportConfiguration transportConfiguration, int reconnectAttempts) throws Exception {
        this.assertOpen();
        this.initialize();
        ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl((ServerLocatorInternal)this, transportConfiguration, this.config, reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.flowControlThreadPool, this.incomingInterceptors, this.outgoingInterceptors);
        this.addToConnecting(factory);
        try {
            try {
                factory.connect(reconnectAttempts);
            }
            catch (ActiveMQException e1) {
                factory.close();
                throw e1;
            }
            this.addFactory(factory);
            ClientSessionFactoryImpl clientSessionFactoryImpl = factory;
            return clientSessionFactoryImpl;
        }
        finally {
            this.removeFromConnecting(factory);
        }
    }

    @Override
    @Deprecated
    public ClientSessionFactory createSessionFactory(TransportConfiguration transportConfiguration, int reconnectAttempts, boolean failoverOnInitialConnection) throws Exception {
        return this.createSessionFactory(transportConfiguration, reconnectAttempts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromConnecting(ClientSessionFactoryInternal factory) {
        Set<ClientSessionFactoryInternal> set = this.connectingFactories;
        synchronized (set) {
            this.connectingFactories.remove(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToConnecting(ClientSessionFactoryInternal factory) {
        Set<ClientSessionFactoryInternal> set = this.connectingFactories;
        synchronized (set) {
            this.assertOpen();
            this.connectingFactories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory() throws ActiveMQException {
        this.assertOpen();
        this.initialize();
        this.flushTopology();
        if (this.discoveryGroupConfiguration != null) {
            this.executeDiscovery();
        }
        ClientSessionFactoryInternal factory = null;
        ServerLocatorImpl serverLocatorImpl = this;
        synchronized (serverLocatorImpl) {
            boolean retry = true;
            int attempts = 0;
            boolean topologyArrayTried = !this.config.useTopologyForLoadBalancing || this.topologyArray == null || this.topologyArray.length == 0;
            boolean staticTried = false;
            boolean shouldTryStatic = this.useInitConnector();
            long interval = this.config.retryInterval;
            while (retry && !this.isClosed()) {
                retry = false;
                Pair<TransportConfiguration, TransportConfiguration> tc = this.selectConnector(shouldTryStatic);
                if (tc == null) {
                    throw ActiveMQClientMessageBundle.BUNDLE.noTCForSessionFactory();
                }
                try {
                    factory = new ClientSessionFactoryImpl(this, tc, this.config, this.config.reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.flowControlThreadPool, this.incomingInterceptors, this.outgoingInterceptors, this.initialConnectors);
                    try {
                        this.addToConnecting(factory);
                        factory.connect(1, false);
                        this.addFactory(factory);
                    }
                    finally {
                        this.removeFromConnecting(factory);
                    }
                }
                catch (ActiveMQException e) {
                    try {
                        if (e.getType() == ActiveMQExceptionType.NOT_CONNECTED) {
                            int maxAttempts;
                            ++attempts;
                            int n = maxAttempts = this.config.initialConnectAttempts == 0 ? 1 : this.config.initialConnectAttempts;
                            if (shouldTryStatic) {
                                if (this.config.initialConnectAttempts >= 0 && attempts >= maxAttempts * this.getNumInitialConnectors()) {
                                    if (topologyArrayTried) {
                                        throw ActiveMQClientMessageBundle.BUNDLE.cannotConnectToServers();
                                    }
                                    staticTried = true;
                                    shouldTryStatic = false;
                                    attempts = 0;
                                }
                            } else if (this.config.initialConnectAttempts >= 0 && attempts >= maxAttempts * this.getConnectorsSize()) {
                                if (staticTried) {
                                    throw ActiveMQClientMessageBundle.BUNDLE.cannotConnectToServers();
                                }
                                topologyArrayTried = true;
                                shouldTryStatic = true;
                                attempts = 0;
                            }
                            if (factory.waitForRetry(interval)) {
                                throw ActiveMQClientMessageBundle.BUNDLE.cannotConnectToServers();
                            }
                            interval = this.getNextRetryInterval(interval, this.config.retryIntervalMultiplier, this.config.maxRetryInterval);
                            retry = true;
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        factory.close();
                    }
                }
            }
        }
        if (this.topology != null && !factory.waitForTopology(this.config.callTimeout, TimeUnit.MILLISECONDS)) {
            this.factoryClosed(factory);
            factory.cleanup();
            if (this.isClosed()) {
                throw ActiveMQClientMessageBundle.BUNDLE.connectionClosedOnReceiveTopology(this.discoveryGroup);
            }
            throw ActiveMQClientMessageBundle.BUNDLE.connectionTimedOutOnReceiveTopology(this.discoveryGroup);
        }
        return factory;
    }

    @Override
    public long getNextRetryInterval(long retryInterval, double retryIntervalMultiplier, long maxRetryInterval) {
        long nextRetryInterval = (long)((double)retryInterval * retryIntervalMultiplier);
        if (nextRetryInterval > maxRetryInterval) {
            nextRetryInterval = maxRetryInterval;
        }
        return nextRetryInterval;
    }

    private void executeDiscovery() throws ActiveMQException {
        boolean discoveryOK = false;
        boolean retryDiscovery = false;
        int tryNumber = 0;
        do {
            discoveryOK = this.checkOnDiscovery();
            boolean bl = retryDiscovery = this.config.initialConnectAttempts > 0 && tryNumber++ < this.config.initialConnectAttempts && !this.disableDiscoveryRetries;
            if (discoveryOK) continue;
            if (retryDiscovery) {
                ActiveMQClientLogger.LOGGER.broadcastTimeout(tryNumber, this.config.initialConnectAttempts);
                continue;
            }
            throw ActiveMQClientMessageBundle.BUNDLE.connectionTimedOutInInitialBroadcast();
        } while (!discoveryOK && retryDiscovery);
        if (!discoveryOK) {
            throw ActiveMQClientMessageBundle.BUNDLE.connectionTimedOutInInitialBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOnDiscovery() throws ActiveMQException {
        Object object = this.discoveryGroupGuardian;
        synchronized (object) {
            if (this.getNumInitialConnectors() == 0 && this.discoveryGroupConfiguration != null) {
                try {
                    long timeout;
                    long l = timeout = this.clusterConnection ? 0L : this.discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout();
                    if (!this.discoveryGroup.waitForBroadcast(timeout)) {
                        if (logger.isDebugEnabled()) {
                            String threadDump = ThreadDumpUtil.threadDump((String)"Discovery timeout, printing thread dump");
                            logger.debug(threadDump);
                        }
                        if (!this.disableDiscoveryRetries) {
                            if (this.discoveryGroup != null) {
                                this.discoveryGroup.stop();
                            }
                            logger.debug("Restarting discovery");
                            this.startDiscovery();
                        }
                        return false;
                    }
                }
                catch (Exception e) {
                    throw new ActiveMQInternalErrorException(e.getMessage(), e);
                }
            }
        }
        return true;
    }

    public void flushTopology() {
        if (this.updateArrayActor != null) {
            this.updateArrayActor.flush(10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public boolean isHA() {
        return this.ha;
    }

    @Override
    public ServerLocator setIncomingInterceptorList(String interceptorList) {
        this.feedInterceptors(this.incomingInterceptors, interceptorList);
        return this;
    }

    @Override
    public String getIncomingInterceptorList() {
        return this.fromInterceptors(this.incomingInterceptors);
    }

    @Override
    public ServerLocator setOutgoingInterceptorList(String interceptorList) {
        this.feedInterceptors(this.outgoingInterceptors, interceptorList);
        return this;
    }

    @Override
    public String getOutgoingInterceptorList() {
        return this.fromInterceptors(this.outgoingInterceptors);
    }

    @Override
    public boolean isCacheLargeMessagesClient() {
        return this.config.cacheLargeMessagesClient;
    }

    @Override
    public ServerLocatorImpl setCacheLargeMessagesClient(boolean cached) {
        this.config.cacheLargeMessagesClient = cached;
        return this;
    }

    @Override
    public long getClientFailureCheckPeriod() {
        return this.config.clientFailureCheckPeriod;
    }

    @Override
    public ServerLocatorImpl setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.checkWrite();
        this.config.clientFailureCheckPeriod = clientFailureCheckPeriod;
        return this;
    }

    @Override
    public long getConnectionTTL() {
        return this.config.connectionTTL;
    }

    @Override
    public ServerLocatorImpl setConnectionTTL(long connectionTTL) {
        this.checkWrite();
        this.config.connectionTTL = connectionTTL;
        return this;
    }

    @Override
    public long getCallTimeout() {
        return this.config.callTimeout;
    }

    @Override
    public ServerLocatorImpl setCallTimeout(long callTimeout) {
        this.checkWrite();
        this.config.callTimeout = callTimeout;
        return this;
    }

    @Override
    public long getCallFailoverTimeout() {
        return this.config.callFailoverTimeout;
    }

    @Override
    public ServerLocatorImpl setCallFailoverTimeout(long callFailoverTimeout) {
        this.checkWrite();
        this.config.callFailoverTimeout = callFailoverTimeout;
        return this;
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.config.minLargeMessageSize;
    }

    @Override
    public ServerLocatorImpl setMinLargeMessageSize(int minLargeMessageSize) {
        this.checkWrite();
        this.config.minLargeMessageSize = minLargeMessageSize;
        return this;
    }

    @Override
    public int getConsumerWindowSize() {
        return this.config.consumerWindowSize;
    }

    @Override
    public ServerLocatorImpl setConsumerWindowSize(int consumerWindowSize) {
        this.checkWrite();
        this.config.consumerWindowSize = consumerWindowSize;
        return this;
    }

    @Override
    public int getConsumerMaxRate() {
        return this.config.consumerMaxRate;
    }

    @Override
    public ServerLocatorImpl setConsumerMaxRate(int consumerMaxRate) {
        this.checkWrite();
        this.config.consumerMaxRate = consumerMaxRate;
        return this;
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.config.confirmationWindowSize;
    }

    @Override
    public ServerLocatorImpl setConfirmationWindowSize(int confirmationWindowSize) {
        this.checkWrite();
        this.config.confirmationWindowSize = confirmationWindowSize;
        return this;
    }

    @Override
    public int getProducerWindowSize() {
        return this.config.producerWindowSize;
    }

    @Override
    public ServerLocatorImpl setProducerWindowSize(int producerWindowSize) {
        this.checkWrite();
        this.config.producerWindowSize = producerWindowSize;
        return this;
    }

    @Override
    public int getProducerMaxRate() {
        return this.config.producerMaxRate;
    }

    @Override
    public ServerLocatorImpl setProducerMaxRate(int producerMaxRate) {
        this.checkWrite();
        this.config.producerMaxRate = producerMaxRate;
        return this;
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.config.blockOnAcknowledge;
    }

    @Override
    public ServerLocatorImpl setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.checkWrite();
        this.config.blockOnAcknowledge = blockOnAcknowledge;
        return this;
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.config.blockOnDurableSend;
    }

    @Override
    public ServerLocatorImpl setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.checkWrite();
        this.config.blockOnDurableSend = blockOnDurableSend;
        return this;
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.config.blockOnNonDurableSend;
    }

    @Override
    public ServerLocatorImpl setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.checkWrite();
        this.config.blockOnNonDurableSend = blockOnNonDurableSend;
        return this;
    }

    @Override
    public boolean isAutoGroup() {
        return this.config.autoGroup;
    }

    @Override
    public ServerLocatorImpl setAutoGroup(boolean autoGroup) {
        this.checkWrite();
        this.config.autoGroup = autoGroup;
        return this;
    }

    @Override
    public boolean isPreAcknowledge() {
        return this.config.preAcknowledge;
    }

    @Override
    public ServerLocatorImpl setPreAcknowledge(boolean preAcknowledge) {
        this.checkWrite();
        this.config.preAcknowledge = preAcknowledge;
        return this;
    }

    @Override
    public int getAckBatchSize() {
        return this.config.ackBatchSize;
    }

    @Override
    public ServerLocatorImpl setAckBatchSize(int ackBatchSize) {
        this.checkWrite();
        this.config.ackBatchSize = ackBatchSize;
        return this;
    }

    @Override
    public boolean isUseGlobalPools() {
        return this.config.useGlobalPools;
    }

    @Override
    public ServerLocatorImpl setUseGlobalPools(boolean useGlobalPools) {
        this.checkWrite();
        this.config.useGlobalPools = useGlobalPools;
        return this;
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.config.scheduledThreadPoolMaxSize;
    }

    @Override
    public ServerLocatorImpl setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.checkWrite();
        this.config.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
        return this;
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.config.threadPoolMaxSize;
    }

    @Override
    public ServerLocatorImpl setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.checkWrite();
        this.config.threadPoolMaxSize = threadPoolMaxSize;
        return this;
    }

    @Override
    public int getFlowControlThreadPoolMaxSize() {
        return this.config.flowControlThreadPoolMaxSize;
    }

    @Override
    public ServerLocatorImpl setFlowControlThreadPoolMaxSize(int flowControlThreadPoolMaxSize) {
        this.checkWrite();
        this.config.flowControlThreadPoolMaxSize = flowControlThreadPoolMaxSize;
        return this;
    }

    @Override
    public long getRetryInterval() {
        return this.config.retryInterval;
    }

    @Override
    public ServerLocatorImpl setRetryInterval(long retryInterval) {
        this.checkWrite();
        this.config.retryInterval = retryInterval;
        return this;
    }

    @Override
    public long getMaxRetryInterval() {
        return this.config.maxRetryInterval;
    }

    @Override
    public ServerLocatorImpl setMaxRetryInterval(long retryInterval) {
        this.checkWrite();
        this.config.maxRetryInterval = retryInterval;
        return this;
    }

    @Override
    public double getRetryIntervalMultiplier() {
        return this.config.retryIntervalMultiplier;
    }

    @Override
    public ServerLocatorImpl setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.checkWrite();
        this.config.retryIntervalMultiplier = retryIntervalMultiplier;
        return this;
    }

    @Override
    public int getReconnectAttempts() {
        return this.config.reconnectAttempts;
    }

    @Override
    public ServerLocatorImpl setReconnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.config.reconnectAttempts = reconnectAttempts;
        return this;
    }

    @Override
    public ServerLocatorImpl setInitialConnectAttempts(int initialConnectAttempts) {
        this.checkWrite();
        this.config.initialConnectAttempts = initialConnectAttempts;
        return this;
    }

    @Override
    public int getInitialConnectAttempts() {
        return this.config.initialConnectAttempts;
    }

    @Override
    public ServerLocatorImpl setFailoverAttempts(int attempts) {
        this.checkWrite();
        this.config.failoverAttempts = attempts;
        return this;
    }

    @Override
    public int getFailoverAttempts() {
        return this.config.failoverAttempts;
    }

    @Override
    @Deprecated
    public boolean isFailoverOnInitialConnection() {
        return false;
    }

    @Override
    @Deprecated
    public ServerLocatorImpl setFailoverOnInitialConnection(boolean failover) {
        return this;
    }

    @Override
    public String getConnectionLoadBalancingPolicyClassName() {
        return this.config.connectionLoadBalancingPolicyClassName;
    }

    @Override
    public ServerLocatorImpl setConnectionLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.checkWrite();
        this.config.connectionLoadBalancingPolicyClassName = loadBalancingPolicyClassName;
        return this;
    }

    @Override
    public TransportConfiguration[] getStaticTransportConfigurations() {
        if (this.initialConnectors == null) {
            return new TransportConfiguration[0];
        }
        return Arrays.copyOf(this.initialConnectors, this.initialConnectors.length);
    }

    @Override
    public DiscoveryGroupConfiguration getDiscoveryGroupConfiguration() {
        return this.discoveryGroupConfiguration;
    }

    @Override
    public ServerLocatorImpl addIncomingInterceptor(Interceptor interceptor) {
        this.incomingInterceptors.add(interceptor);
        return this;
    }

    @Override
    public ServerLocatorImpl addOutgoingInterceptor(Interceptor interceptor) {
        this.outgoingInterceptors.add(interceptor);
        return this;
    }

    @Override
    public boolean removeIncomingInterceptor(Interceptor interceptor) {
        return this.incomingInterceptors.remove(interceptor);
    }

    @Override
    public boolean removeOutgoingInterceptor(Interceptor interceptor) {
        return this.outgoingInterceptors.remove(interceptor);
    }

    @Override
    public int getInitialMessagePacketSize() {
        return this.config.initialMessagePacketSize;
    }

    @Override
    public ServerLocatorImpl setInitialMessagePacketSize(int size) {
        this.checkWrite();
        this.config.initialMessagePacketSize = size;
        return this;
    }

    @Override
    public int getOnMessageCloseTimeout() {
        return this.config.onMessageCloseTimeout;
    }

    @Override
    public ServerLocator setOnMessageCloseTimeout(int onMessageCloseTimeout) {
        this.checkWrite();
        this.config.onMessageCloseTimeout = onMessageCloseTimeout;
        return this;
    }

    @Override
    public ServerLocatorImpl setGroupID(String groupID) {
        this.checkWrite();
        this.groupID = groupID;
        return this;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public boolean isCompressLargeMessage() {
        return this.config.compressLargeMessage;
    }

    @Override
    public ServerLocatorImpl setCompressLargeMessage(boolean avoid) {
        this.config.compressLargeMessage = avoid;
        return this;
    }

    @Override
    public int getCompressionLevel() {
        return this.config.compressionLevel;
    }

    @Override
    public ServerLocatorImpl setCompressionLevel(int compressionLevel) {
        this.config.compressionLevel = compressionLevel;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWrite() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state != null && this.state != STATE.CLOSED) {
                throw new IllegalStateException("Cannot set attribute on SessionFactory after it has been used");
            }
        }
    }

    private int getNumInitialConnectors() {
        if (this.initialConnectors == null) {
            return 0;
        }
        return this.initialConnectors.length;
    }

    @Override
    public ServerLocatorImpl setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public ServerLocatorImpl setNodeID(String nodeID) {
        this.nodeID = nodeID;
        return this;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public ServerLocatorImpl setClusterConnection(boolean clusterConnection) {
        this.clusterConnection = clusterConnection;
        return this;
    }

    @Override
    public boolean isClusterConnection() {
        return this.clusterConnection;
    }

    @Override
    public TransportConfiguration getClusterTransportConfiguration() {
        return this.clusterTransportConfiguration;
    }

    @Override
    public ServerLocatorImpl setClusterTransportConfiguration(TransportConfiguration tc) {
        this.clusterTransportConfiguration = tc;
        return this;
    }

    @Override
    public void cleanup() {
        this.doClose(false);
    }

    @Override
    public void close() {
        this.doClose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(boolean sendClose) {
        HashSet<ClientSessionFactoryInternal> clonedFactory;
        Set<ClientSessionFactoryInternal> set = this.stateGuard;
        synchronized (set) {
            if (this.state == STATE.CLOSED) {
                logger.debug("{} is already closed when calling closed", (Object)this);
                return;
            }
            this.state = STATE.CLOSING;
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
        set = this.connectingFactories;
        synchronized (set) {
            for (ClientSessionFactoryInternal clientSessionFactoryInternal : this.connectingFactories) {
                clientSessionFactoryInternal.causeExit();
            }
        }
        if (this.discoveryGroup != null) {
            set = this;
            synchronized (set) {
                try {
                    this.discoveryGroup.stop();
                }
                catch (Exception e) {
                    ActiveMQClientLogger.LOGGER.failedToStopDiscovery(e);
                }
            }
        }
        this.staticConnector.disconnect();
        set = this.connectingFactories;
        synchronized (set) {
            for (ClientSessionFactoryInternal clientSessionFactoryInternal : this.connectingFactories) {
                clientSessionFactoryInternal.causeExit();
            }
            for (ClientSessionFactoryInternal clientSessionFactoryInternal : this.connectingFactories) {
                clientSessionFactoryInternal.close();
            }
            this.connectingFactories.clear();
        }
        Iterator e = this.factories;
        synchronized (e) {
            clonedFactory = new HashSet<ClientSessionFactoryInternal>(this.factories);
            this.factories.clear();
        }
        for (ClientSessionFactoryInternal clientSessionFactoryInternal : clonedFactory) {
            clientSessionFactoryInternal.causeExit();
        }
        for (ClientSessionFactory clientSessionFactory : clonedFactory) {
            if (sendClose) {
                try {
                    clientSessionFactory.close();
                }
                catch (Throwable e2) {
                    logger.debug(e2.getMessage(), e2);
                    clientSessionFactory.cleanup();
                }
                continue;
            }
            clientSessionFactory.cleanup();
        }
        if (this.shutdownPool) {
            ExecutorService executorService;
            if (this.threadPool != null) {
                executorService = (ExecutorService)this.threadPool;
                executorService.shutdown();
                try {
                    if (!executorService.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        ActiveMQClientLogger.LOGGER.timedOutWaitingForTermination();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ActiveMQInterruptedException((Throwable)interruptedException);
                }
            }
            if (this.scheduledThreadPool != null) {
                this.scheduledThreadPool.shutdown();
                try {
                    if (!this.scheduledThreadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        ActiveMQClientLogger.LOGGER.timedOutWaitingForScheduledPoolTermination();
                    }
                }
                catch (InterruptedException e4) {
                    throw new ActiveMQInterruptedException((Throwable)e4);
                }
            }
            if (this.flowControlThreadPool != null) {
                executorService = (ExecutorService)this.flowControlThreadPool;
                executorService.shutdown();
                try {
                    if (!executorService.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        ActiveMQClientLogger.LOGGER.timedOutWaitingForTermination();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new ActiveMQInterruptedException((Throwable)interruptedException);
                }
            }
        }
        Object object = this.stateGuard;
        synchronized (object) {
            this.state = STATE.CLOSED;
        }
    }

    @Override
    public void notifyNodeDown(long eventTime, String nodeID, boolean disconnect) {
        if (!this.ha) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("nodeDown {} nodeID={} as being down", new Object[]{this, nodeID, new Exception("trace")});
        }
        this.topology.removeMember(eventTime, nodeID, disconnect);
        if (this.clusterConnection) {
            this.updateArraysAndPairs(eventTime);
        } else if (this.topology.isEmpty()) {
            this.receivedTopology = false;
        } else {
            this.updateArraysAndPairs(eventTime);
            if (this.topology.nodes() == 1 && this.topology.getMember(this.nodeID) != null) {
                this.receivedTopology = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNodeUp(long uniqueEventID, String nodeID, String backupGroupName, String scaleDownGroupName, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean last) {
        if (logger.isTraceEnabled()) {
            logger.trace("NodeUp {}::nodeID={}, connectorPair={}", new Object[]{this, nodeID, connectorPair, new Exception("trace")});
        }
        TopologyMemberImpl member = new TopologyMemberImpl(nodeID, backupGroupName, scaleDownGroupName, (TransportConfiguration)connectorPair.getA(), (TransportConfiguration)connectorPair.getB());
        this.topology.updateMember(uniqueEventID, nodeID, member);
        TopologyMemberImpl actMember = this.topology.getMember(nodeID);
        if (actMember != null && actMember.getPrimary() != null && actMember.getBackup() != null) {
            HashSet<ClientSessionFactoryInternal> clonedFactories = new HashSet<ClientSessionFactoryInternal>();
            Set<ClientSessionFactoryInternal> set = this.factories;
            synchronized (set) {
                clonedFactories.addAll(this.factories);
            }
            for (ClientSessionFactory clientSessionFactory : clonedFactories) {
                ((ClientSessionFactoryInternal)clientSessionFactory).setBackupConnector(actMember.getPrimary(), actMember.getBackup());
            }
        }
        this.updateArraysAndPairs(uniqueEventID);
        if (last) {
            this.receivedTopology = true;
        }
    }

    public String toString() {
        if (this.identity != null) {
            return "ServerLocatorImpl (identity=" + this.identity + ") [initialConnectors=" + Arrays.toString(this.initialConnectors == null ? new TransportConfiguration[]{} : this.initialConnectors) + ", discoveryGroupConfiguration=" + String.valueOf(this.discoveryGroupConfiguration) + "]";
        }
        return "ServerLocatorImpl [initialConnectors=" + Arrays.toString(this.initialConnectors == null ? new TransportConfiguration[]{} : this.initialConnectors) + ", discoveryGroupConfiguration=" + String.valueOf(this.discoveryGroupConfiguration) + "]";
    }

    private void updateArraysAndPairs(long time) {
        if (this.updateArrayActor == null) {
            this.internalUpdateArray(time);
        } else {
            this.updateArrayActor.act((Object)time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUpdateArray(long time) {
        Object object = this.topologyArrayGuard;
        synchronized (object) {
            Collection<TopologyMemberImpl> membersCopy = this.topology.getMembers();
            if (membersCopy.isEmpty()) {
                return;
            }
            Pair[] topologyArrayLocal = (Pair[])Array.newInstance(Pair.class, membersCopy.size());
            int count = 0;
            for (TopologyMemberImpl pair : membersCopy) {
                Pair<TransportConfiguration, TransportConfiguration> transportConfigs = pair.getConnector();
                topologyArrayLocal[count++] = new Pair((Object)this.protocolManagerFactory.adaptTransportConfiguration((TransportConfiguration)transportConfigs.getA()), (Object)this.protocolManagerFactory.adaptTransportConfiguration((TransportConfiguration)transportConfigs.getB()));
            }
            this.topologyArray = topologyArrayLocal;
        }
    }

    @Override
    public synchronized void connectorsChanged(List<DiscoveryEntry> newConnectors) {
        if (this.receivedTopology) {
            return;
        }
        ArrayList<TransportConfiguration> newInitialconnectors = new ArrayList<TransportConfiguration>(newConnectors.size());
        for (DiscoveryEntry entry : newConnectors) {
            if (this.ha && this.topology.getMember(entry.getNodeID()) == null) {
                TopologyMemberImpl member = new TopologyMemberImpl(entry.getNodeID(), null, null, entry.getConnector(), null);
                this.topology.updateMember(0L, entry.getNodeID(), member);
            }
            if (entry.getConnector().equals(this.clusterTransportConfiguration)) continue;
            newInitialconnectors.add(entry.getConnector());
        }
        this.initialConnectors = newInitialconnectors.toArray(new TransportConfiguration[newInitialconnectors.size()]);
        if (this.clusterConnection && !this.receivedTopology && this.getNumInitialConnectors() > 0) {
            Runnable connectRunnable = () -> {
                try {
                    this.connect();
                }
                catch (ActiveMQException e) {
                    ActiveMQClientLogger.LOGGER.errorConnectingToNodes((Exception)((Object)e));
                }
            };
            if (this.startExecutor != null) {
                this.startExecutor.execute(connectRunnable);
            } else {
                connectRunnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void factoryClosed(ClientSessionFactory factory) {
        boolean isEmpty;
        Set<ClientSessionFactoryInternal> set = this.factories;
        synchronized (set) {
            this.factories.remove(factory);
            isEmpty = this.factories.isEmpty();
        }
        if (!this.clusterConnection && isEmpty) {
            this.receivedTopology = false;
        }
    }

    @Override
    public ServerLocator setUseTopologyForLoadBalancing(boolean useTopologyForLoadBalancing) {
        this.config.useTopologyForLoadBalancing = useTopologyForLoadBalancing;
        return this;
    }

    @Override
    public boolean getUseTopologyForLoadBalancing() {
        return this.config.useTopologyForLoadBalancing;
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public boolean isConnectable() {
        return this.getNumInitialConnectors() > 0 || this.getDiscoveryGroupConfiguration() != null;
    }

    @Override
    public ServerLocatorImpl addClusterTopologyListener(ClusterTopologyListener listener) {
        this.topology.addClusterTopologyListener(listener);
        return this;
    }

    @Override
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        this.topology.removeClusterTopologyListener(listener);
    }

    public TransportConfiguration[] getInitialConnectors() {
        return this.initialConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFactory(ClientSessionFactoryInternal factory) {
        if (factory == null) {
            return;
        }
        if (this.isClosed()) {
            factory.close();
            return;
        }
        TransportConfiguration backup = null;
        if (this.ha) {
            backup = this.topology.getBackupForConnector((Connector)factory.getConnector());
        }
        factory.setBackupConnector(factory.getConnectorConfiguration(), backup);
        Set<ClientSessionFactoryInternal> set = this.factories;
        synchronized (set) {
            this.factories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertOpen() {
        Object object = this.stateGuard;
        synchronized (object) {
            if (this.state != null && this.state != STATE.INITIALIZED) {
                throw new IllegalStateException("Server locator is closed (maybe it was garbage collected)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.stateGuard;
        synchronized (object) {
            return this.state != STATE.INITIALIZED;
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new ServerLocatorImpl(this);
    }

    public boolean isReceivedTopology() {
        return this.receivedTopology;
    }

    public int getClientSessionFactoryCount() {
        return this.factories.size();
    }

    private String fromInterceptors(List<Interceptor> interceptors) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Interceptor value : interceptors) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(value.getClass().getName());
        }
        return sb.toString();
    }

    private void feedInterceptors(List<Interceptor> interceptors, String interceptorList) {
        interceptors.clear();
        if (interceptorList == null || interceptorList.trim().isEmpty()) {
            return;
        }
        AccessController.doPrivileged(() -> {
            String[] arrayInterceptor;
            for (String strValue : arrayInterceptor = interceptorList.split(",")) {
                Interceptor interceptor = (Interceptor)ClassloadingUtil.newInstanceFromClassLoader(ServerLocatorImpl.class, (String)strValue.trim(), Interceptor.class);
                interceptors.add(interceptor);
            }
            return null;
        });
    }

    static {
        FluentPropertyBeanIntrospectorWithIgnores.addIgnore((String)ServerLocatorImpl.class.getName(), (String)"setThreadPools");
    }

    private static enum STATE {
        INITIALIZED,
        CLOSED,
        CLOSING;

    }

    private final class StaticConnector
    implements Serializable {
        private static final long serialVersionUID = 6772279632415242634L;
        private List<Connector> connectors;

        private StaticConnector() {
        }

        public ClientSessionFactory connect(boolean skipWarnings) throws ActiveMQException {
            ServerLocatorImpl.this.assertOpen();
            ServerLocatorImpl.this.initialize();
            this.createConnectors();
            try {
                int retryNumber = 0;
                while (!ServerLocatorImpl.this.isClosed()) {
                    ++retryNumber;
                    for (Connector conn : this.connectors) {
                        logger.trace("{}::Submitting connect towards {}", (Object)this, (Object)conn);
                        ClientSessionFactory csf = conn.tryConnect();
                        if (csf == null) continue;
                        csf.getConnection().addFailureListener(new FailureListener(){

                            @Override
                            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
                                if (ServerLocatorImpl.this.clusterConnection && exception.getType() == ActiveMQExceptionType.DISCONNECTED) {
                                    try {
                                        ServerLocatorImpl.this.start(ServerLocatorImpl.this.startExecutor);
                                    }
                                    catch (Exception e) {
                                        ActiveMQClientLogger.LOGGER.errorStartingLocator(e);
                                    }
                                }
                            }

                            @Override
                            public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                                this.connectionFailed(me, failedOver);
                            }

                            public String toString() {
                                return "FailureListener('restarts cluster connections')";
                            }
                        });
                        if (logger.isTraceEnabled()) {
                            logger.trace("Returning {} after {} retries on StaticConnector {}", new Object[]{csf, retryNumber, ServerLocatorImpl.this});
                        }
                        return csf;
                    }
                    if (ServerLocatorImpl.this.config.initialConnectAttempts >= 0 && retryNumber > ServerLocatorImpl.this.config.initialConnectAttempts) break;
                    if (!ServerLocatorImpl.this.latch.await(ServerLocatorImpl.this.config.retryInterval, TimeUnit.MILLISECONDS)) continue;
                    return null;
                }
            }
            catch (RejectedExecutionException e) {
                if (ServerLocatorImpl.this.isClosed() || skipWarnings) {
                    return null;
                }
                logger.trace("Rejected execution", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                if (ServerLocatorImpl.this.isClosed() || skipWarnings) {
                    return null;
                }
                ActiveMQClientLogger.LOGGER.errorConnectingToNodes(e);
                throw ActiveMQClientMessageBundle.BUNDLE.cannotConnectToStaticConnectors(e);
            }
            if (ServerLocatorImpl.this.isClosed() || skipWarnings) {
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Could not connect to any nodes. throwing an error now.", (Throwable)new Exception("trace"));
            }
            throw ActiveMQClientMessageBundle.BUNDLE.cannotConnectToStaticConnectors2();
        }

        private synchronized void createConnectors() {
            if (this.connectors != null) {
                for (Connector conn : this.connectors) {
                    if (conn == null) continue;
                    conn.disconnect();
                }
            }
            this.connectors = new ArrayList<Connector>();
            if (ServerLocatorImpl.this.initialConnectors != null) {
                for (TransportConfiguration initialConnector : ServerLocatorImpl.this.initialConnectors) {
                    ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl((ServerLocatorInternal)ServerLocatorImpl.this, initialConnector, ServerLocatorImpl.this.config, ServerLocatorImpl.this.config.reconnectAttempts, ServerLocatorImpl.this.threadPool, ServerLocatorImpl.this.scheduledThreadPool, ServerLocatorImpl.this.flowControlThreadPool, ServerLocatorImpl.this.incomingInterceptors, ServerLocatorImpl.this.outgoingInterceptors);
                    this.connectors.add(new Connector(initialConnector, factory));
                }
            }
        }

        public synchronized void disconnect() {
            if (this.connectors != null) {
                for (Connector connector : this.connectors) {
                    connector.disconnect();
                }
            }
        }

        private final class Connector {
            private final TransportConfiguration initialConnector;
            private volatile ClientSessionFactoryInternal factory;

            private Connector(TransportConfiguration initialConnector, ClientSessionFactoryInternal factory) {
                this.initialConnector = initialConnector;
                this.factory = factory;
            }

            public ClientSessionFactory tryConnect() throws ActiveMQException {
                logger.trace("{}::Trying to connect to {}", (Object)this, (Object)this.factory);
                try {
                    ClientSessionFactoryInternal factoryToUse = this.factory;
                    if (factoryToUse != null) {
                        ServerLocatorImpl.this.addToConnecting(factoryToUse);
                        try {
                            factoryToUse.connect(1, false);
                        }
                        finally {
                            ServerLocatorImpl.this.removeFromConnecting(factoryToUse);
                        }
                    }
                    return factoryToUse;
                }
                catch (ActiveMQException e) {
                    logger.trace("{}::Exception on establish connector initial connection", (Object)this, (Object)e);
                    return null;
                }
            }

            public void disconnect() {
                if (this.factory != null) {
                    this.factory.causeExit();
                    this.factory.cleanup();
                    this.factory = null;
                }
            }

            public String toString() {
                return "Connector [initialConnector=" + String.valueOf(this.initialConnector) + "]";
            }
        }
    }
}

