/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExpiryAddressTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession clientSession;
    private ServerLocator locator;

    @Test
    public void testBasicSend() throws Exception {
        SimpleString ea = SimpleString.of((String)"EA");
        SimpleString adSend = SimpleString.of((String)"a1");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString eq = SimpleString.of((String)"EA1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)qName).setAddress(adSend).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(adSend);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(eq);
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)qName.toString(), (Object)m.getStringProperty(Message.HDR_ORIGINAL_QUEUE));
        Assertions.assertEquals((Object)adSend.toString(), (Object)m.getStringProperty(Message.HDR_ORIGINAL_ADDRESS));
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Test
    public void testExpireSingleMessage() throws Exception {
        SimpleString ea = SimpleString.of((String)"EA");
        SimpleString adSend = SimpleString.of((String)"a1");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString eq = SimpleString.of((String)"EA1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)qName).setAddress(adSend).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(adSend);
        for (int i = 0; i < 2100; ++i) {
            ClientMessage clientMessage = this.createTextMessage(this.clientSession, "notExpired!");
            clientMessage.putIntProperty("i", i);
            producer.send((Message)clientMessage);
        }
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        Queue queueQ1 = this.server.locateQueue("q1");
        CountDownLatch latch = new CountDownLatch(10);
        for (int i = 0; i < 10; ++i) {
            queueQ1.expireReferences(latch::countDown);
        }
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(eq);
        ClientMessage m = clientConsumer.receive(5000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)qName.toString(), (Object)m.getStringProperty(Message.HDR_ORIGINAL_QUEUE));
        Assertions.assertEquals((Object)adSend.toString(), (Object)m.getStringProperty(Message.HDR_ORIGINAL_ADDRESS));
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Test
    public void testBasicSendWithRetroActiveAddressSettings() throws Exception {
        SimpleString expiryAddress1 = SimpleString.of((String)"expiryAddress1");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString expiryQueue1 = SimpleString.of((String)"expiryQueue1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(expiryAddress1);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)expiryQueue1).setAddress(expiryAddress1).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)qName).setDurable(Boolean.valueOf(false)));
        SimpleString expiryAddress2 = SimpleString.of((String)"expiryAddress2");
        SimpleString expiryQueue2 = SimpleString.of((String)"expiryQueue2");
        addressSettings = new AddressSettings().setExpiryAddress(expiryAddress2);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)expiryQueue2).setAddress(expiryAddress2).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(expiryQueue1);
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(expiryQueue2);
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Test
    public void testBasicSendToMultipleQueues() throws Exception {
        SimpleString ea = SimpleString.of((String)"EA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString eq = SimpleString.of((String)"EQ1");
        SimpleString eq2 = SimpleString.of((String)"EQ2");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)eq2).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(eq);
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertNotNull((Object)m.getStringProperty(Message.HDR_ORIGINAL_ADDRESS));
        Assertions.assertNotNull((Object)m.getStringProperty(Message.HDR_ORIGINAL_QUEUE));
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(eq2);
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertNotNull((Object)m.getStringProperty(Message.HDR_ORIGINAL_ADDRESS));
        Assertions.assertNotNull((Object)m.getStringProperty(Message.HDR_ORIGINAL_QUEUE));
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        clientConsumer.close();
        this.clientSession.commit();
    }

    @Test
    public void testBasicSendToNoQueue() throws Exception {
        SimpleString ea = SimpleString.of((String)"EA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString eq = SimpleString.of((String)"EQ1");
        SimpleString eq2 = SimpleString.of((String)"EQ2");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)eq2).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
    }

    @Test
    public void testHeadersSet() throws Exception {
        int NUM_MESSAGES = 5;
        SimpleString ea = SimpleString.of((String)"DLA");
        SimpleString qName = SimpleString.of((String)"q1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().addMatch(qName.toString(), (Object)addressSettings);
        SimpleString eq = SimpleString.of((String)"EA1");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)qName).setDurable(Boolean.valueOf(false)));
        ServerLocator locator1 = this.createInVMNonHALocator();
        ClientSessionFactory sessionFactory = this.createSessionFactory(locator1);
        ClientSession sendSession = sessionFactory.createSession(false, true, true);
        ClientProducer producer = sendSession.createProducer(qName);
        long expiration = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = this.createTextMessage(this.clientSession, "Message:" + i);
            tm.setExpiration(expiration);
            producer.send((Message)tm);
        }
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        this.clientSession.start();
        ClientMessage m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        ClientConsumer cc3 = this.clientSession.createConsumer(eq);
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = cc3.receive(1000L);
            Assertions.assertNotNull((Object)tm);
            String text = tm.getBodyBuffer().readString();
            Assertions.assertEquals((Object)("Message:" + i), (Object)text);
            Long actualExpiryTime = (Long)tm.getObjectProperty(Message.HDR_ACTUAL_EXPIRY_TIME);
            Assertions.assertTrue((actualExpiryTime >= expiration ? 1 : 0) != 0);
        }
        sendSession.close();
        locator1.close();
    }

    @Test
    public void testExpireWithDefaultAddressSettings() throws Exception {
        SimpleString ea = SimpleString.of((String)"EA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString eq = SimpleString.of((String)"EA1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().setDefault((Object)addressSettings);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(eq);
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Test
    public void testExpireWithWildcardAddressSettings() throws Exception {
        SimpleString ea = SimpleString.of((String)"EA");
        SimpleString qName = SimpleString.of((String)"q1");
        SimpleString eq = SimpleString.of((String)"EA1");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(ea);
        this.server.getAddressSettingsRepository().addMatch("*", (Object)addressSettings);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)eq).setAddress(ea).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(qName);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(qName);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(eq);
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Test
    public void testExpireWithOverridenSublevelAddressSettings() throws Exception {
        SimpleString address = SimpleString.of((String)"prefix.address");
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString defaultExpiryAddress = RandomUtil.randomSimpleString();
        SimpleString defaultExpiryQueue = RandomUtil.randomSimpleString();
        SimpleString specificExpiryAddress = RandomUtil.randomSimpleString();
        SimpleString specificExpiryQueue = RandomUtil.randomSimpleString();
        AddressSettings defaultAddressSettings = new AddressSettings().setExpiryAddress(defaultExpiryAddress);
        this.server.getAddressSettingsRepository().addMatch("prefix.*", (Object)defaultAddressSettings);
        AddressSettings specificAddressSettings = new AddressSettings().setExpiryAddress(specificExpiryAddress);
        this.server.getAddressSettingsRepository().addMatch("prefix.address", (Object)specificAddressSettings);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)defaultExpiryQueue).setAddress(defaultExpiryAddress).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)specificExpiryQueue).setAddress(specificExpiryAddress).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(address);
        ClientMessage clientMessage = this.createTextMessage(this.clientSession, "heyho!");
        clientMessage.setExpiration(System.currentTimeMillis());
        producer.send((Message)clientMessage);
        this.clientSession.start();
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queue);
        ClientMessage m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(defaultExpiryQueue);
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        clientConsumer.close();
        clientConsumer = this.clientSession.createConsumer(specificExpiryQueue);
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"heyho!");
        m.acknowledge();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)false));
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true);
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(sessionFactory.createSession(null, null, false, true, true, false, 0));
    }
}

