/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.uri.ServerLocatorParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServerLocatorConnectTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createDefaultConfig(this.isNetty());
        this.server = this.createServer(false, configuration);
    }

    @Test
    public void testFailFastConnectOnClosing() throws Exception {
        this.server.start();
        CountDownLatch connectLatch = new CountDownLatch(1);
        CountDownLatch subscribeLatch = new CountDownLatch(1);
        AtomicBoolean connectTimedOut = new AtomicBoolean(false);
        ServerLocator locator = this.createNonHALocator(this.isNetty()).setCallTimeout(30000L);
        try (ClientSessionFactory csf = locator.createSessionFactory();){
            Assertions.assertFalse((boolean)csf.isClosed());
        }
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)((Interceptor)(packet, connection) -> {
            if (packet.getType() == 113) {
                subscribeLatch.countDown();
                return false;
            }
            return true;
        }));
        new Thread(() -> {
            try {
                locator.createSessionFactory();
            }
            catch (Exception e) {
                connectTimedOut.set(e.getClass() == ActiveMQObjectClosedException.class);
            }
            connectLatch.countDown();
        }).start();
        subscribeLatch.await();
        locator.close();
        Assertions.assertTrue((boolean)connectLatch.await(3000L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)connectTimedOut.get());
    }

    @Test
    public void testURL() throws Exception {
        this.server.start();
        ServerLocatorParser parser = new ServerLocatorParser();
        URI uri = new URI("tcp://localhost:61616?&blockOnNonDurableSend=true&retryIntervalMultiplier=1.0&maxRetryInterval=2000&producerMaxRate=-1&blockOnDurableSend=true&connectionTTL=60000&compressLargeMessage=false&reconnectAttempts=0&cacheLargeMessagesClient=false&scheduledThreadPoolMaxSize=5&useGlobalPools=true&callFailoverTimeout=-1&initialConnectAttempts=1&clientFailureCheckPeriod=30000&blockOnAcknowledge=true&consumerWindowSize=1048576&minLargeMessageSize=102400&autoGroup=false&threadPoolMaxSize=-1&confirmationWindowSize=-1&transactionBatchSize=1048576&callTimeout=30000&preAcknowledge=false&connectionLoadBalancingPolicyClassName=org.apache.activemq.artemis.api.core.client.loadbalance.RoundRobinConnectionLoadBalancingPolicy&dupsOKBatchSize=1048576&initialMessagePacketSize=1500&consumerMaxRate=-1&retryInterval=2000&producerWindowSize=65536&port=61616&host=localhost#");
        for (int i = 0; i < 10; ++i) {
            ServerLocator locator = (ServerLocator)parser.newObject(uri, null);
            ClientSessionFactory csf = this.createSessionFactory(locator);
            csf.close();
            locator.close();
        }
    }

    @Test
    public void testSingleConnectorSingleServer() throws Exception {
        this.server.start();
        ServerLocator locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(0, this.isNetty()))});
        ClientSessionFactory csf = this.createSessionFactory(locator);
        csf.close();
        locator.close();
    }

    @Test
    public void testSingleConnectorSingleServerConnect() throws Exception {
        this.server.start();
        ServerLocatorInternal locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(0, this.isNetty()))});
        ClientSessionFactoryInternal csf = locator.connect();
        Assertions.assertNotNull((Object)csf);
        Assertions.assertEquals((int)csf.numConnections(), (int)1);
        locator.close();
    }

    @Test
    public void testMultipleConnectorSingleServerConnect() throws Exception {
        this.server.start();
        ServerLocatorInternal locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(0, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(1, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(2, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(3, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(4, this.isNetty()))});
        ClientSessionFactoryInternal csf = locator.connect();
        Assertions.assertNotNull((Object)csf);
        Assertions.assertEquals((int)csf.numConnections(), (int)1);
        locator.close();
    }

    @Test
    public void testMultipleConnectorSingleServerConnectReconnect() throws Exception {
        this.server.start();
        ServerLocatorInternal locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(0, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(1, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(2, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(3, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(4, this.isNetty()))});
        locator.setReconnectAttempts(15);
        ClientSessionFactoryInternal csf = locator.connect();
        Assertions.assertNotNull((Object)csf);
        Assertions.assertEquals((int)csf.numConnections(), (int)1);
        locator.close();
    }

    @Test
    public void testMultipleConnectorSingleServerNoConnect() throws Exception {
        this.server.start();
        ServerLocatorInternal locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(1, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(2, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(3, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(4, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(5, this.isNetty()))});
        ClientSessionFactoryInternal csf = null;
        try {
            csf = locator.connect();
        }
        catch (ActiveMQNotConnectedException activeMQNotConnectedException) {
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof ActiveMQException));
            Assertions.fail((String)("Invalid Exception type:" + ((ActiveMQException)((Object)e)).getType()));
        }
        Assertions.assertNull((Object)csf);
        locator.close();
    }

    @Test
    public void testMultipleConnectorSingleServerNoConnectAttemptReconnect() throws Exception {
        this.server.start();
        ServerLocatorInternal locator = (ServerLocatorInternal)ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(1, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(2, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(3, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(4, this.isNetty())), ServerLocatorConnectTest.createTransportConfiguration(this.isNetty(), false, ServerLocatorConnectTest.generateParams(5, this.isNetty()))});
        locator.setReconnectAttempts(15);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Connector target = new Connector(locator, countDownLatch);
        Thread t = new Thread(target);
        t.start();
        Thread.sleep(500L);
        locator.close();
        Assertions.assertTrue((boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)target.csf);
    }

    @Test
    public void testNoWarningWhenNotConnecting() throws Exception {
        try (AssertionLoggerHandler handler = new AssertionLoggerHandler();){
            try (ServerLocatorImpl locator = (ServerLocatorImpl)ServerLocatorImpl.newLocator((String)"tcp://localhost:61616");){
                locator.connect();
                Assertions.fail((String)"Expected an exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assertions.assertFalse((boolean)handler.findText(new String[]{"AMQ212025"}));
        }
    }

    public boolean isNetty() {
        return true;
    }

    static class Connector
    implements Runnable {
        private final ServerLocatorInternal locator;
        ClientSessionFactory csf = null;
        CountDownLatch latch;
        Exception e;

        Connector(ServerLocatorInternal locator, CountDownLatch latch) {
            this.locator = locator;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                this.csf = this.locator.connect();
            }
            catch (Exception e) {
                this.e = e;
            }
            this.latch.countDown();
        }
    }
}

