/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class LargeHeadersClusterTest
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final SimpleString queueName = SimpleString.of((String)"queues.0");
    private static final int NUMBER_OF_MESSAGES = 154;
    @Parameter(index=0)
    public String protocol;

    @Parameters(name="protocol={0}")
    public static Collection getParameters() {
        return Arrays.asList({"AMQP"}, {"CORE"}, {"OPENWIRE"});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    private void startServers(MessageLoadBalancingType loadBalancingType) throws Exception {
        this.setupServers();
        this.setRedistributionDelay(0L);
        this.setupCluster(loadBalancingType);
        AddressSettings as = new AddressSettings().setRedistributionDelay(0L).setExpiryAddress(SimpleString.of((String)"queues.expiry"));
        this.getServer(0).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.getServer(1).getAddressSettingsRepository().addMatch("queues.*", (Object)as);
        this.startServers(0);
        this.startServers(1);
        this.createQueue(SimpleString.of((String)"queues.expiry"));
        this.createQueue(queueName);
    }

    private void createQueue(SimpleString queueName) throws Exception {
        QueueConfiguration queueConfiguration = QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST);
        this.servers[0].createQueue(queueConfiguration);
        this.servers[1].createQueue(queueConfiguration);
    }

    protected boolean isNetty() {
        return true;
    }

    private ConnectionFactory getJmsConnectionFactory(int node) {
        if (this.protocol.equals("AMQP")) {
            return new JmsConnectionFactory("amqp://localhost:" + (61616 + node));
        }
        if (this.protocol.equals("OPENWIRE")) {
            return new ActiveMQConnectionFactory("tcp://localhost:" + (61616 + node));
        }
        if (this.protocol.equals("CORE")) {
            return new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory("tcp://localhost:" + (61616 + node));
        }
        Assertions.fail((String)("Protocol " + this.protocol + " unknown"));
        return null;
    }

    @TestTemplate
    public void testGrowingHeaders() throws Exception {
        MessageProducer pd;
        Session sn;
        this.startServers(MessageLoadBalancingType.ON_DEMAND);
        ConnectionFactory cf0 = this.getJmsConnectionFactory(0);
        ConnectionFactory cf1 = this.getJmsConnectionFactory(1);
        try (Connection cn = cf0.createConnection();){
            int i;
            sn = cn.createSession(false, 1);
            pd = sn.createProducer((Destination)sn.createQueue(queueName.toString()));
            StringBuffer bufferString = new StringBuffer();
            for (i = 0; i < 9500; ++i) {
                bufferString.append("-");
            }
            i = 0;
            try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
                try {
                    for (i = 0; i < 1000; ++i) {
                        if (i % 100 == 0) {
                            logger.info("Sent {} messages", (Object)i);
                        }
                        TextMessage message = sn.createTextMessage("hello " + i);
                        message.setStringProperty("large", bufferString.toString());
                        message.setBooleanProperty("newSender", false);
                        pd.send((Message)message);
                        pd.send((Message)message);
                        bufferString.append("-");
                    }
                }
                catch (Throwable e) {
                    logger.warn("error at {}", (Object)i, (Object)e);
                }
                if (!this.protocol.equals("AMQP")) {
                    Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ144012"}));
                }
            }
        }
        try (Connection connection1 = cf1.createConnection();){
            Session session = connection1.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("queues.0"));
            connection1.start();
            this.receiveAllMessages(consumer, 1, m -> logger.debug("received {}", m));
        }
        cn = cf0.createConnection();
        try {
            sn = cn.createSession(false, 1);
            pd = sn.createProducer((Destination)sn.createQueue(queueName.toString()));
            try {
                for (int i = 0; i < 1000; ++i) {
                    if (i % 100 == 0) {
                        logger.info("Sent {} messages", (Object)i);
                    }
                    TextMessage message = sn.createTextMessage("newSender " + i);
                    message.setBooleanProperty("newSender", true);
                    pd.send((Message)message);
                    pd.send((Message)message);
                }
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
            }
        }
        finally {
            if (cn != null) {
                cn.close();
            }
        }
        AtomicBoolean newSenderFound = new AtomicBoolean(false);
        try (Connection connection1 = cf1.createConnection();){
            Session session = connection1.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("queues.0"));
            connection1.start();
            this.receiveAllMessages(consumer, 1000, m -> {
                try {
                    if (m.getBooleanProperty("newSender")) {
                        newSenderFound.set(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        Assertions.assertTrue((boolean)newSenderFound.get());
    }

    private int receiveAllMessages(MessageConsumer messageConsume, int minMessages, Consumer<Message> messageProcessor) throws JMSException {
        Message message;
        int msg = 0;
        while ((message = msg < minMessages ? messageConsume.receive(10000L) : messageConsume.receive(1000L)) != null) {
            ++msg;
            if (messageProcessor == null) continue;
            messageProcessor.accept(message);
        }
        return msg;
    }

    protected void setupCluster(MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.setupClusterConnection("cluster0", "queues", messageLoadBalancingType, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", messageLoadBalancingType, 1, this.isNetty(), 1, 0);
    }

    protected void setRedistributionDelay(long delay) {
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.servers[0].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
        this.servers[1].addProtocolManagerFactory((ProtocolManagerFactory)new ProtonProtocolManagerFactory());
        this.servers[0].addProtocolManagerFactory((ProtocolManagerFactory)new OpenWireProtocolManagerFactory());
        this.servers[1].addProtocolManagerFactory((ProtocolManagerFactory)new OpenWireProtocolManagerFactory());
        this.servers[0].getConfiguration().setJournalBufferSize_NIO(20480);
        this.servers[0].getConfiguration().setJournalBufferSize_AIO(20480);
        this.servers[1].getConfiguration().setJournalBufferSize_NIO(20480);
        this.servers[1].getConfiguration().setJournalBufferSize_AIO(20480);
        this.servers[0].getConfiguration().getAddressSettings().clear();
        this.servers[0].getConfiguration().addAddressSetting("#", new AddressSettings().setRedistributionDelay(10L));
        this.servers[1].getConfiguration().getAddressSettings().clear();
        this.servers[1].getConfiguration().addAddressSetting("#", new AddressSettings().setRedistributionDelay(10L));
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1);
        this.clearServer(0, 1);
    }

    @Override
    protected ConfigurationImpl createBasicConfig(int serverID) {
        ConfigurationImpl configuration = super.createBasicConfig(serverID);
        configuration.setMessageExpiryScanPeriod(100L);
        return configuration;
    }
}

