/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSymmetricClusterTest
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public boolean isNetty() {
        return false;
    }

    @Test
    public void testSimpleWithBackup() throws Exception {
        int i;
        this.setupBackupServer(0, 3, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupBackupServer(1, 4, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupBackupServer(2, 5, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupPrimaryServer(3, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupPrimaryServer(4, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupPrimaryServer(5, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 3, 4, 5);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 4, 3, 5);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 5, 3, 4);
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 4, 5);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 3, 5);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 3, 4);
        this.startServers(0, 1, 2, 3, 4, 5);
        logger.debug("");
        for (i = 0; i <= 5; ++i) {
            logger.debug(this.servers[i].describe());
            logger.debug(this.debugBindings(this.servers[i], this.servers[i].getConfiguration().getManagementNotificationAddress().toString()));
        }
        logger.debug("");
        logger.debug("");
        for (i = 0; i <= 5; ++i) {
            logger.debug(this.servers[i].describe());
            logger.debug(this.debugBindings(this.servers[i], this.servers[i].getConfiguration().getManagementNotificationAddress().toString()));
        }
        logger.debug("");
        this.stopServers(0, 1, 2, 3, 4, 5);
    }

    @Test
    public void testSimple() throws Exception {
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupServer(2, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 2, 0);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.startServers(0, 1, 2);
        SimpleSymmetricClusterTest.waitForTopology(this.servers[0], 3);
        SimpleSymmetricClusterTest.waitForTopology(this.servers[1], 3);
        SimpleSymmetricClusterTest.waitForTopology(this.servers[2], 3);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
    }

    @Test
    public void testWildcardFlowControl() throws Exception {
        int PRODUCER_COUNT = 3000;
        int ITERATIONS = 4;
        CountDownLatch consumerLatch = new CountDownLatch(12000);
        CountDownLatch producerLatch = new CountDownLatch(12000);
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.servers[0].getConfiguration().setWildcardRoutingEnabled(true);
        this.servers[1].getConfiguration().setWildcardRoutingEnabled(true);
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        SimpleSymmetricClusterTest.waitForTopology(this.servers[0], 2);
        SimpleSymmetricClusterTest.waitForTopology(this.servers[1], 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        logger.info("Creating 3000 multicast addresses on node 1...");
        for (int i = 0; i < 3000; ++i) {
            this.createAddressInfo(1, "queues." + i, RoutingType.MULTICAST, -1, false);
        }
        logger.info("Addresses created.");
        this.createQueue(0, "queues.#", "queue", null, false, RoutingType.MULTICAST);
        logger.info("Creating consumer on node 0");
        this.addConsumer(0, 0, "queue", null);
        this.consumers[0].getConsumer().setMessageHandler(message -> {
            logger.debug("Received: " + message);
            consumerLatch.countDown();
        });
        this.waitForBindings(0, "queues.#", 1, 1, true);
        logger.info("Creating 3000 producers...");
        ClientProducer[] producers = new ClientProducer[3000];
        ClientSession[] sessions = new ClientSession[3000];
        for (int i = 0; i < 3000; ++i) {
            ClientSessionFactory sf = this.sfs[1];
            sessions[i] = this.addClientSession(sf.createSession(true, true, 0));
            producers[i] = this.addClientProducer(sessions[i].createProducer("queues." + i));
        }
        ExecutorService executorService = Executors.newFixedThreadPool(3000);
        this.runAfter(executorService::shutdownNow);
        for (int i = 0; i < 3000; ++i) {
            ClientProducer producer = producers[i];
            ClientMessage message2 = sessions[i].createMessage(true);
            executorService.submit(() -> {
                for (int j = 0; j < 4; ++j) {
                    try {
                        producer.send((Message)message2);
                        producerLatch.countDown();
                        logger.debug("Sent message");
                        continue;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        producerLatch.await(30L, TimeUnit.SECONDS);
        logger.info("Waiting for messages on node 0");
        Assertions.assertTrue((boolean)consumerLatch.await(30L, TimeUnit.SECONDS));
    }

    @Test
    public void testSimpleRestartClusterConnection() throws Exception {
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupServer(2, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 2, 0);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.startServers(0, 1, 2);
        SimpleSymmetricClusterTest.waitForTopology(this.servers[0], 3);
        SimpleSymmetricClusterTest.waitForTopology(this.servers[1], 3);
        SimpleSymmetricClusterTest.waitForTopology(this.servers[2], 3);
        ClusterConnection clusterConnection0 = this.getServer(0).getClusterManager().getClusterConnection("cluster0");
        ClusterConnection clusterConnection1 = this.getServer(1).getClusterManager().getClusterConnection("cluster1");
        ClusterConnection clusterConnection2 = this.getServer(2).getClusterManager().getClusterConnection("cluster2");
        Wait.assertEquals((int)2, () -> ((ClusterConnectionImpl)clusterConnection0).getRecords().size());
        Wait.assertEquals((int)2, () -> ((ClusterConnectionImpl)clusterConnection1).getRecords().size());
        Wait.assertEquals((int)2, () -> ((ClusterConnectionImpl)clusterConnection2).getRecords().size());
        ArrayList clusterConnectionRecords0 = new ArrayList(((ClusterConnectionImpl)clusterConnection0).getRecords().values());
        ArrayList clusterConnectionRecords1 = new ArrayList(((ClusterConnectionImpl)clusterConnection1).getRecords().values());
        ArrayList clusterConnectionRecords2 = new ArrayList(((ClusterConnectionImpl)clusterConnection2).getRecords().values());
        clusterConnection0.stop();
        clusterConnection1.stop();
        clusterConnection2.stop();
        Assertions.assertEquals((int)0, (int)((ClusterConnectionImpl)clusterConnection0).getRecords().size());
        Assertions.assertEquals((int)0, (int)((ClusterConnectionImpl)clusterConnection1).getRecords().size());
        Assertions.assertEquals((int)0, (int)((ClusterConnectionImpl)clusterConnection2).getRecords().size());
        Wait.assertTrue(() -> clusterConnectionRecords0.stream().noneMatch(messageFlowRecord -> messageFlowRecord.getBridge().isConnected()), (long)1000L);
        Wait.assertTrue(() -> clusterConnectionRecords1.stream().noneMatch(messageFlowRecord -> messageFlowRecord.getBridge().isConnected()), (long)1000L);
        Wait.assertTrue(() -> clusterConnectionRecords2.stream().noneMatch(messageFlowRecord -> messageFlowRecord.getBridge().isConnected()), (long)1000L);
        clusterConnection0.start();
        clusterConnection1.start();
        clusterConnection2.start();
        Wait.assertEquals((int)2, () -> ((ClusterConnectionImpl)clusterConnection0).getRecords().size());
        Wait.assertEquals((int)2, () -> ((ClusterConnectionImpl)clusterConnection1).getRecords().size());
        Wait.assertEquals((int)2, () -> ((ClusterConnectionImpl)clusterConnection2).getRecords().size());
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
    }

    @Test
    public void testDeleteAddress() throws Exception {
        String ADDRESS = "queues.testaddress";
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        SimpleSymmetricClusterTest.waitForTopology(this.servers[0], 2);
        SimpleSymmetricClusterTest.waitForTopology(this.servers[1], 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        Collection bindings = this.servers[0].getPostOffice().getDirectBindings(SimpleString.of((String)"queues.testaddress"));
        Assertions.assertEquals((int)2, (int)bindings.size());
        SimpleString snf = null;
        for (Binding binding : bindings) {
            if (!(binding instanceof RemoteQueueBinding)) continue;
            snf = ((RemoteQueueBinding)binding).getQueue().getName();
        }
        Assertions.assertNotNull(snf);
        Assertions.assertNotNull((Object)this.servers[0].locateQueue(snf));
        this.servers[0].getActiveMQServerControl().deleteAddress("queues.testaddress", true);
        bindings = this.servers[0].getPostOffice().getDirectBindings(SimpleString.of((String)"queues.testaddress"));
        Assertions.assertEquals((int)0, (int)bindings.size());
        Assertions.assertNotNull((Object)this.servers[0].locateQueue(snf));
    }

    @Test
    public void testSimple_TwoNodes() throws Exception {
        this.setupServer(0, false, this.isNetty());
        this.setupServer(1, false, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.closeAllConsumers();
    }

    @Test
    public void testSimpleSnFManagement() throws Exception {
        String address = "queues.testaddress";
        String queue = "queue0";
        this.setupServer(0, false, this.isNetty());
        this.setupServer(1, false, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        SimpleString SnFQueueName = SimpleString.of((String)Arrays.stream(this.servers[0].getActiveMQServerControl().getQueueNames()).filter(queueName -> queueName.contains(this.servers[0].getInternalNamingPrefix())).findFirst().orElse(null));
        Assertions.assertNotNull((Object)SnFQueueName);
        QueueControl queueControl = ManagementControlHelper.createQueueControl(SnFQueueName, SnFQueueName, RoutingType.MULTICAST, this.servers[0].getMBeanServer());
        queueControl.pause();
        Assertions.assertTrue((boolean)queueControl.isPaused());
        queueControl.resume();
        Assertions.assertFalse((boolean)queueControl.isPaused());
        this.closeAllConsumers();
    }

    @Test
    public void testSimple2() throws Exception {
        int i;
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupServer(2, true, this.isNetty());
        this.setupServer(3, true, this.isNetty());
        this.setupServer(4, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2, 3, 4);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2, 3, 4);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1, 3, 4);
        this.setupClusterConnection("cluster3", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 3, 0, 1, 2, 4);
        this.setupClusterConnection("cluster4", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 4, 0, 1, 2, 3);
        this.startServers(0, 1, 2, 3, 4);
        for (i = 0; i <= 4; ++i) {
            SimpleSymmetricClusterTest.waitForTopology(this.servers[i], 5);
        }
        logger.debug("All the servers have been started already!");
        for (i = 0; i <= 4; ++i) {
            this.setupSessionFactory(i, this.isNetty());
        }
        for (i = 0; i <= 4; ++i) {
            this.createQueue(i, "queues.testaddress", "queue0", null, false);
        }
        for (i = 0; i <= 4; ++i) {
            this.addConsumer(i, i, "queue0", null);
        }
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
    }

    @Test
    public void testSimpleRoundRobbin() throws Exception {
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupServer(2, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 10, 100L, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 10, 100L, this.isNetty(), 1, 2, 0);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 10, 100L, this.isNetty(), 2, 0, 1);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 33, true, null);
        this.verifyReceiveRoundRobin(33, 0, 1, 2);
        this.stopServers(2);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 100, true, null);
        this.verifyReceiveRoundRobin(100, 0, 1);
        this.sfs[2] = null;
        this.consumers[2] = null;
        this.startServers(2);
        this.setupSessionFactory(2, this.isNetty());
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 33, true, null);
        this.verifyReceiveRoundRobinInSomeOrder(33, 2, 0, 1);
    }

    @Test
    @Disabled(value="Test not implemented yet")
    public void testSimpleRoundRobbinNoFailure() throws Exception {
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupServer(2, true, this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, -1, 1000L, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, -1, 1000L, this.isNetty(), 1, 2, 0);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, -1, 1000L, this.isNetty(), 2, 0, 1);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 33, true, null);
        this.verifyReceiveRoundRobin(33, 0, 1, 2);
        this.stopServers(2);
        this.send(0, "queues.testaddress", 100, true, null);
        this.verifyReceiveRoundRobin(100, 0, 1, -1);
        this.sfs[2] = null;
        this.consumers[2] = null;
        this.startServers(2);
        this.setupSessionFactory(2, this.isNetty());
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.verifyReceiveRoundRobin(100, -1, -1, 2);
    }

    @Test
    public void testDivertRedistributedMessage() throws Exception {
        String queue = "queue0";
        String divertedQueueName = "divertedQueue";
        int messageCount = 10;
        this.setupServer(0, true, this.isNetty());
        this.setupServer(1, true, this.isNetty());
        this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.servers[0].getConfiguration().addAddressSetting("#", new AddressSettings().setRedistributionDelay(0L));
        this.servers[1].getConfiguration().addAddressSetting("#", new AddressSettings().setRedistributionDelay(0L));
        this.startServers(0, 1);
        this.servers[0].deployDivert(new DivertConfiguration().setName("myDivert").setAddress("queue0").setRoutingType(ComponentConfigurationRoutingType.ANYCAST).setForwardingAddress("divertedQueue").setExclusive(true));
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queue0", "queue0", null, true, RoutingType.ANYCAST);
        this.createQueue(1, "queue0", "queue0", null, true, RoutingType.ANYCAST);
        this.createQueue(0, "divertedQueue", "divertedQueue", null, true, RoutingType.ANYCAST);
        this.createQueue(1, "divertedQueue", "divertedQueue", null, true, RoutingType.ANYCAST);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queue0", 1, 1, true);
        this.waitForBindings(1, "queue0", 1, 1, false);
        this.send(1, "queue0", 10, true, null);
        Wait.assertEquals((Long)10L, () -> this.servers[0].locateQueue("divertedQueue").getMessageCount(), (long)2000L, (long)100L);
        this.addConsumer(1, 1, "divertedQueue", null);
        this.verifyReceiveAll(10, 1);
        this.closeAllConsumers();
    }
}

