/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FakeServiceComponent;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkIsolationTest
extends FailoverTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String badAddress = "203.0.113.1";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.startBackupServer = false;
        super.setUp();
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getNettyAcceptor(live, 1);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getNettyConnector(live, 1);
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(xa, autoCommitSends, autoCommitAcks));
    }

    @Test
    public void testReactivate() throws Exception {
        this.primaryServer.getServer().getConfiguration().setNetworkCheckPeriod(100L).setNetworkCheckTimeout(200);
        this.primaryServer.start();
        Assertions.assertTrue((boolean)Wait.waitFor(this.primaryServer::isActive));
        this.primaryServer.getServer().getNetworkHealthCheck().addAddress(badAddress);
        Wait.assertFalse(() -> ((TestableServer)this.primaryServer).isStarted());
        this.primaryServer.getServer().getNetworkHealthCheck().clearAddresses();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> ((TestableServer)this.primaryServer).isStarted()));
    }

    @Test
    public void testDoNotActivateOnIsolation() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            int i;
            ServerLocatorInternal locator = this.getServerLocator();
            this.backupServer.getServer().getNetworkHealthCheck().addAddress("127.0.0.1");
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ202001"}));
            this.backupServer.getServer().getNetworkHealthCheck().setIgnoreLoopback(true).addAddress("127.0.0.1");
            Assertions.assertEquals((int)1, (int)loggerHandler.countText(new String[]{"AMQ202001"}));
            this.backupServer.getServer().getNetworkHealthCheck().clearAddresses();
            this.backupServer.getServer().getNetworkHealthCheck().addAddress(badAddress);
            this.backupServer.getServer().start();
            ClientSessionFactory sf = this.addSessionFactory(locator.createSessionFactory());
            ClientSession session = this.createSession(sf, false, true, true);
            session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
            Assertions.assertFalse((boolean)this.backupServer.getServer().getNetworkHealthCheck().check());
            this.crash(false, true, session);
            for (i = 0; i < 1000 && !this.backupServer.isStarted(); ++i) {
                Thread.sleep(10L);
            }
            Assertions.assertTrue((boolean)this.backupServer.isStarted());
            Assertions.assertFalse((boolean)this.backupServer.isActive());
            this.primaryServer.start();
            for (i = 0; i < 1000 && NetworkIsolationTest.getReplicationEndpoint(this.backupServer.getServer()) != null && !NetworkIsolationTest.getReplicationEndpoint(this.backupServer.getServer()).isStarted(); ++i) {
                Thread.sleep(10L);
            }
            this.backupServer.getServer().getNetworkHealthCheck().clearAddresses();
            Assertions.assertTrue((boolean)NetworkIsolationTest.getReplicationEndpoint(this.backupServer.getServer()).isStarted());
        }
    }

    @Test
    public void testPrimaryIsolated() throws Exception {
        this.backupServer.stop();
        FakeServiceComponent component = new FakeServiceComponent("Component for " + this.getName());
        this.primaryServer.getServer().addExternalComponent((ActiveMQComponent)component, true);
        this.primaryServer.getServer().getConfiguration().setNetworkCheckList(badAddress).setNetworkCheckPeriod(100L).setNetworkCheckTimeout(100);
        ((ActiveMQServerImpl)this.primaryServer.getServer()).reloadNetworkHealthCheck();
        try {
            Assertions.assertEquals((long)100L, (long)this.primaryServer.getServer().getNetworkHealthCheck().getPeriod());
            this.primaryServer.getServer().getNetworkHealthCheck().setTimeUnit(TimeUnit.MILLISECONDS);
            Assertions.assertFalse((boolean)this.primaryServer.getServer().getNetworkHealthCheck().check());
            Wait.assertFalse(() -> ((TestableServer)this.primaryServer).isStarted());
            this.primaryServer.getServer().getNetworkHealthCheck().setIgnoreLoopback(true).addAddress("127.0.0.1");
            Wait.assertTrue(() -> ((TestableServer)this.primaryServer).isStarted());
            Assertions.assertTrue((boolean)component.isStarted());
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            throw e;
        }
        finally {
            this.primaryServer.getServer().stop();
            this.backupServer.getServer().stop();
        }
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected void crash(boolean failover, boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                NetworkIsolationTest.waitForRemoteBackup(session.getSessionFactory(), 5, true, this.backupServer.getServer());
            }
        } else {
            NetworkIsolationTest.waitForRemoteBackup(null, 5, true, this.backupServer.getServer());
        }
        super.crash(failover, waitFailure, sessions);
    }
}

