/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.tests.integration.cluster.failover.ReplicatedFailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.BackupSyncDelay;
import org.junit.jupiter.api.BeforeEach;

public class ReplicatedWithDelayFailoverTest
extends ReplicatedFailoverTest {
    private BackupSyncDelay syncDelay;

    @Override
    protected boolean supportsRetention() {
        return false;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.startBackupServer = false;
        super.setUp();
        this.syncDelay = new BackupSyncDelay(this.backupServer, this.primaryServer);
        this.backupServer.start();
        this.waitForServerToStart(this.backupServer.getServer());
    }

    @Override
    protected void beforeWaitForRemoteBackupSynchronization() {
        this.syncDelay.deliverUpToDateMsg();
    }

    @Override
    protected void crash(ClientSession ... sessions) throws Exception {
        this.syncDelay.deliverUpToDateMsg();
        super.crash(sessions);
    }

    @Override
    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        this.syncDelay.deliverUpToDateMsg();
        this.waitForBackup(null, 5);
        super.crash(waitFailure, sessions);
    }
}

