/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReSendMessageTest
extends JMSTestBase {
    private Queue queue;

    @Test
    public void testResendWithLargeMessage() throws Exception {
        this.conn = this.cf.createConnection();
        this.conn.start();
        Session sess = this.conn.createSession(true, 0);
        ArrayList<Message> msgs = new ArrayList<Message>();
        for (int i = 0; i < 10; ++i) {
            BytesMessage bm = sess.createBytesMessage();
            bm.setObjectProperty("JMS_AMQ_InputStream", (Object)ActiveMQTestBase.createFakeLargeStream(204800L));
            msgs.add((Message)bm);
            MapMessage mm = sess.createMapMessage();
            mm.setBoolean("boolean", true);
            mm.setByte("byte", (byte)3);
            mm.setBytes("bytes", new byte[]{3, 4, 5});
            mm.setChar("char", '\u0006');
            mm.setDouble("double", 7.0);
            mm.setFloat("float", 8.0f);
            mm.setInt("int", 9);
            mm.setLong("long", 10L);
            mm.setObject("object", (Object)new String("this is an object"));
            mm.setShort("short", (short)11);
            mm.setString("string", "this is a string");
            msgs.add((Message)mm);
            msgs.add((Message)sess.createTextMessage("hello" + i));
            msgs.add((Message)sess.createObjectMessage((Serializable)new SomeSerializable("hello" + i)));
        }
        this.internalTestResend(msgs, sess);
    }

    @Test
    public void testResendWithMapMessagesOnly() throws Exception {
        this.conn = this.cf.createConnection();
        this.conn.start();
        Session sess = this.conn.createSession(true, 0);
        ArrayList<Message> msgs = new ArrayList<Message>();
        for (int i = 0; i < 1; ++i) {
            MapMessage mm = sess.createMapMessage();
            mm.setBoolean("boolean", true);
            mm.setByte("byte", (byte)3);
            mm.setBytes("bytes", new byte[]{3, 4, 5});
            mm.setChar("char", '\u0006');
            mm.setDouble("double", 7.0);
            mm.setFloat("float", 8.0f);
            mm.setInt("int", 9);
            mm.setLong("long", 10L);
            mm.setObject("object", (Object)new String("this is an object"));
            mm.setShort("short", (short)11);
            mm.setString("string", "this is a string");
            msgs.add((Message)mm);
            MapMessage emptyMap = sess.createMapMessage();
            msgs.add((Message)emptyMap);
        }
        this.internalTestResend(msgs, sess);
    }

    public void internalTestResend(ArrayList<Message> msgs, Session sess) throws Exception {
        MessageProducer prod = sess.createProducer((Destination)this.queue);
        for (Message msg : msgs) {
            prod.send(msg);
        }
        sess.commit();
        MessageConsumer cons = sess.createConsumer((Destination)this.queue);
        for (int i = 0; i < msgs.size(); ++i) {
            Message msg = cons.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            prod.send(msg);
        }
        Assertions.assertNull((Object)cons.receiveNoWait());
        sess.commit();
        for (Message originalMessage : msgs) {
            Message copiedMessage = cons.receive(5000L);
            Assertions.assertNotNull((Object)copiedMessage);
            Assertions.assertEquals(copiedMessage.getClass(), originalMessage.getClass());
            sess.commit();
            if (copiedMessage instanceof BytesMessage) {
                BytesMessage copiedBytes = (BytesMessage)copiedMessage;
                int i = 0;
                while ((long)i < copiedBytes.getBodyLength()) {
                    Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)copiedBytes.readByte());
                    ++i;
                }
                continue;
            }
            if (copiedMessage instanceof MapMessage) {
                MapMessage copiedMap = (MapMessage)copiedMessage;
                MapMessage originalMap = (MapMessage)originalMessage;
                if (originalMap.getString("str") != null) {
                    Assertions.assertEquals((Object)originalMap.getString("str"), (Object)copiedMap.getString("str"));
                }
                if (originalMap.getObject("long") != null) {
                    Assertions.assertEquals((long)originalMap.getLong("long"), (long)copiedMap.getLong("long"));
                }
                if (originalMap.getObject("int") != null) {
                    Assertions.assertEquals((int)originalMap.getInt("int"), (int)copiedMap.getInt("int"));
                }
                if (originalMap.getObject("object") == null) continue;
                Assertions.assertEquals((Object)originalMap.getObject("object"), (Object)copiedMap.getObject("object"));
                continue;
            }
            if (copiedMessage instanceof ObjectMessage) {
                Assertions.assertNotSame((Object)((ObjectMessage)originalMessage).getObject(), (Object)((ObjectMessage)copiedMessage).getObject());
                Assertions.assertEquals((Object)((ObjectMessage)originalMessage).getObject(), (Object)((ObjectMessage)copiedMessage).getObject());
                continue;
            }
            if (!(copiedMessage instanceof TextMessage)) continue;
            Assertions.assertEquals((Object)((TextMessage)originalMessage).getText(), (Object)((TextMessage)copiedMessage).getText());
        }
    }

    @Override
    protected void createCF(List<TransportConfiguration> connectorConfigs, String ... jndiBindings) throws Exception {
        int retryInterval = 1000;
        double retryIntervalMultiplier = 1.0;
        int reconnectAttempts = -1;
        int callTimeout = 30000;
        this.jmsServer.createConnectionFactory("ManualReconnectionToSingleServerTest", false, JMSFactoryType.CF, this.registerConnectors(this.server, connectorConfigs), null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, (long)callTimeout, 30000L, true, 102400, false, -1, 0x100000, -1, -1, 65536, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, true, 5, -1, (long)retryInterval, retryIntervalMultiplier, ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL, reconnectAttempts, false, null, jndiBindings);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.queue = this.createQueue("queue1");
    }

    public static class SomeSerializable
    implements Serializable {
        private static final long serialVersionUID = -8576054940441747312L;
        final String txt;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.txt == null ? 0 : this.txt.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SomeSerializable other = (SomeSerializable)obj;
            return !(this.txt == null ? other.txt != null : !this.txt.equals(other.txt));
        }

        SomeSerializable(String txt) {
            this.txt = txt;
        }
    }
}

