/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.largemessage;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSLargeMessageTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Queue queue1;

    @Override
    protected boolean usePersistence() {
        return true;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.queue1 = this.createQueue("queue1");
    }

    @Test
    public void testSimpleLargeMessage() throws Exception {
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        MessageProducer prod = session.createProducer((Destination)this.queue1);
        BytesMessage m = session.createBytesMessage();
        m.setObjectProperty("JMS_AMQ_InputStream", (Object)ActiveMQTestBase.createFakeLargeStream(0x100000L));
        prod.send((Message)m);
        this.conn.close();
        this.conn = this.cf.createConnection();
        session = this.conn.createSession(false, 1);
        MessageConsumer cons = session.createConsumer((Destination)this.queue1);
        this.conn.start();
        BytesMessage rm = (BytesMessage)cons.receive(10000L);
        byte[] data = new byte[1024];
        for (int i = 0; i < 0x100000; i += 1024) {
            int numberOfBytes = rm.readBytes(data);
            Assertions.assertEquals((int)1024, (int)numberOfBytes);
            for (int j = 0; j < 1024; ++j) {
                Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i + j), (byte)data[j]);
            }
        }
        Assertions.assertNotNull((Object)rm);
    }

    @Test
    public void testSimpleLargeMessage2() throws Exception {
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        MessageProducer prod = session.createProducer((Destination)this.queue1);
        BytesMessage m = session.createBytesMessage();
        m.setObjectProperty("JMS_AMQ_InputStream", (Object)ActiveMQTestBase.createFakeLargeStream(10L));
        prod.send((Message)m);
        this.conn.close();
        this.conn = this.cf.createConnection();
        session = this.conn.createSession(false, 1);
        MessageConsumer cons = session.createConsumer((Destination)this.queue1);
        this.conn.start();
        BytesMessage rm = (BytesMessage)cons.receive(10000L);
        byte[] data = new byte[1024];
        int numberOfBytes = rm.readBytes(data);
        Assertions.assertEquals((int)10, (int)numberOfBytes);
        for (int j = 0; j < numberOfBytes; ++j) {
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(j), (byte)data[j]);
        }
        Assertions.assertNotNull((Object)rm);
    }

    @Test
    public void testExceptionsOnSettingNonStreaming() throws Exception {
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        TextMessage msg = session.createTextMessage();
        try {
            msg.setObjectProperty("JMS_AMQ_InputStream", (Object)ActiveMQTestBase.createFakeLargeStream(10L));
            Assertions.fail((String)"Exception was expected");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        msg.setText("hello");
        MessageProducer prod = session.createProducer((Destination)this.queue1);
        prod.send((Message)msg);
        this.conn.close();
        this.conn = this.cf.createConnection();
        session = this.conn.createSession(false, 1);
        MessageConsumer cons = session.createConsumer((Destination)this.queue1);
        this.conn.start();
        TextMessage rm = (TextMessage)cons.receive(10000L);
        try {
            rm.setObjectProperty("JMS_AMQ_OutputStream", (Object)new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    logger.debug("b = {}", (Object)b);
                }
            });
            Assertions.fail((String)"Exception was expected");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)"hello", (Object)rm.getText());
        Assertions.assertNotNull((Object)rm);
    }

    @Test
    public void testWaitOnOutputStream() throws Exception {
        int msgSize = 0x100000;
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        MessageProducer prod = session.createProducer((Destination)this.queue1);
        BytesMessage m = session.createBytesMessage();
        m.setObjectProperty("JMS_AMQ_InputStream", (Object)ActiveMQTestBase.createFakeLargeStream(msgSize));
        prod.send((Message)m);
        this.conn.close();
        this.conn = this.cf.createConnection();
        session = this.conn.createSession(false, 1);
        MessageConsumer cons = session.createConsumer((Destination)this.queue1);
        this.conn.start();
        BytesMessage rm = (BytesMessage)cons.receive(10000L);
        Assertions.assertNotNull((Object)rm);
        final AtomicLong numberOfBytes = new AtomicLong(0L);
        final AtomicInteger numberOfErrors = new AtomicInteger(0);
        OutputStream out = new OutputStream(){
            int position = 0;

            @Override
            public void write(int b) throws IOException {
                numberOfBytes.incrementAndGet();
                if (ActiveMQTestBase.getSamplebyte(this.position++) != b) {
                    logger.warn("Wrong byte at position {}", (Object)this.position);
                    numberOfErrors.incrementAndGet();
                }
            }
        };
        try {
            rm.setObjectProperty("JMS_AMQ_InputStream", (Object)ActiveMQTestBase.createFakeLargeStream(100L));
            Assertions.fail((String)"Exception expected!");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        rm.setObjectProperty("JMS_AMQ_SaveStream", (Object)out);
        Assertions.assertEquals((long)msgSize, (long)numberOfBytes.get());
        Assertions.assertEquals((int)0, (int)numberOfErrors.get());
    }

    @Test
    public void testHugeString() throws Exception {
        int msgSize = 0x100000;
        this.conn = this.cf.createConnection();
        Session session = this.conn.createSession(false, 1);
        MessageProducer prod = session.createProducer((Destination)this.queue1);
        TextMessage m = session.createTextMessage();
        StringBuffer buffer = new StringBuffer();
        while (buffer.length() < msgSize) {
            buffer.append(UUIDGenerator.getInstance().generateStringUUID());
        }
        String originalString = buffer.toString();
        m.setText(originalString);
        buffer = null;
        prod.send((Message)m);
        this.conn.close();
        this.validateNoFilesOnLargeDir(this.server.getConfiguration().getLargeMessagesDirectory(), 1);
        this.conn = this.cf.createConnection();
        session = this.conn.createSession(false, 1);
        MessageConsumer cons = session.createConsumer((Destination)this.queue1);
        this.conn.start();
        TextMessage rm = (TextMessage)cons.receive(10000L);
        Assertions.assertNotNull((Object)rm);
        String str = rm.getText();
        Assertions.assertEquals((Object)originalString, (Object)str);
        this.conn.close();
        this.validateNoFilesOnLargeDir(this.server.getConfiguration().getLargeMessagesDirectory(), 0);
    }

    class ThreadReader
    extends Thread {
        CountDownLatch latch;

        ThreadReader(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void run() {
        }
    }
}

