/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MQTTDisabledLinkStealingTest
extends MQTTTestSupport {
    @Test
    @Timeout(value=60L)
    public void testDisabledLinkStealing() throws Exception {
        String clientId = RandomUtil.randomString();
        MQTT mqtt = this.createMQTTConnection(clientId, false);
        mqtt.setKeepAlive((short)2);
        BlockingConnection connection1 = mqtt.blockingConnection();
        connection1.connect();
        BlockingConnection connection2 = mqtt.blockingConnection();
        try {
            connection2.connect();
            Assertions.fail((String)"Should have thrown an exception on connect due to disabled link stealing");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)Wait.waitFor(() -> connection1.isConnected(), (long)3000L, (long)200L), (String)"Client no longer connected!");
        connection1.disconnect();
    }

    @Override
    protected void addMQTTConnector() throws Exception {
        this.server.getConfiguration().addAcceptorConfiguration("MQTT", "tcp://localhost:" + this.port + "?protocols=MQTT;anycastPrefix=anycast:;multicastPrefix=multicast:;allowLinkStealing=false");
    }
}

