/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import io.netty.handler.codec.mqtt.MqttMessageType;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptionsBuilder;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.MqttSubscription;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttPublish;
import org.eclipse.paho.mqttv5.common.packet.UserProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishTests
extends MQTT5TestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    @Timeout(value=60L)
    public void testDupFlag() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        AtomicBoolean intercepted = new AtomicBoolean(false);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (!intercepted.get() && packet.fixedHeader().messageType() == MqttMessageType.PUBACK) {
                intercepted.set(true);
                return false;
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient producer = this.createPahoClient("producer");
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(300L)).build();
        consumer.connect(options);
        consumer.subscribe(TOPIC, 1);
        consumer.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        producer.connect();
        producer.publish(TOPIC, "hello".getBytes(), 1, false);
        producer.disconnect();
        producer.close();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch, true));
        consumer.connect(options);
        PublishTests.waitForLatch(latch);
        consumer.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        CountDownLatch latch2 = new CountDownLatch(1);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch2, false));
        consumer.connect(options);
        PublishTests.waitForLatch(latch2);
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testDupFlagQoSZero() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertFalse((boolean)message.isDuplicate());
                latch.countDown();
            }
        });
        consumer.connect();
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, new byte[0], 0, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testDupFlagNotPropagated() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient producer = this.createPahoClient("producer");
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertFalse((boolean)message.isDuplicate());
                latch.countDown();
            }
        });
        consumer.connect();
        consumer.subscribe(TOPIC, 2);
        producer.connect();
        MqttMessage m = new MqttMessage();
        m.setDuplicate(true);
        m.setPayload("hello".getBytes());
        m.setQos(2);
        m.setRetained(false);
        producer.publish(TOPIC, m);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRetainFlag() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "retain1".getBytes(), 2, true);
        producer.publish(TOPIC, "retain2".getBytes(), 2, true);
        producer.disconnect();
        producer.close();
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                ActiveMQTestBase.assertEqualsByteArrays("retain2".getBytes(StandardCharsets.UTF_8), message.getPayload());
                latch.countDown();
            }
        });
        consumer.connect();
        consumer.subscribe(TOPIC, 2);
        Assertions.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRetainFlagWithEmptyMessage() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        Assertions.assertNull((Object)this.getRetainedMessageQueue(TOPIC));
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "retain1".getBytes(), 2, true);
        Wait.assertTrue(() -> this.getRetainedMessageQueue(TOPIC).getMessageCount() == 1L, (long)2000L, (long)100L);
        producer.publish(TOPIC, new byte[0], 2, true);
        producer.disconnect();
        producer.close();
        Wait.assertTrue(() -> this.getRetainedMessageQueue(TOPIC).getMessageCount() == 0L, (long)2000L, (long)100L);
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                latch.countDown();
            }
        });
        consumer.connect();
        consumer.subscribe(TOPIC, 2);
        Assertions.assertFalse((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRetainFlagFalse() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        final String RETAINED_PAYLOAD = RandomUtil.randomString();
        String UNRETAINED_PAYLOAD = RandomUtil.randomString();
        Assertions.assertNull((Object)this.getRetainedMessageQueue(TOPIC));
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, RETAINED_PAYLOAD.getBytes(), 2, true);
        Wait.assertTrue(() -> this.getRetainedMessageQueue(TOPIC).getMessageCount() == 1L, (long)1000L, (long)100L);
        producer.publish(TOPIC, UNRETAINED_PAYLOAD.getBytes(), 2, false);
        producer.disconnect();
        producer.close();
        Wait.assertFalse(() -> this.getRetainedMessageQueue(TOPIC).getMessageCount() > 1L, (long)1000L, (long)100L);
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                ActiveMQTestBase.assertEqualsByteArrays(RETAINED_PAYLOAD.getBytes(StandardCharsets.UTF_8), message.getPayload());
                latch.countDown();
            }
        });
        consumer.connect();
        consumer.subscribe(TOPIC, 2);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRetainHandlingZeroWithOneSubscription() throws Exception {
        this.internalTestRetainHandlingZero(false, 1);
    }

    @Test
    @Timeout(value=60L)
    public void testRetainHandlingZeroWithMultipleSubscriptions() throws Exception {
        this.internalTestRetainHandlingZero(false, 25);
    }

    @Test
    @Timeout(value=60L)
    public void testRetainHandlingZeroWithTopicFilterSubscription() throws Exception {
        this.internalTestRetainHandlingZero(true, 25);
    }

    public void internalTestRetainHandlingZero(boolean filter, int subscriptionCount) throws Exception {
        int i;
        final int SUBSCRIPTION_COUNT = subscriptionCount;
        String CONSUMER_ID = RandomUtil.randomString();
        String PREFIX = "myTopic/";
        String[] topicNames = new String[SUBSCRIPTION_COUNT];
        for (int i2 = 0; i2 < SUBSCRIPTION_COUNT; ++i2) {
            topicNames[i2] = "myTopic/" + this.getTopicName() + i2;
        }
        final String[] retainedPayloads = new String[SUBSCRIPTION_COUNT];
        for (i = 0; i < SUBSCRIPTION_COUNT; ++i) {
            retainedPayloads[i] = RandomUtil.randomString();
        }
        for (i = 0; i < SUBSCRIPTION_COUNT; ++i) {
            Assertions.assertNull((Object)this.getRetainedMessageQueue(topicNames[i]));
        }
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i3 = 0; i3 < SUBSCRIPTION_COUNT; ++i3) {
            String topicName = topicNames[i3];
            producer.publish(topicName, retainedPayloads[i3].getBytes(), 2, true);
            Wait.assertTrue(() -> this.getRetainedMessageQueue(topicName).getMessageCount() == 1L, (long)2000L, (long)100L);
        }
        producer.disconnect();
        producer.close();
        final CountDownLatch latch = new CountDownLatch(SUBSCRIPTION_COUNT);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                boolean payloadMatched = false;
                for (int i = 0; i < SUBSCRIPTION_COUNT; ++i) {
                    if (!new String(message.getPayload()).equals(retainedPayloads[i])) continue;
                    payloadMatched = true;
                    break;
                }
                Assertions.assertTrue((boolean)payloadMatched);
                Assertions.assertTrue((boolean)message.isRetained());
                latch.countDown();
            }
        });
        consumer.connect();
        if (filter) {
            MqttSubscription sub = new MqttSubscription("myTopic/#", 2);
            sub.setRetainHandling(0);
            consumer.subscribe(new MqttSubscription[]{sub});
        } else {
            MqttSubscription[] subscriptions = new MqttSubscription[SUBSCRIPTION_COUNT];
            for (int i4 = 0; i4 < SUBSCRIPTION_COUNT; ++i4) {
                MqttSubscription subscription = new MqttSubscription(topicNames[i4], 2);
                subscription.setRetainHandling(0);
                subscriptions[i4] = subscription;
            }
            consumer.subscribe(subscriptions);
        }
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRetainHandlingOne() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        Assertions.assertNull((Object)this.getRetainedMessageQueue(TOPIC));
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "retained".getBytes(), 2, true);
        Wait.assertTrue(() -> this.getRetainedMessageQueue(TOPIC).getMessageCount() == 1L, (long)2000L, (long)100L);
        producer.disconnect();
        producer.close();
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(300L)).build();
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.connect(options);
        final CountDownLatch latch = new CountDownLatch(1);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                ActiveMQTestBase.assertEqualsByteArrays("retained".getBytes(StandardCharsets.UTF_8), message.getPayload());
                Assertions.assertTrue((boolean)message.isRetained());
                latch.countDown();
            }
        });
        MqttSubscription subscription = new MqttSubscription(TOPIC, 2);
        subscription.setRetainHandling(1);
        consumer.subscribe(new MqttSubscription[]{subscription});
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        Wait.assertTrue(() -> this.getSubscriptionQueue(TOPIC, CONSUMER_ID).getMessageCount() == 0L, (long)2000L, (long)100L);
        consumer.disconnect();
        final CountDownLatch latch2 = new CountDownLatch(1);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                latch2.countDown();
            }
        });
        consumer.connect(options);
        Assertions.assertFalse((boolean)latch2.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRetainHandlingTwo() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        Assertions.assertNull((Object)this.getRetainedMessageQueue(TOPIC));
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "retained".getBytes(), 2, true);
        Wait.assertTrue(() -> this.getRetainedMessageQueue(TOPIC).getMessageCount() == 1L, (long)2000L, (long)100L);
        producer.disconnect();
        producer.close();
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                latch.countDown();
            }
        });
        consumer.connect();
        MqttSubscription subscription = new MqttSubscription(TOPIC, 2);
        subscription.setRetainHandling(2);
        consumer.subscribe(new MqttSubscription[]{subscription});
        Assertions.assertFalse((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRetainAsPublishedZeroOnEstablishedSubscription() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                ActiveMQTestBase.assertEqualsByteArrays("retained".getBytes(StandardCharsets.UTF_8), message.getPayload());
                Assertions.assertFalse((boolean)message.isRetained());
                latch.countDown();
            }
        });
        consumer.connect();
        MqttSubscription subscription = new MqttSubscription(TOPIC, 2);
        subscription.setRetainAsPublished(false);
        consumer.subscribe(new MqttSubscription[]{subscription});
        Assertions.assertNull((Object)this.getRetainedMessageQueue(TOPIC));
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "retained".getBytes(), 2, true);
        Wait.assertTrue(() -> this.getRetainedMessageQueue(TOPIC).getMessageCount() == 1L, (long)2000L, (long)100L);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testRetainAsPublishedOneOnEstablishedSubscription() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        final CountDownLatch latchOne = new CountDownLatch(1);
        final CountDownLatch latchTwo = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        final AtomicBoolean first = new AtomicBoolean(true);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                if (first.getAndSet(false)) {
                    ActiveMQTestBase.assertEqualsByteArrays("retained".getBytes(StandardCharsets.UTF_8), message.getPayload());
                    Assertions.assertTrue((boolean)message.isRetained());
                    latchOne.countDown();
                } else {
                    ActiveMQTestBase.assertEqualsByteArrays("unretained".getBytes(StandardCharsets.UTF_8), message.getPayload());
                    Assertions.assertFalse((boolean)message.isRetained());
                    latchTwo.countDown();
                }
            }
        });
        consumer.connect();
        MqttSubscription subscription = new MqttSubscription(TOPIC, 2);
        subscription.setRetainAsPublished(true);
        consumer.subscribe(new MqttSubscription[]{subscription});
        Assertions.assertNull((Object)this.getRetainedMessageQueue(TOPIC));
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "retained".getBytes(), 2, true);
        Wait.assertTrue(() -> this.getRetainedMessageQueue(TOPIC).getMessageCount() == 1L, (long)2000L, (long)100L);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latchOne.await(2L, TimeUnit.SECONDS));
        producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "unretained".getBytes(), 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latchTwo.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testTopicFilter() throws Exception {
        String PREFIX = "myTopic/";
        String TOPIC = "myTopic/" + RandomUtil.randomString();
        String TOPIC_FILTER = "myTopic/#";
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(300L)).build();
        consumer.connect(options);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                System.out.println(topic + ", myTopic/");
                Assertions.assertTrue((boolean)topic.startsWith("myTopic/"));
                latch.countDown();
            }
        });
        consumer.subscribe("myTopic/#", 1);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "hello".getBytes(), 1, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testX() throws Exception {
        String PREFIX = "";
        String TOPIC = RandomUtil.randomString();
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(300L)).build();
        consumer.connect(options);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                System.out.println(topic + ", ");
                Assertions.assertTrue((boolean)topic.startsWith(""));
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 1);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "hello".getBytes(), 1, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPayloadFormatIndicatorTrue() throws Exception {
        this.internalTestPayloadFormatIndicator(true);
    }

    @Test
    @Timeout(value=60L)
    public void testPayloadFormatIndicatorFalse() throws Exception {
        this.internalTestPayloadFormatIndicator(false);
    }

    private void internalTestPayloadFormatIndicator(final boolean payloadFormatIndicator) throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(300L)).build();
        consumer.connect(options);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                if (payloadFormatIndicator) {
                    Assertions.assertTrue((boolean)message.getProperties().getPayloadFormat());
                } else {
                    Assertions.assertFalse((boolean)message.getProperties().getPayloadFormat());
                }
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttMessage m = new MqttMessage();
        MqttProperties props = new MqttProperties();
        props.setPayloadFormat(payloadFormatIndicator);
        m.setProperties(props);
        m.setQos(2);
        m.setPayload("foo".getBytes(StandardCharsets.UTF_8));
        producer.publish(TOPIC, m);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testMessageExpiryIntervalElapsed() throws Exception {
        this.server.createQueue(QueueConfiguration.of((SimpleString)EXPIRY_ADDRESS).setRoutingType(RoutingType.ANYCAST));
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(300L)).build();
        consumer.connect(options);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 2);
        consumer.disconnect();
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttMessage m = new MqttMessage();
        MqttProperties props = new MqttProperties();
        props.setMessageExpiryInterval(Long.valueOf(2L));
        m.setProperties(props);
        m.setQos(2);
        m.setPayload("foo".getBytes(StandardCharsets.UTF_8));
        producer.publish(TOPIC, m);
        producer.disconnect();
        producer.close();
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, CONSUMER_ID).getMessageCount(), (long)1000L, (long)100L);
        Wait.assertEquals((Long)1L, () -> this.server.locateQueue("EXPIRY").getMessageCount(), (long)3000L, (long)100L);
        Wait.assertEquals((Long)0L, () -> this.getSubscriptionQueue(TOPIC, CONSUMER_ID).getMessageCount(), (long)1000L, (long)100L);
        consumer.connect(options);
        Assertions.assertFalse((boolean)latch.await(1L, TimeUnit.SECONDS));
        consumer.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testMessageExpiryIntervalReturnValue() throws Exception {
        this.server.createQueue(QueueConfiguration.of((SimpleString)EXPIRY_ADDRESS).setRoutingType(RoutingType.ANYCAST));
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        long EXPIRY_INTERVAL = 5L;
        long SLEEP = 1000L;
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(300L)).build();
        consumer.connect(options);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                long messageExpiryInterval = message.getProperties().getMessageExpiryInterval();
                System.out.println(messageExpiryInterval);
                Assertions.assertTrue((messageExpiryInterval <= 6L ? (byte)1 : 0) != 0);
                Assertions.assertTrue((messageExpiryInterval > 0L ? (byte)1 : 0) != 0);
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 2);
        consumer.disconnect();
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttMessage m = new MqttMessage();
        MqttProperties props = new MqttProperties();
        props.setMessageExpiryInterval(Long.valueOf(5L));
        m.setProperties(props);
        m.setQos(2);
        m.setPayload("foo".getBytes(StandardCharsets.UTF_8));
        producer.publish(TOPIC, m);
        producer.disconnect();
        producer.close();
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, CONSUMER_ID).getMessageCount(), (long)500L, (long)100L);
        Thread.sleep(1000L);
        consumer.connect(options);
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        consumer.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testClientTopicAliasMaxFromServer() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        int MESSAGE_COUNT = 25;
        int ALIAS_MAX = 5;
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().topicAliasMaximum(Integer.valueOf(5)).build();
        consumer.connect(options);
        final CountDownLatch latch = new CountDownLatch(25);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Integer topicAlias = message.getProperties().getTopicAlias();
                if (topicAlias != null) {
                    Assertions.assertTrue((topicAlias <= 5 ? (byte)1 : 0) != 0);
                }
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC + "/#", 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i = 0; i < 25; ++i) {
            producer.publish(TOPIC + "/" + i, ("foo" + i).getBytes(StandardCharsets.UTF_8), 2, false);
        }
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
    }

    @Disabled
    @Test
    @Timeout(value=60L)
    public void testTopicAliasesNotCarriedForward() throws Exception {
        String TOPIC = "myTopicName";
        MqttProperties properties = new MqttProperties();
        properties.setTopicAlias(Integer.valueOf(1));
        MqttClient producer = this.createPahoClient("producer");
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().topicAliasMaximum(Integer.valueOf(2)).sessionExpiryInterval(Long.valueOf(999L)).cleanStart(false).build();
        producer.connect(options);
        MqttMessage m = new MqttMessage();
        m.setProperties(properties);
        producer.publish("myTopicName", m);
        m = new MqttMessage();
        m.setProperties(properties);
        producer.publish("", m);
        producer.disconnect();
        producer.connect(options);
        m = new MqttMessage();
        m.setProperties(properties);
        try {
            producer.publish("", m);
            Assertions.fail((String)"Publishing should fail here due to an invalid topic alias");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)producer.isConnected());
        producer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testServerTopicAliasMax() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        int MESSAGE_COUNT = 25;
        int ALIAS_MAX = 5;
        this.setAcceptorProperty("topicAliasMaximum=5");
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().topicAliasMaximum(Integer.valueOf(5)).build();
        consumer.connect(options);
        final CountDownLatch latch = new CountDownLatch(25);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Integer topicAlias = message.getProperties().getTopicAlias();
                if (topicAlias != null) {
                    Assertions.assertTrue((topicAlias <= 5 ? (byte)1 : 0) != 0);
                }
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC + "/#", 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i = 0; i < 25; ++i) {
            producer.publish(TOPIC + "/" + i, ("foo" + i).getBytes(StandardCharsets.UTF_8), 2, false);
        }
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testModifiedTopicAlias() throws Exception {
        String TOPIC_1 = this.getTopicName() + "1";
        String TOPIC_2 = this.getTopicName() + "2";
        MqttClient consumer1 = this.createPahoClient("consumer1");
        final CountDownLatch latch1 = new CountDownLatch(1);
        consumer1.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                String payload = new String(message.getPayload());
                if (payload.equals("first")) {
                    latch1.countDown();
                }
            }
        });
        consumer1.connect();
        consumer1.subscribe(TOPIC_1, 1);
        MqttClient consumer2 = this.createPahoClient("consumer2");
        final CountDownLatch latch2 = new CountDownLatch(1);
        consumer2.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                String payload = new String(message.getPayload());
                if (payload.equals("second")) {
                    latch2.countDown();
                }
            }
        });
        consumer2.connect();
        consumer2.subscribe(TOPIC_2, 1);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttProperties properties = new MqttProperties();
        properties.setTopicAlias(Integer.valueOf(1));
        MqttMessage m = new MqttMessage();
        m.setProperties(properties);
        m.setQos(1);
        m.setRetained(false);
        m.setPayload("first".getBytes(StandardCharsets.UTF_8));
        producer.publish(TOPIC_1, m);
        m.setPayload("second".getBytes(StandardCharsets.UTF_8));
        producer.publish(TOPIC_2, m);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch1.await(2L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch2.await(2L, TimeUnit.SECONDS));
        consumer1.disconnect();
        consumer1.close();
        consumer2.disconnect();
        consumer2.close();
    }

    @Test
    @Timeout(value=60L)
    public void testResponseTopicUnaltered() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        String RESPONSE_TOPIC = "myResponseTopic/a";
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertEquals((Object)"myResponseTopic/a", (Object)message.getProperties().getResponseTopic());
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttMessage m = new MqttMessage();
        m.setQos(2);
        MqttProperties properties = new MqttProperties();
        properties.setResponseTopic("myResponseTopic/a");
        m.setProperties(properties);
        producer.publish(TOPIC, m);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationDataUnaltered() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        final byte[] CORRELATION_DATA = "myCorrelationData".getBytes(StandardCharsets.UTF_8);
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                ActiveMQTestBase.assertEqualsByteArrays(CORRELATION_DATA, message.getProperties().getCorrelationData());
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttMessage m = new MqttMessage();
        m.setQos(2);
        MqttProperties properties = new MqttProperties();
        properties.setCorrelationData(CORRELATION_DATA);
        m.setProperties(properties);
        producer.publish(TOPIC, m);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testUserProperties() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        int USER_PROPERTY_COUNT = 10;
        final ArrayList<UserProperty> userProperties = new ArrayList<UserProperty>();
        for (int i = 0; i < 10; ++i) {
            userProperties.add(new UserProperty(RandomUtil.randomString(), RandomUtil.randomString()));
        }
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                List receivedUserProperties = message.getProperties().getUserProperties();
                for (int i = 0; i < 10; ++i) {
                    Assertions.assertEquals((Object)((UserProperty)userProperties.get(i)).getKey(), (Object)((UserProperty)receivedUserProperties.get(i)).getKey());
                    Assertions.assertEquals((Object)((UserProperty)userProperties.get(i)).getValue(), (Object)((UserProperty)receivedUserProperties.get(i)).getValue());
                }
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttMessage m = new MqttMessage();
        m.setQos(2);
        MqttProperties properties = new MqttProperties();
        properties.setUserProperties(userProperties);
        m.setProperties(properties);
        producer.publish(TOPIC, m);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testContentTypeUnaltered() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        String CONTENT_TYPE = "myContentType";
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertEquals((Object)"myContentType", (Object)message.getProperties().getContentType());
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        MqttMessage m = new MqttMessage();
        m.setQos(2);
        MqttProperties properties = new MqttProperties();
        properties.setContentType("myContentType");
        m.setProperties(properties);
        producer.publish(TOPIC, m);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testQoS2() throws Exception {
        this.internalTestQoS(2);
    }

    @Test
    @Timeout(value=60L)
    public void testQoS1() throws Exception {
        this.internalTestQoS(1);
    }

    @Test
    @Timeout(value=60L)
    public void testQoS0() throws Exception {
        this.internalTestQoS(0);
    }

    private void internalTestQoS(int qos) throws Exception {
        String TOPIC = this.getTopicName();
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        final CountDownLatch latch = new CountDownLatch(1);
        producer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void deliveryComplete(IMqttToken token) {
                int qos = ((MqttPublish)token.getRequestMessage()).getQoS();
                if (qos == 0) {
                    Assertions.assertNull((Object)token.getResponse());
                } else if (qos == 1) {
                    Assertions.assertEquals((byte)4, (byte)token.getResponse().getType());
                } else if (qos == 2) {
                    Assertions.assertEquals((byte)7, (byte)token.getResponse().getType());
                } else {
                    Assertions.fail((String)"unrecognized qos");
                }
                latch.countDown();
            }
        });
        producer.publish(TOPIC, new byte[0], qos, false);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        producer.disconnect();
        producer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testOverlappingSubscriptionsWithDifferentQoSMaximums() throws Exception {
        String TOPIC = "foo/a/b/c";
        CountDownLatch consumerLatch = new CountDownLatch(9);
        MqttClient consumer2 = this.createPahoClient(RandomUtil.randomString());
        consumer2.connect();
        consumer2.setCallback((MqttCallback)new TestCallback(consumerLatch, 2));
        consumer2.subscribe("foo/a/b/#", 2);
        MqttClient consumer1 = this.createPahoClient(RandomUtil.randomString());
        consumer1.connect();
        consumer1.setCallback((MqttCallback)new TestCallback(consumerLatch, 1));
        consumer1.subscribe("foo/a/#", 1);
        MqttClient consumer0 = this.createPahoClient(RandomUtil.randomString());
        consumer0.connect();
        consumer0.setCallback((MqttCallback)new TestCallback(consumerLatch, 0));
        consumer0.subscribe("foo/#", 0);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i = 0; i < 3; ++i) {
            producer.publish("foo/a/b/c", Integer.toString(i).getBytes(StandardCharsets.UTF_8), i, false);
        }
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)consumerLatch.await(2L, TimeUnit.SECONDS));
        consumer2.disconnect();
        consumer2.close();
        consumer1.disconnect();
        consumer1.close();
        consumer0.disconnect();
        consumer0.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSubscriptionIdentifierMultiLevel() throws Exception {
        final CountDownLatch consumerLatch = new CountDownLatch(6);
        MqttAsyncClient consumer = this.createAsyncPahoClient(RandomUtil.randomString());
        consumer.connect().waitForCompletion();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                try {
                    List subscriptionIdentifers = message.getProperties() != null ? message.getProperties().getSubscriptionIdentifiers() : null;
                    System.out.println("subscriptionIdentifers: " + subscriptionIdentifers + "; message: " + message);
                    if (Arrays.equals(message.getPayload(), "foo/a".getBytes(StandardCharsets.UTF_8))) {
                        Assertions.assertTrue((boolean)subscriptionIdentifers.contains(3));
                        Assertions.assertEquals((int)1, (int)subscriptionIdentifers.size());
                    } else if (Arrays.equals(message.getPayload(), "foo/a/b".getBytes(StandardCharsets.UTF_8))) {
                        Assertions.assertTrue((boolean)subscriptionIdentifers.contains(2));
                        Assertions.assertTrue((boolean)subscriptionIdentifers.contains(3));
                        Assertions.assertEquals((int)2, (int)subscriptionIdentifers.size());
                    } else if (Arrays.equals(message.getPayload(), "foo/a/b/c".getBytes(StandardCharsets.UTF_8))) {
                        Assertions.assertTrue((boolean)subscriptionIdentifers.contains(1));
                        Assertions.assertTrue((boolean)subscriptionIdentifers.contains(2));
                        Assertions.assertTrue((boolean)subscriptionIdentifers.contains(3));
                        Assertions.assertEquals((int)3, (int)subscriptionIdentifers.size());
                    } else {
                        Assertions.fail((String)"invalid subscription identifer");
                    }
                    consumerLatch.countDown();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        MqttProperties subscription1Properties = new MqttProperties();
        subscription1Properties.setSubscriptionIdentifier(Integer.valueOf(1));
        consumer.subscribe(new MqttSubscription[]{new MqttSubscription("foo/a/b/#", 2)}, null, null, subscription1Properties).waitForCompletion();
        MqttProperties subscription2Properties = new MqttProperties();
        subscription2Properties.setSubscriptionIdentifier(Integer.valueOf(2));
        consumer.subscribe(new MqttSubscription[]{new MqttSubscription("foo/a/#", 2)}, null, null, subscription2Properties).waitForCompletion();
        MqttProperties subscription3Properties = new MqttProperties();
        subscription3Properties.setSubscriptionIdentifier(Integer.valueOf(3));
        consumer.subscribe(new MqttSubscription[]{new MqttSubscription("foo/#", 2)}, null, null, subscription3Properties).waitForCompletion();
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish("foo/a", "foo/a".getBytes(StandardCharsets.UTF_8), 2, false);
        producer.publish("foo/a/b", "foo/a/b".getBytes(StandardCharsets.UTF_8), 2, false);
        producer.publish("foo/a/b/c", "foo/a/b/c".getBytes(StandardCharsets.UTF_8), 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)consumerLatch.await(1L, TimeUnit.SECONDS));
        consumer.disconnect().waitForCompletion();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSubscriptionIdentifierSingleLevel() throws Exception {
        final CountDownLatch consumerLatch = new CountDownLatch(3);
        MqttAsyncClient consumer = this.createAsyncPahoClient(RandomUtil.randomString());
        consumer.connect().waitForCompletion();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                try {
                    List subscriptionIdentifers = message.getProperties() != null ? message.getProperties().getSubscriptionIdentifiers() : null;
                    System.out.println("subscriptionIdentifers: " + subscriptionIdentifers + "; message: " + message);
                    if (Arrays.equals(message.getPayload(), "foo/a".getBytes(StandardCharsets.UTF_8))) {
                        Assertions.assertTrue((boolean)subscriptionIdentifers.contains(3));
                        Assertions.assertEquals((int)1, (int)subscriptionIdentifers.size());
                    } else if (Arrays.equals(message.getPayload(), "foo/a/b".getBytes(StandardCharsets.UTF_8))) {
                        Assertions.assertTrue((boolean)subscriptionIdentifers.contains(2));
                        Assertions.assertEquals((int)1, (int)subscriptionIdentifers.size());
                    } else if (Arrays.equals(message.getPayload(), "foo/a/b/c".getBytes(StandardCharsets.UTF_8))) {
                        Assertions.assertTrue((boolean)subscriptionIdentifers.contains(1));
                        Assertions.assertEquals((int)1, (int)subscriptionIdentifers.size());
                    } else {
                        Assertions.fail((String)"invalid subscription identifer");
                    }
                    consumerLatch.countDown();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        MqttProperties subscription1Properties = new MqttProperties();
        subscription1Properties.setSubscriptionIdentifier(Integer.valueOf(1));
        consumer.subscribe(new MqttSubscription[]{new MqttSubscription("foo/a/b/+", 2)}, null, null, subscription1Properties).waitForCompletion();
        MqttProperties subscription2Properties = new MqttProperties();
        subscription2Properties.setSubscriptionIdentifier(Integer.valueOf(2));
        consumer.subscribe(new MqttSubscription[]{new MqttSubscription("foo/a/+", 2)}, null, null, subscription2Properties).waitForCompletion();
        MqttProperties subscription3Properties = new MqttProperties();
        subscription3Properties.setSubscriptionIdentifier(Integer.valueOf(3));
        consumer.subscribe(new MqttSubscription[]{new MqttSubscription("foo/+", 2)}, null, null, subscription3Properties).waitForCompletion();
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish("foo/a", "foo/a".getBytes(StandardCharsets.UTF_8), 2, false);
        producer.publish("foo/a/b", "foo/a/b".getBytes(StandardCharsets.UTF_8), 2, false);
        producer.publish("foo/a/b/c", "foo/a/b/c".getBytes(StandardCharsets.UTF_8), 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)consumerLatch.await(1L, TimeUnit.SECONDS));
        consumer.disconnect().waitForCompletion();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveMaximum() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        AtomicBoolean failed = new AtomicBoolean(false);
        int MESSAGE_COUNT = 50;
        int RECEIVE_MAXIMUM = 10;
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBACK || packet.fixedHeader().messageType() == MqttMessageType.PUBREC) {
                count.decrementAndGet();
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH && count.incrementAndGet() > 10) {
                failed.set(true);
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        String TOPIC = this.getTopicName();
        final CountDownLatch latch = new CountDownLatch(50);
        String CONSUMER_ID = "consumer";
        MqttAsyncClient consumer = this.createAsyncPahoClient("consumer");
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setReceiveMaximum(Integer.valueOf(10));
        consumer.connect(options).waitForCompletion();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Thread.sleep(250L);
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 2).waitForCompletion();
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i = 0; i < 50; ++i) {
            producer.publish(TOPIC, "foo".getBytes(StandardCharsets.UTF_8), RandomUtil.randomPositiveInt() % 2 + 1, false);
        }
        Wait.assertEquals((Long)50L, () -> this.getSubscriptionQueue(TOPIC, "consumer").getMessagesAdded(), (long)2000L, (long)100L);
        producer.disconnect();
        producer.close();
        Wait.assertEquals((Long)0L, () -> this.getSubscriptionQueue(TOPIC, "consumer").getMessageCount(), (long)15000L, (long)100L);
        Assertions.assertTrue((boolean)latch.await(15L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)failed.get());
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveMaximumQoS0() throws Exception {
        AtomicInteger count = new AtomicInteger(0);
        AtomicBoolean succeeded = new AtomicBoolean(false);
        int MESSAGE_COUNT = 50;
        int RECEIVE_MAXIMUM = 10;
        String TOPIC = this.getTopicName();
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBACK || packet.fixedHeader().messageType() == MqttMessageType.PUBREC) {
                count.decrementAndGet();
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH && count.incrementAndGet() > 10) {
                succeeded.set(true);
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        final CountDownLatch latch = new CountDownLatch(50);
        String CONSUMER_ID = "consumer";
        MqttAsyncClient consumer = this.createAsyncPahoClient("consumer");
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setReceiveMaximum(Integer.valueOf(10));
        consumer.connect(options).waitForCompletion();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Thread.sleep(100L);
                latch.countDown();
            }
        });
        consumer.subscribe(TOPIC, 0).waitForCompletion();
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i = 0; i < 50; ++i) {
            producer.publish(TOPIC, ("foo" + i).getBytes(StandardCharsets.UTF_8), 0, false);
        }
        Wait.assertEquals((Long)50L, () -> this.getSubscriptionQueue(TOPIC, "consumer").getMessagesAdded(), (long)2000L, (long)100L);
        producer.disconnect();
        producer.close();
        Wait.assertEquals((Long)0L, () -> this.getSubscriptionQueue(TOPIC, "consumer").getMessageCount(), (long)8000L, (long)100L);
        Assertions.assertTrue((boolean)latch.await(8L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)succeeded.get());
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPacketDelayReceiveMaximum() throws Exception {
        AtomicBoolean succeeded = new AtomicBoolean(false);
        int MESSAGE_COUNT = 2;
        boolean RECEIVE_MAXIMUM = true;
        String TOPIC = this.getTopicName();
        String CONSUMER_ID = "consumer";
        final AtomicBoolean messageArrived = new AtomicBoolean(false);
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (messageArrived.get() && packet.fixedHeader().messageType() == MqttMessageType.PINGRESP) {
                succeeded.set(true);
            }
            return true;
        };
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient("consumer");
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setReceiveMaximum(Integer.valueOf(1));
        options.setKeepAliveInterval(2);
        consumer.connect(options);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                messageArrived.set(true);
                latch.await();
            }
        });
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i = 0; i < 2; ++i) {
            producer.publish(TOPIC, "foo".getBytes(StandardCharsets.UTF_8), 2, false);
        }
        Wait.assertEquals((Long)2L, () -> this.getSubscriptionQueue(TOPIC, "consumer").getMessagesAdded(), (long)2000L, (long)100L);
        producer.disconnect();
        producer.close();
        Wait.assertTrue(() -> succeeded.get(), (long)40000L, (long)100L);
        latch.countDown();
        consumer.disconnect();
        consumer.close();
    }

    protected class TestCallback
    implements MQTT5TestSupport.DefaultMqttCallback {
        private CountDownLatch latch;
        private int qosOfSubscription;

        public TestCallback(CountDownLatch latch, int qosOfSubscription) {
            this.latch = latch;
            this.qosOfSubscription = qosOfSubscription;
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) throws Exception {
            int sentAs = Integer.parseInt(new String(message.getPayload(), StandardCharsets.UTF_8));
            logger.info("QoS of publish: {}; QoS of subscription: {}; QoS of receive: {}", new Object[]{sentAs, this.qosOfSubscription, message.getQos()});
            if (sentAs == 0) {
                Assertions.assertTrue((message.getQos() == 0 ? (byte)1 : 0) != 0);
            } else if (sentAs == 1) {
                Assertions.assertTrue((message.getQos() == (this.qosOfSubscription == 0 ? 0 : 1) ? (byte)1 : 0) != 0);
            } else if (sentAs == 2) {
                Assertions.assertTrue((message.getQos() == this.qosOfSubscription ? (byte)1 : 0) != 0);
            } else {
                Assertions.fail((String)"invalid qos");
            }
            this.latch.countDown();
        }
    }
}

