/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Date;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PagingSizeWildcardTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWildcardPageSize() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 200, 400L, -1, -1, null);
        server.start();
        ActiveMQJMSConnectionFactory cf = (ActiveMQJMSConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        try {
            Connection conn = cf.createConnection();
            conn.start();
            Session sessA = conn.createSession(true, 0);
            Topic subA = sessA.createTopic("A.a");
            MessageConsumer consumerA = sessA.createConsumer((Destination)subA);
            Session sessW = conn.createSession(true, 0);
            Topic subW = sessA.createTopic("A.#");
            MessageConsumer consumerW = sessW.createConsumer((Destination)subW);
            int numMessages = 5;
            this.publish(cf, 5);
            for (int i = 0; i < 5; ++i) {
                Assertions.assertNotNull((Object)consumerA.receive(1000L), (String)(" on " + i));
                Assertions.assertNotNull((Object)consumerW.receive(1000L), (String)(" on " + i));
            }
            sessW.commit();
            sessA.commit();
            for (SimpleString psName : server.getPagingManager().getStoreNames()) {
                Assertions.assertTrue((server.getPagingManager().getPageStore(psName).getAddressSize() >= 0L ? (byte)1 : 0) != 0, (String)("non negative size: " + psName));
            }
            conn.close();
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDurableSubReveresOrderAckPageSize() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 200, 400L, -1, -1, null);
        server.start();
        ActiveMQJMSConnectionFactory cf = (ActiveMQJMSConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        try {
            Connection conn = cf.createConnection();
            conn.setClientID("IDD");
            conn.start();
            Session sessA = conn.createSession(true, 0);
            Topic topic = sessA.createTopic("A.a");
            MessageConsumer consumerA = sessA.createDurableConsumer(topic, "1");
            Session sessW = conn.createSession(true, 0);
            MessageConsumer consumerW = sessW.createDurableConsumer(topic, "2");
            int numMessages = 5;
            this.publish(cf, 5);
            for (int i = 0; i < 5; ++i) {
                Assertions.assertNotNull((Object)consumerA.receive(1000L), (String)(" on " + i));
                Assertions.assertNotNull((Object)consumerW.receive(1000L), (String)(" on " + i));
            }
            sessW.commit();
            sessA.commit();
            for (SimpleString psName : server.getPagingManager().getStoreNames()) {
                Assertions.assertTrue((server.getPagingManager().getPageStore(psName).getAddressSize() >= 0L ? (byte)1 : 0) != 0, (String)("non negative size: " + psName));
            }
            conn.close();
        }
        finally {
            server.stop();
        }
    }

    private void publish(ActiveMQJMSConnectionFactory cf, int numMessages) throws Exception {
        Connection conn = cf.createConnection();
        conn.start();
        Session sess = conn.createSession(false, 1);
        Topic subA = sess.createTopic("A.a");
        MessageProducer messageProducer = sess.createProducer((Destination)subA);
        for (int i = 0; i < numMessages; ++i) {
            messageProducer.send((Message)sess.createTextMessage(new Date().toString()));
        }
        conn.close();
    }
}

