/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.replication;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.tests.extensions.TargetTempDirFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedNothingReplicationTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @TempDir(factory=TargetTempDirFactory.class)
    public File brokersFolder;
    private SlowMessagePersister slowMessagePersister;
    ExecutorService sendMessageExecutor;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.sendMessageExecutor = Executors.newSingleThreadExecutor();
        CoreMessagePersister.registerPersister((CoreMessagePersister)SlowMessagePersister._getInstance());
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        CoreMessagePersister.resetPersister();
        this.sendMessageExecutor.shutdownNow();
        super.tearDown();
    }

    @Test
    public void testReplicateFromSlowLive() throws Exception {
        int i;
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        primaryServer.start();
        Wait.waitFor(() -> ((ActiveMQServer)primaryServer).isStarted());
        final CountDownLatch replicated = new CountDownLatch(1);
        ServerLocator locator = ServerLocatorImpl.newLocator((String)"tcp://localhost:61616");
        locator.setCallTimeout(60000L);
        locator.setConnectionTTL(60000L);
        locator.addClusterTopologyListener(new ClusterTopologyListener(){

            public void nodeUP(TopologyMember member, boolean last) {
                logger.debug("nodeUP fired last={}, primary={}, backup={}", new Object[]{last, member.getPrimary(), member.getBackup()});
                if (member.getBackup() != null) {
                    replicated.countDown();
                }
            }

            public void nodeDown(long eventUID, String nodeID) {
            }
        });
        ClientSessionFactory csf = locator.createSessionFactory();
        ClientSession sess = csf.createSession();
        sess.createQueue(QueueConfiguration.of((String)"slow").setRoutingType(RoutingType.ANYCAST));
        sess.close();
        int j = 50;
        CountDownLatch allMessageSent = new CountDownLatch(50);
        for (i = 0; i < 5; ++i) {
            this.sendMessageExecutor.execute(() -> {
                try {
                    ClientSession session = csf.createSession(true, true);
                    ClientProducer producer = session.createProducer("slow");
                    ClientMessage message = session.createMessage(true);
                    message.putLongProperty("delay", 500L);
                    logger.debug("try to send a message before replicated");
                    producer.send((Message)message);
                    logger.debug("send message done");
                    producer.close();
                    session.close();
                    allMessageSent.countDown();
                }
                catch (ActiveMQException e) {
                    logger.error("send message", (Throwable)e);
                }
            });
        }
        Configuration backupConfiguration = this.createBackupConfiguration();
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.start();
        Wait.waitFor(() -> backupServer.isStarted());
        Assertions.assertTrue((boolean)replicated.await(30L, TimeUnit.SECONDS), (String)"can not replicate in 30 seconds");
        while (i < 50) {
            this.sendMessageExecutor.execute(() -> {
                try {
                    ClientSession session = csf.createSession(true, true);
                    ClientProducer producer = session.createProducer("slow");
                    ClientMessage message = session.createMessage(true);
                    message.putLongProperty("delay", 0L);
                    logger.debug("try to send a message after replicated");
                    producer.send((Message)message);
                    logger.debug("send message done");
                    producer.close();
                    session.close();
                    allMessageSent.countDown();
                }
                catch (ActiveMQException e) {
                    logger.error("send message", (Throwable)e);
                }
            });
            ++i;
        }
        Assertions.assertTrue((boolean)allMessageSent.await(30L, TimeUnit.SECONDS), (String)"all message sent");
        csf.close();
        locator.close();
        backupServer.stop(true);
        primaryServer.stop(true);
        File primaryJournalDir = this.brokersFolder.toPath().resolve("live").resolve("data").resolve("journal").toFile();
        MappedSequentialFileFactory fileFactory = new MappedSequentialFileFactory(primaryConfiguration.getJournalLocation(), primaryConfiguration.getJournalFileSize(), false, primaryConfiguration.getJournalBufferSize_NIO(), primaryConfiguration.getJournalBufferTimeout_NIO(), null);
        JournalImpl primaryMessageJournal = new JournalImpl(primaryConfiguration.getJournalFileSize(), primaryConfiguration.getJournalMinFiles(), primaryConfiguration.getJournalPoolFiles(), primaryConfiguration.getJournalCompactMinFiles(), primaryConfiguration.getJournalCompactPercentage(), (SequentialFileFactory)fileFactory, "activemq-data", "amq", fileFactory.getMaxIO());
        primaryMessageJournal.start();
        final AtomicInteger primaryJournalCounter = new AtomicInteger();
        primaryMessageJournal.load((LoaderCallback)new AddRecordLoaderCallback(){

            public void addRecord(RecordInfo info) {
                if (info.userRecordType != 45) {
                    // empty if block
                }
                logger.debug("got primary message {}", (Object)info.id);
                primaryJournalCounter.incrementAndGet();
            }
        });
        File backupJournalDir = this.brokersFolder.toPath().resolve("backup").resolve("data").resolve("journal").toFile();
        fileFactory = new MappedSequentialFileFactory(backupConfiguration.getJournalLocation(), backupConfiguration.getJournalFileSize(), false, backupConfiguration.getJournalBufferSize_NIO(), backupConfiguration.getJournalBufferTimeout_NIO(), null);
        JournalImpl backupMessageJournal = new JournalImpl(backupConfiguration.getJournalFileSize(), backupConfiguration.getJournalMinFiles(), backupConfiguration.getJournalPoolFiles(), backupConfiguration.getJournalCompactMinFiles(), backupConfiguration.getJournalCompactPercentage(), (SequentialFileFactory)fileFactory, "activemq-data", "amq", fileFactory.getMaxIO());
        backupMessageJournal.start();
        final AtomicInteger replicationCounter = new AtomicInteger();
        backupMessageJournal.load((LoaderCallback)new AddRecordLoaderCallback(){

            public void addRecord(RecordInfo info) {
                if (info.userRecordType != 45) {
                    // empty if block
                }
                logger.debug("replicated message {}", (Object)info.id);
                replicationCounter.incrementAndGet();
            }
        });
        logger.debug("expected {} messages, primary={}, backup={}", new Object[]{50, primaryJournalCounter.get(), replicationCounter.get()});
        Assertions.assertEquals((int)50, (int)primaryJournalCounter.get(), (String)"Primary lost journal record");
        Assertions.assertEquals((int)50, (int)replicationCounter.get(), (String)"Backup did not replicated all journal");
        Assertions.assertTrue((boolean)SlowMessagePersister._getInstance().used, (String)"The test is not valid, slow persister stopped being used");
    }

    protected HAPolicyConfiguration createReplicationPrimaryConfiguration() {
        return new ReplicatedPolicyConfiguration().setVoteOnReplicationFailure(false).setCheckForActiveServer(false);
    }

    protected Configuration createPrimaryConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::primary");
        File primaryDir = SharedNothingReplicationTest.newFolder(this.brokersFolder, "primary");
        conf.setBrokerInstance(primaryDir);
        conf.addAcceptorConfiguration("primary", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("primary", "tcp://localhost:61616");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        conf.setHAPolicyConfiguration(this.createReplicationPrimaryConfiguration());
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("backup");
        ccconf.setName("cluster");
        ccconf.setConnectorName("primary");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    protected HAPolicyConfiguration createReplicationBackupConfiguration() {
        return new ReplicaPolicyConfiguration().setClusterName("cluster");
    }

    protected Configuration createBackupConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::backup");
        File backupDir = SharedNothingReplicationTest.newFolder(this.brokersFolder, "backup");
        conf.setBrokerInstance(backupDir);
        conf.setHAPolicyConfiguration(this.createReplicationBackupConfiguration());
        conf.addAcceptorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("live");
        ccconf.setName("cluster");
        ccconf.setConnectorName("backup");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    private static File newFolder(File root, String subFolder) throws IOException {
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }

    static class SlowMessagePersister
    extends CoreMessagePersister
    implements Persister<Message> {
        boolean used = false;
        private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        static SlowMessagePersister theInstance;
        private final CoreMessagePersister persister = CoreMessagePersister.getInstance();

        private SlowMessagePersister() {
        }

        static SlowMessagePersister _getInstance() {
            if (theInstance == null) {
                theInstance = new SlowMessagePersister();
            }
            return theInstance;
        }

        public byte getID() {
            return this.persister.getID();
        }

        public int getEncodeSize(Message record) {
            return this.persister.getEncodeSize(record);
        }

        public void encode(ActiveMQBuffer buffer, Message record) {
            this.used = true;
            try {
                Long delay = record.getLongProperty("delay");
                if (delay == null || delay <= 0L) {
                    logger.debug("encode message {}, caller={}", (Object)record.getMessageID(), (Object)Thread.currentThread().getName());
                } else {
                    logger.debug("sleep {} ms before encode message {}, caller={}", new Object[]{(long)delay, record.getMessageID(), Thread.currentThread().getName()});
                    Thread.sleep(delay);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.persister.encode(buffer, record);
        }

        public Message decode(ActiveMQBuffer buffer, Message message, CoreMessageObjectPools pool) {
            return this.persister.decode(buffer, message, pool);
        }
    }

    abstract class AddRecordLoaderCallback
    implements LoaderCallback {
        AddRecordLoaderCallback() {
        }

        public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
        }

        public void deleteRecord(long id) {
        }

        public void updateRecord(RecordInfo info) {
        }

        public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        }
    }
}

