/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AllClassesTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Class targetClass;

    @Parameters(name="classInfo={0}")
    public static Collection getParameters() {
        ArrayList<Class> parameters = new ArrayList<Class>();
        ClassLoader classLoader = AllClassesTest.class.getClassLoader();
        try {
            ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
            ImmutableSet classInfos = classPath.getTopLevelClassesRecursive("org.apache.activemq.artemis");
            for (ClassPath.ClassInfo classInfo : classInfos) {
                if (classInfo.getPackageName().contains("tests")) continue;
                try {
                    Class loadedClass = classInfo.load();
                    if (loadedClass.isEnum() || loadedClass.isInterface() || Modifier.isAbstract(loadedClass.getModifiers())) continue;
                    parameters.add(loadedClass);
                }
                catch (Throwable loadThrowable) {
                    logger.debug("cannot load {} : {}", (Object)classInfo.getName(), (Object)loadThrowable);
                }
            }
            parameters.sort(Comparator.comparing(Class::getName));
            return parameters;
        }
        catch (Exception e) {
            logger.warn("Exception on loading all classes: {}", (Object)e.toString());
            return parameters;
        }
    }

    public AllClassesTest(Class targetClass) {
        this.targetClass = targetClass;
    }

    @TestTemplate
    @Timeout(value=3L)
    public void testToString() {
        Object targetInstance = null;
        try {
            targetInstance = this.newInstance(this.targetClass);
        }
        catch (Throwable t) {
            logger.debug("Error creating a new instance of {}: {}", (Object)this.targetClass.getName(), (Object)t);
        }
        Assumptions.assumeTrue((targetInstance != null ? (byte)1 : 0) != 0, (String)("Cannot create " + this.targetClass.getName()));
        try {
            String targetOutput = targetInstance.toString();
            logger.debug("targetOutput: {}", (Object)targetOutput);
        }
        finally {
            if (targetInstance instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)targetInstance).close();
                }
                catch (Throwable t) {
                    logger.debug("Error closing the instance of {}: {}", (Object)this.targetClass.getName(), (Object)t);
                }
            }
        }
    }

    private Object newInstance(Class targetClass) {
        Constructor<?>[] targetConstructors = targetClass.getDeclaredConstructors();
        Arrays.sort(targetConstructors, (c1, c2) -> c2.getParameterCount() - c1.getParameterCount());
        for (Constructor<?> targetConstructor : targetConstructors) {
            Parameter[] constructorParameters;
            ArrayList<Byte> initArgs = new ArrayList<Byte>();
            for (Parameter constructorParameter : constructorParameters = targetConstructor.getParameters()) {
                Object initArg = constructorParameter.getType().isAssignableFrom(Byte.TYPE) ? Byte.valueOf(RandomUtil.randomByte()) : (constructorParameter.getType().isAssignableFrom(byte[].class) ? (Object)RandomUtil.randomBytes() : (constructorParameter.getType().isAssignableFrom(Boolean.TYPE) ? Boolean.valueOf(RandomUtil.randomBoolean()) : (constructorParameter.getType().isAssignableFrom(Character.TYPE) ? Character.valueOf(RandomUtil.randomChar()) : (constructorParameter.getType().isAssignableFrom(Double.TYPE) ? Double.valueOf(RandomUtil.randomDouble()) : (constructorParameter.getType().isAssignableFrom(Float.TYPE) ? Float.valueOf(RandomUtil.randomFloat()) : (constructorParameter.getType().isAssignableFrom(Integer.TYPE) ? Integer.valueOf(RandomUtil.randomInt() / 1024) : (constructorParameter.getType().isAssignableFrom(Long.TYPE) ? Long.valueOf(RandomUtil.randomLong()) : (constructorParameter.getType().isAssignableFrom(String.class) ? RandomUtil.randomString() : null))))))));
                initArgs.add((Byte)initArg);
            }
            try {
                return targetConstructor.newInstance(initArgs.toArray());
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Cannot construct {}: {}", (Object)targetClass.getName(), (Object)t);
            }
        }
        return null;
    }
}

