/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReusableLatchTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testLatchWithParameterizedDown() throws Exception {
        ReusableLatch latch = new ReusableLatch(1000);
        latch.countDown(5000);
        Assertions.assertTrue((boolean)latch.await(1000L));
        Assertions.assertEquals((int)0, (int)latch.getCount());
    }

    @Test
    public void testLatchOnSingleThread() throws Exception {
        int i;
        ReusableLatch latch = new ReusableLatch();
        for (i = 1; i <= 100; ++i) {
            latch.countUp();
            Assertions.assertEquals((int)i, (int)latch.getCount());
        }
        for (i = 100; i > 0; --i) {
            Assertions.assertEquals((int)i, (int)latch.getCount());
            latch.countDown();
            Assertions.assertEquals((int)(i - 1), (int)latch.getCount());
        }
        latch.await();
    }

    @Test
    public void testLatchOnMultiThread() throws Exception {
        int i;
        int i2;
        final ReusableLatch latch = new ReusableLatch();
        latch.countUp();
        int numberOfThreads = 100;
        int numberOfAdds = 100;
        CountDownLatch latchReady = new CountDownLatch(100);
        CountDownLatch latchStart = new CountDownLatch(1);
        class ThreadAdd
        extends Thread {
            private final CountDownLatch latchReady;
            private final CountDownLatch latchStart;

            ThreadAdd(CountDownLatch latchReady, CountDownLatch latchStart) {
                this.latchReady = latchReady;
                this.latchStart = latchStart;
            }

            @Override
            public void run() {
                try {
                    this.latchReady.countDown();
                    this.latchStart.await();
                    for (int i = 0; i < 100; ++i) {
                        latch.countUp();
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        ThreadAdd[] threadAdds = new ThreadAdd[100];
        class ThreadWait
        extends Thread {
            private volatile boolean waiting = true;

            ThreadWait() {
            }

            @Override
            public void run() {
                try {
                    if (!latch.await(5000L)) {
                        logger.error("Latch timed out");
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                this.waiting = false;
            }
        }
        ThreadWait[] waits = new ThreadWait[100];
        for (i2 = 0; i2 < 100; ++i2) {
            threadAdds[i2] = new ThreadAdd(latchReady, latchStart);
            threadAdds[i2].start();
            waits[i2] = new ThreadWait();
            waits[i2].start();
        }
        latchReady.await();
        latchStart.countDown();
        for (i2 = 0; i2 < 100; ++i2) {
            threadAdds[i2].join();
        }
        for (i2 = 0; i2 < 100; ++i2) {
            Assertions.assertTrue((boolean)waits[i2].waiting);
        }
        Assertions.assertEquals((int)10001, (int)latch.getCount());
        latchReady = new CountDownLatch(100);
        latchStart = new CountDownLatch(1);
        class ThreadDown
        extends Thread {
            private final CountDownLatch latchReady;
            private final CountDownLatch latchStart;

            ThreadDown(CountDownLatch latchReady, CountDownLatch latchStart) {
                this.latchReady = latchReady;
                this.latchStart = latchStart;
            }

            @Override
            public void run() {
                try {
                    this.latchReady.countDown();
                    this.latchStart.await();
                    for (int i = 0; i < 100; ++i) {
                        latch.countDown();
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        ThreadDown[] down = new ThreadDown[100];
        for (i = 0; i < 100; ++i) {
            down[i] = new ThreadDown(latchReady, latchStart);
            down[i].start();
        }
        latchReady.await();
        latchStart.countDown();
        for (i = 0; i < 100; ++i) {
            down[i].join();
        }
        Assertions.assertEquals((int)1, (int)latch.getCount());
        for (i = 0; i < 100; ++i) {
            Assertions.assertTrue((boolean)waits[i].waiting);
        }
        latch.countDown();
        for (i = 0; i < 100; ++i) {
            waits[i].join();
        }
        Assertions.assertEquals((int)0, (int)latch.getCount());
        for (i = 0; i < 100; ++i) {
            Assertions.assertFalse((boolean)waits[i].waiting);
        }
    }

    @Test
    public void testReuseLatch() throws Exception {
        final ReusableLatch latch = new ReusableLatch(5);
        for (int i = 0; i < 5; ++i) {
            latch.countDown();
        }
        latch.countUp();
        class ThreadWait
        extends Thread {
            private volatile boolean waiting = false;
            private volatile Exception e;
            private final CountDownLatch readyLatch = new CountDownLatch(1);

            ThreadWait() {
            }

            @Override
            public void run() {
                this.waiting = true;
                this.readyLatch.countDown();
                try {
                    if (!latch.await(1000L)) {
                        logger.error("Latch timed out!", (Throwable)new Exception("trace"));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    this.e = e;
                }
                this.waiting = false;
            }
        }
        ThreadWait t = new ThreadWait();
        t.start();
        t.readyLatch.await();
        Assertions.assertTrue((boolean)t.waiting);
        latch.countDown();
        t.join();
        Assertions.assertFalse((boolean)t.waiting);
        Assertions.assertNull((Object)t.e);
        latch.countUp();
        t = new ThreadWait();
        t.start();
        t.readyLatch.await();
        Assertions.assertTrue((boolean)t.waiting);
        latch.countDown();
        t.join();
        Assertions.assertFalse((boolean)t.waiting);
        Assertions.assertNull((Object)t.e);
        Assertions.assertTrue((boolean)latch.await(1000L));
        Assertions.assertEquals((int)0, (int)latch.getCount());
        latch.countDown();
        Assertions.assertEquals((int)0, (int)latch.getCount());
    }
}

