/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.util.Headers;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.handlers.HandlerDefinition;
import org.wildfly.extension.undertow.handlers.ReverseProxyHandlerHostDefinition;

public class ReverseProxyHandlerDefinition
extends HandlerDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"reverse-proxy");
    public static final AttributeDefinition PROBLEM_SERVER_RETRY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("problem-server-retry", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(30))).setMeasurementUnit(MeasurementUnit.SECONDS)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition SESSION_COOKIE_NAMES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-cookie-names", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode("JSESSIONID"))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition CONNECTIONS_PER_THREAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connections-per-thread", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(40))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition MAX_REQUEST_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-request-time", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition REQUEST_QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-queue-size", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition CACHED_CONNECTIONS_PER_THREAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cached-connections-per-thread", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(5))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition CONNECTION_IDLE_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-idle-timeout", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(60000))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition MAX_RETRIES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-retries", ModelType.INT).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(new ModelNode(1L))).build();
    public static final AttributeDefinition REUSE_X_FORWARDED_HEADER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("reuse-x-forwarded-header", ModelType.BOOLEAN).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setStability(Stability.COMMUNITY)).build();
    public static final AttributeDefinition REWRITE_HOST_HEADER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rewrite-host-header", ModelType.BOOLEAN).setRequired(false)).setRestartAllServices()).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setStability(Stability.COMMUNITY)).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = List.of(CONNECTIONS_PER_THREAD, SESSION_COOKIE_NAMES, PROBLEM_SERVER_RETRY, REQUEST_QUEUE_SIZE, MAX_REQUEST_TIME, CACHED_CONNECTIONS_PER_THREAD, CONNECTION_IDLE_TIMEOUT, MAX_RETRIES, REUSE_X_FORWARDED_HEADER, REWRITE_HOST_HEADER);

    ReverseProxyHandlerDefinition() {
        super(PATH_ELEMENT, ReverseProxyHandlerDefinition::createHandler);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return List.of(new ReverseProxyHandlerHostDefinition());
    }

    static HttpHandler createHandler(OperationContext context, ModelNode model) throws OperationFailedException {
        String[] sessionIds;
        String sessionCookieNames = SESSION_COOKIE_NAMES.resolveModelAttribute(context, model).asString();
        int connectionsPerThread = CONNECTIONS_PER_THREAD.resolveModelAttribute(context, model).asInt();
        int problemServerRetry = PROBLEM_SERVER_RETRY.resolveModelAttribute(context, model).asInt();
        int maxTime = MAX_REQUEST_TIME.resolveModelAttribute(context, model).asInt();
        int requestQueueSize = REQUEST_QUEUE_SIZE.resolveModelAttribute(context, model).asInt();
        int cachedConnectionsPerThread = CACHED_CONNECTIONS_PER_THREAD.resolveModelAttribute(context, model).asInt();
        int connectionIdleTimeout = CONNECTION_IDLE_TIMEOUT.resolveModelAttribute(context, model).asInt();
        int maxRetries = MAX_RETRIES.resolveModelAttribute(context, model).asInt();
        boolean reuseXForwardedHeader = REUSE_X_FORWARDED_HEADER.resolveModelAttribute(context, model).asBoolean();
        boolean rewriteHostHeader = REWRITE_HOST_HEADER.resolveModelAttribute(context, model).asBoolean();
        LoadBalancingProxyClient lb = new LoadBalancingProxyClient(exchange -> exchange.getRequestHeaders().contains(Headers.UPGRADE)).setConnectionsPerThread(connectionsPerThread).setMaxQueueSize(requestQueueSize).setSoftMaxConnectionsPerThread(cachedConnectionsPerThread).setTtl(connectionIdleTimeout).setProblemServerRetry(problemServerRetry);
        for (String id : sessionIds = sessionCookieNames.split(",")) {
            lb.addSessionCookieName(id);
        }
        return ProxyHandler.builder().setProxyClient((ProxyClient)lb).setMaxRequestTime(maxTime).setNext((HttpHandler)ResponseCodeHandler.HANDLE_404).setRewriteHostHeader(false).setReuseXForwarded(false).setMaxConnectionRetries(maxRetries).setRewriteHostHeader(rewriteHostHeader).setReuseXForwarded(reuseXForwardedHeader).build();
    }
}

