/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerImpl;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.CoreLargeServerMessage;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.SlowConsumerDetectionListener;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConsumerImpl
implements ServerConsumer,
ReadyListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final long id;
    private final long sequentialID;
    protected final Queue messageQueue;
    private final Filter filter;
    private final int priority;
    private final int minLargeMessageSize;
    private ServerSession session;
    protected final Object lock = new Object();
    private final boolean supportLargeMessage;
    private Object protocolData;
    private Object protocolContext;
    private final ActiveMQServer server;
    private SlowConsumerDetectionListener slowConsumerListener;
    private final ReusableLatch pendingDelivery = new ReusableLatch(0);
    private volatile AtomicInteger availableCredits = new AtomicInteger(0);
    private boolean started;
    private volatile CoreLargeMessageDeliverer largeMessageDeliverer = null;
    private final boolean browseOnly;
    protected BrowserDeliverer browserDeliverer;
    private final boolean strictUpdateDeliveryCount;
    private final StorageManager storageManager;
    private final Deque<MessageReference> deliveringRefs = new ArrayDeque<MessageReference>();
    private SessionCallback callback;
    private boolean preAcknowledge;
    private final ManagementService managementService;
    private final Binding binding;
    private boolean transferring = false;
    private final long creationTime;
    private AtomicLong consumerRateCheckTime = new AtomicLong(System.currentTimeMillis());
    private AtomicLong messageConsumedSnapshot = new AtomicLong(0L);
    private boolean requiresLegacyPrefix = false;
    private boolean anycast = false;
    private boolean isClosed = false;
    ServerConsumerMetrics metrics = new ServerConsumerMetrics();
    private final Runnable resumeLargeMessageRunnable = () -> {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.largeMessageDeliverer == null || this.largeMessageDeliverer.deliver()) {
                    this.forceDelivery();
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRunningLargeMessageDeliverer(e);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String debug() {
        String debug = this.toString() + "::Delivering ";
        Object object = this.lock;
        synchronized (object) {
            return debug + this.deliveringRefs.size();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public ServerConsumerImpl(long id, ServerSession session, QueueBinding binding, Filter filter, boolean started, boolean browseOnly, StorageManager storageManager, SessionCallback callback, boolean preAcknowledge, boolean strictUpdateDeliveryCount, ManagementService managementService, ActiveMQServer server) throws Exception {
        this(id, session, binding, filter, started, browseOnly, storageManager, callback, preAcknowledge, strictUpdateDeliveryCount, managementService, true, null, server);
    }

    public ServerConsumerImpl(long id, ServerSession session, QueueBinding binding, Filter filter, boolean started, boolean browseOnly, StorageManager storageManager, SessionCallback callback, boolean preAcknowledge, boolean strictUpdateDeliveryCount, ManagementService managementService, boolean supportLargeMessage, Integer credits, ActiveMQServer server) throws Exception {
        this(id, session, binding, filter, ActiveMQDefaultConfiguration.getDefaultConsumerPriority(), started, browseOnly, storageManager, callback, preAcknowledge, strictUpdateDeliveryCount, managementService, supportLargeMessage, credits, server);
    }

    public ServerConsumerImpl(long id, ServerSession session, QueueBinding binding, Filter filter, int priority, boolean started, boolean browseOnly, StorageManager storageManager, SessionCallback callback, boolean preAcknowledge, boolean strictUpdateDeliveryCount, ManagementService managementService, boolean supportLargeMessage, Integer credits, ActiveMQServer server) throws Exception {
        if (session == null || session.getRemotingConnection() == null) {
            throw new NullPointerException("session = " + String.valueOf(session));
        }
        if (session != null && session.getRemotingConnection() != null && session.getRemotingConnection().isDestroyed()) {
            throw ActiveMQMessageBundle.BUNDLE.connectionDestroyed(session.getRemotingConnection().getRemoteAddress());
        }
        this.id = id;
        this.sequentialID = server.getStorageManager().generateID();
        this.filter = filter;
        this.priority = priority;
        this.session = session;
        this.binding = binding;
        this.messageQueue = binding.getQueue();
        this.started = browseOnly || started;
        this.browseOnly = browseOnly;
        this.storageManager = storageManager;
        this.callback = callback;
        this.preAcknowledge = preAcknowledge;
        this.managementService = managementService;
        this.minLargeMessageSize = session.getMinLargeMessageSize();
        this.strictUpdateDeliveryCount = strictUpdateDeliveryCount;
        this.creationTime = System.currentTimeMillis();
        this.supportLargeMessage = supportLargeMessage;
        if (credits != null) {
            if (credits == -1) {
                this.availableCredits = null;
            } else {
                this.availableCredits.set(credits);
            }
        }
        this.server = server;
        if (browseOnly) {
            this.browserDeliverer = new BrowserDeliverer(this.messageQueue.browserIterator());
        } else {
            this.messageQueue.addConsumer(this);
        }
        RemotingConnection remotingConnection = session.getRemotingConnection();
        if (remotingConnection instanceof CoreRemotingConnection) {
            CoreRemotingConnection coreRemotingConnection = (CoreRemotingConnection)remotingConnection;
            if (session.getMetaData("jms-session") != null && coreRemotingConnection.getChannelVersion() < 129) {
                this.requiresLegacyPrefix = true;
                if (this.getQueue().getRoutingType().equals((Object)RoutingType.ANYCAST)) {
                    this.anycast = true;
                }
            }
        }
    }

    public void readyForWriting() {
        this.promptDelivery();
    }

    @Override
    public boolean allowReferenceCallback() {
        if (this.browseOnly) {
            return false;
        }
        return this.messageQueue.allowsReferenceCallback();
    }

    @Override
    public long sequentialID() {
        return this.sequentialID;
    }

    @Override
    public Object getProtocolData() {
        return this.protocolData;
    }

    @Override
    public void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
    }

    @Override
    public void setlowConsumerDetection(SlowConsumerDetectionListener listener) {
        this.slowConsumerListener = listener;
    }

    @Override
    public SlowConsumerDetectionListener getSlowConsumerDetecion() {
        return this.slowConsumerListener;
    }

    @Override
    public void fireSlowConsumer() {
        if (this.slowConsumerListener != null) {
            this.slowConsumerListener.onSlowConsumer(this);
        }
    }

    @Override
    public Object getProtocolContext() {
        return this.protocolContext;
    }

    @Override
    public void setProtocolContext(Object protocolContext) {
        this.protocolContext = protocolContext;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Object getConnectionID() {
        return this.session.getConnectionID();
    }

    @Override
    public String getSessionID() {
        return this.session.getName();
    }

    @Override
    public void metricsAcknowledge(MessageReference ref, Transaction transaction) {
        this.metrics.addAcknowledge(ref.getMessage().getEncodeSize(), transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getDeliveringMessages() {
        Object object = this.lock;
        synchronized (object) {
            int expectedSize = 0;
            List<MessageReference> refsOnConsumer = this.session.getInTXMessagesForConsumer(this.id);
            if (refsOnConsumer != null) {
                expectedSize = refsOnConsumer.size();
            }
            ArrayList<MessageReference> refs = new ArrayList<MessageReference>(expectedSize += this.deliveringRefs.size());
            if (refsOnConsumer != null) {
                refs.addAll(refsOnConsumer);
            }
            refs.addAll(this.deliveringRefs);
            return refs;
        }
    }

    @Override
    public boolean supportsDirectDelivery() {
        return this.callback.supportsDirectDelivery();
    }

    @Override
    public void errorProcessing(Throwable e, MessageReference deliveryObject) {
        this.messageQueue.errorProcessing(this, e, deliveryObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleStatus handle(MessageReference ref) throws Exception {
        AtomicInteger checkInteger = this.availableCredits;
        if (this.callback != null && !this.callback.hasCredits(this, ref) || checkInteger != null && checkInteger.get() <= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} is busy for the lack of credits. Current credits = {} Can't receive reference {}", new Object[]{this, this.availableCredits, ref});
            }
            return HandleStatus.BUSY;
        }
        if (this.server.hasBrokerMessagePlugins() && !this.server.callBrokerMessagePluginsCanAccept(this, ref)) {
            logger.trace("Reference {} is not allowed to be consumed by {} due to message plugin filter.", (Object)ref, (Object)this);
            return HandleStatus.NO_MATCH;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.callback != null && !this.callback.isWritable(this, this.protocolContext) || !this.started || this.transferring) {
                return HandleStatus.BUSY;
            }
            if (this.largeMessageDeliverer != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} is busy delivering large message {}, can't deliver reference {}", new Object[]{this, this.largeMessageDeliverer, ref});
                }
                return HandleStatus.BUSY;
            }
            Message message = ref.getMessage();
            if (!message.acceptsConsumer(this.sequentialID())) {
                return HandleStatus.NO_MATCH;
            }
            if (this.filter != null && !this.filter.match(message)) {
                logger.trace("Reference {} is a noMatch on consumer {}", (Object)ref, (Object)this);
                return HandleStatus.NO_MATCH;
            }
            logger.trace("ServerConsumerImpl::{} Handling reference {}", (Object)this, (Object)ref);
            if (!this.browseOnly) {
                if (!this.preAcknowledge) {
                    this.deliveringRefs.add(ref);
                }
                this.metrics.addMessage(ref.getMessage().getEncodeSize());
                ref.handled();
                ref.setConsumerId(this.id);
                ref.incrementDeliveryCount();
                if (this.strictUpdateDeliveryCount && !ref.isPaged() && ref.getMessage().isDurable() && ref.getQueue().isDurable() && !ref.getQueue().isInternalQueue() && !ref.isPaged()) {
                    this.storageManager.updateDeliveryCount(ref);
                }
                if (message instanceof CoreLargeServerMessage && this.supportLargeMessage) {
                    this.largeMessageDeliverer = new CoreLargeMessageDeliverer(ref);
                }
                if (this.preAcknowledge) {
                    ref.getQueue().acknowledge(ref, this);
                    this.metrics.addAcknowledge(ref.getMessage().getEncodeSize(), null);
                }
            }
            this.pendingDelivery.countUp();
            return HandleStatus.HANDLED;
        }
    }

    @Override
    public void proceedDeliver(MessageReference reference) throws Exception {
        try {
            if (AuditLogger.isMessageLoggingEnabled()) {
                AuditLogger.coreConsumeMessage((Subject)this.session.getRemotingConnection().getSubject(), (String)this.session.getRemotingConnection().getRemoteAddress(), (String)this.getQueueName().toString(), (String)reference.toString());
            }
            if (this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.beforeDeliver(this, reference));
            }
            if (reference.getMessage() instanceof CoreLargeServerMessage && this.supportLargeMessage) {
                if (this.largeMessageDeliverer == null) {
                    this.largeMessageDeliverer = new CoreLargeMessageDeliverer(reference);
                }
                this.largeMessageDeliverer.deliver();
            } else {
                this.deliverStandardMessage(reference);
            }
        }
        finally {
            this.pendingDelivery.countDown();
            this.callback.afterDelivery();
            if (this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.afterDeliver(this, reference));
            }
        }
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public SimpleString getFilterString() {
        return this.filter == null ? null : this.filter.getFilterString();
    }

    @Override
    public synchronized void close(boolean failed) throws Exception {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (logger.isTraceEnabled()) {
            logger.trace("ServerConsumerImpl::{} being closed with failed={}", new Object[]{this, failed, new Exception("trace")});
        }
        if (this.server.hasBrokerConsumerPlugins()) {
            this.server.callBrokerConsumerPlugins(plugin -> plugin.beforeCloseConsumer(this, failed));
        }
        this.setStarted(false);
        CoreLargeMessageDeliverer del = this.largeMessageDeliverer;
        if (del != null) {
            del.finish();
        }
        List<MessageReference> refs = this.cancelRefs(failed, false, null);
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        refs.forEach(ref -> {
            logger.trace("ServerConsumerImpl::{} cancelling reference {}", (Object)this, ref);
            ref.getQueue().cancel(tx, (MessageReference)ref, true);
        });
        tx.rollback();
        this.removeItself();
        this.addLingerRefs();
        if (!this.browseOnly) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.binding.getAddress());
            props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, this.binding.getClusterName());
            props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, this.binding.getRoutingName());
            props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, this.filter == null ? null : this.filter.getFilterString());
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, this.binding.getDistance());
            props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, this.messageQueue.getConsumerCount());
            props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.of((String)this.session.getUsername()));
            props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.of((String)this.session.getRemotingConnection().getRemoteAddress()));
            props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.of((String)this.session.getName()));
            if (this.session.getRemotingConnection().getClientID() != null) {
                props.putSimpleStringProperty(ManagementHelper.HDR_CLIENT_ID, SimpleString.of((String)this.session.getRemotingConnection().getClientID()));
            }
            props.putLongProperty(ManagementHelper.HDR_CONSUMER_NAME, this.getID());
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_CLOSED, props);
            this.managementService.sendNotification(notification);
        }
        this.messageQueue.recheckRefCount(this.session.getSessionContext());
        if (this.server.hasBrokerConsumerPlugins()) {
            this.server.callBrokerConsumerPlugins(plugin -> plugin.afterCloseConsumer(this, failed));
        }
        this.messageQueue.getExecutor().execute(() -> {
            this.protocolContext = null;
            this.callback = null;
            this.session = null;
        });
    }

    private void addLingerRefs() throws Exception {
        List<MessageReference> lingerRefs;
        if (!this.browseOnly && (lingerRefs = this.session.getInTXMessagesForConsumer(this.id)) != null && !lingerRefs.isEmpty()) {
            this.session.addLingerConsumer(this);
        }
    }

    @Override
    public void removeItself() throws Exception {
        if (this.browseOnly) {
            this.browserDeliverer.close();
        } else {
            this.messageQueue.removeConsumer(this);
            this.messageQueue.deliverAsync();
        }
        this.session.removeConsumer(this.id);
    }

    @Override
    public void forceDelivery(long sequence) {
        this.forceDelivery(sequence, () -> {
            CoreMessage forcedDeliveryMessage = new CoreMessage(this.storageManager.generateID(), 50).putLongProperty(ClientConsumerImpl.FORCED_DELIVERY_MESSAGE, sequence).setAddress(this.messageQueue.getName());
            MessageReference reference = MessageReference.Factory.createReference((Message)forcedDeliveryMessage, this.messageQueue);
            reference.setDeliveryCount(0);
            this.applyPrefixForLegacyConsumer((Message)forcedDeliveryMessage);
            this.callback.sendMessage(reference, this, 0);
        });
    }

    public synchronized void forceDelivery(long sequence, Runnable r) {
        this.promptDelivery();
        this.messageQueue.getExecutor().execute(() -> {
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (this.transferring) {
                        this.messageQueue.getExecutor().execute(() -> this.forceDelivery(sequence, r));
                        return;
                    }
                }
                r.run();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorSendingForcedDelivery(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> cancelRefs(boolean failed, boolean lastConsumedAsDelivered, Transaction tx) throws Exception {
        boolean performACK = lastConsumedAsDelivered;
        try {
            CoreLargeMessageDeliverer pendingLargeMessageDeliverer = this.largeMessageDeliverer;
            if (pendingLargeMessageDeliverer != null) {
                pendingLargeMessageDeliverer.finish();
            }
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorResttingLargeMessage(this.largeMessageDeliverer, e);
        }
        finally {
            this.largeMessageDeliverer = null;
        }
        Object object = this.lock;
        synchronized (object) {
            MessageReference ref;
            if (this.deliveringRefs.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<MessageReference> refs = new ArrayList<MessageReference>(this.deliveringRefs.size());
            while ((ref = this.deliveringRefs.poll()) != null) {
                this.metrics.addAcknowledge(ref.getMessage().getEncodeSize(), tx);
                if (performACK) {
                    ref.acknowledge(tx, this);
                    performACK = false;
                } else {
                    refs.add(ref);
                    this.updateDeliveryCountForCanceledRef(ref, failed);
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("ServerConsumerImpl::{} Preparing Cancelling list for messageID = {}, ref = {}", new Object[]{this, ref.getMessage().getMessageID(), ref});
            }
            return refs;
        }
    }

    protected void updateDeliveryCountForCanceledRef(MessageReference ref, boolean failed) {
        if (!this.callback.updateDeliveryCountAfterCancel(this, ref, failed) && !failed) {
            ref.decrementDeliveryCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStarted(boolean started) {
        Object object = this.lock;
        synchronized (object) {
            this.started = this.browseOnly || started;
        }
        if (started) {
            this.promptDelivery();
        } else {
            this.flushDelivery();
        }
    }

    private boolean flushDelivery() {
        try {
            if (!this.pendingDelivery.await(30L, TimeUnit.SECONDS)) {
                ActiveMQServerLogger.LOGGER.timeoutLockingConsumer(this.toString(), this.session.getRemotingConnection().getTransportConnection().getRemoteAddress());
                if (this.server != null) {
                    this.server.threadDump();
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToFinishDelivery(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransferring(boolean transferring) {
        Object object = this.lock;
        synchronized (object) {
            this.transferring = transferring;
        }
        if (transferring) {
            FutureLatch future = new FutureLatch();
            this.messageQueue.getExecutor().execute((Runnable)future);
            boolean ok = future.await(10000L);
            if (!ok) {
                ActiveMQServerLogger.LOGGER.errorTransferringConsumer();
            }
        }
        if (!transferring) {
            this.promptDelivery();
        } else {
            this.flushDelivery();
        }
    }

    @Override
    public void receiveCredits(int credits) {
        if (credits == -1) {
            logger.debug("{}:: FlowControl::Received disable flow control message", (Object)this);
            this.availableCredits = null;
            this.promptDelivery();
        } else if (credits == 0) {
            logger.debug("{}:: FlowControl::Received reset flow control message", (Object)this);
            this.availableCredits.set(0);
        } else {
            int previous = this.availableCredits.getAndAdd(credits);
            if (logger.isDebugEnabled()) {
                logger.debug("{}::FlowControl::Received {} credits, previous value = {} currentValue = {}", new Object[]{this, credits, previous, this.availableCredits.get()});
            }
            if (previous <= 0 && previous + credits > 0) {
                logger.trace("{}::calling promptDelivery from receiving credits", (Object)this);
                this.promptDelivery();
            }
        }
    }

    @Override
    public Queue getQueue() {
        return this.messageQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<MessageReference> scanDeliveringReferences(boolean remove, Function<MessageReference, Boolean> startFunction, Function<MessageReference, Boolean> endFunction) {
        LinkedList<MessageReference> retReferences = new LinkedList<MessageReference>();
        boolean hit = false;
        Object object = this.lock;
        synchronized (object) {
            Iterator<MessageReference> referenceIterator = this.deliveringRefs.iterator();
            while (referenceIterator.hasNext()) {
                MessageReference reference = referenceIterator.next();
                if (!hit && startFunction.apply(reference).booleanValue()) {
                    hit = true;
                }
                if (!hit) continue;
                if (remove) {
                    referenceIterator.remove();
                }
                retReferences.add(reference);
                if (!endFunction.apply(reference).booleanValue()) continue;
                break;
            }
        }
        return retReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Long> acknowledge(Transaction tx, long messageID) throws Exception {
        if (this.browseOnly) {
            return null;
        }
        ArrayList<Long> ackedRefs = null;
        boolean startedTransaction = false;
        if (tx == null) {
            startedTransaction = true;
            tx = new TransactionImpl(this.storageManager);
        }
        try {
            MessageReference ref;
            ackedRefs = new ArrayList<Long>();
            do {
                Object object = this.lock;
                synchronized (object) {
                    ref = this.deliveringRefs.poll();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("ACKing ref {} on tx={}, consumer={}", new Object[]{ref, tx, this});
                }
                if (ref == null) {
                    ActiveMQIllegalStateException ils = ActiveMQMessageBundle.BUNDLE.consumerNoReference(this.id, messageID, this.messageQueue.getName());
                    tx.markAsRollbackOnly((ActiveMQException)ils);
                    throw ils;
                }
                ref.acknowledge(tx, this);
                ackedRefs.add(ref.getMessageID());
                this.metrics.addAcknowledge(ref.getMessage().getEncodeSize(), tx);
            } while (ref.getMessageID() != messageID);
            if (startedTransaction) {
                tx.commit();
            }
        }
        catch (ActiveMQException e) {
            if (startedTransaction) {
                tx.rollback();
            } else {
                tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorAckingMessage((Exception)e);
            ActiveMQIllegalStateException activeMQIllegalStateException = new ActiveMQIllegalStateException(e.getMessage());
            if (startedTransaction) {
                tx.rollback();
            } else {
                tx.markAsRollbackOnly((ActiveMQException)activeMQIllegalStateException);
            }
            throw activeMQIllegalStateException;
        }
        return ackedRefs;
    }

    @Override
    public synchronized void individualAcknowledge(Transaction tx, long messageID) throws Exception {
        if (this.browseOnly) {
            return;
        }
        boolean startedTransaction = false;
        if (logger.isTraceEnabled()) {
            logger.trace("individualACK messageID={}", (Object)messageID);
        }
        if (tx == null) {
            logger.trace("individualACK starting new TX");
            startedTransaction = true;
            tx = new TransactionImpl(this.storageManager);
        }
        try {
            MessageReference ref = this.removeReferenceByID(messageID);
            if (logger.isTraceEnabled()) {
                logger.trace("ACKing ref {} on tx={}, consumer={}", new Object[]{ref, tx, this});
            }
            if (ref == null) {
                ActiveMQIllegalStateException ils = ActiveMQMessageBundle.BUNDLE.consumerNoReference(this.id, messageID, this.messageQueue.getName());
                tx.markAsRollbackOnly((ActiveMQException)ils);
                throw ils;
            }
            if (RefCountMessage.isRefTraceEnabled()) {
                RefCountMessage.deferredDebug((Message)ref.getMessage(), (String)"Individually acked on tx={}", (Object[])new Object[]{tx.getID()});
            }
            this.metrics.addAcknowledge(ref.getMessage().getEncodeSize(), tx);
            ref.acknowledge(tx, this);
            if (startedTransaction) {
                tx.commit();
            }
        }
        catch (ActiveMQException e) {
            if (startedTransaction) {
                tx.rollback();
            } else if (tx != null) {
                tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorAckingMessage((Exception)e);
            ActiveMQIllegalStateException hqex = new ActiveMQIllegalStateException(e.getMessage());
            if (startedTransaction) {
                tx.rollback();
            } else if (tx != null) {
                tx.markAsRollbackOnly((ActiveMQException)hqex);
            }
            throw hqex;
        }
    }

    @Override
    public synchronized void individualCancel(long messageID, boolean failed) throws Exception {
        if (this.browseOnly) {
            return;
        }
        MessageReference ref = this.removeReferenceByID(messageID);
        if (ref == null) {
            throw new IllegalStateException("Cannot find ref to ack " + messageID);
        }
        if (!failed) {
            ref.decrementDeliveryCount();
        }
        this.metrics.addAcknowledge(ref.getMessage().getEncodeSize(), null);
        ref.getQueue().cancel(ref, System.currentTimeMillis());
    }

    @Override
    public synchronized void reject(long messageID) throws Exception {
        if (this.browseOnly) {
            return;
        }
        MessageReference ref = this.removeReferenceByID(messageID);
        if (ref == null) {
            return;
        }
        this.metrics.addAcknowledge(ref.getMessage().getEncodeSize(), null);
        ref.getQueue().sendToDeadLetterAddress(null, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void backToDelivering(MessageReference reference) {
        Object object = this.lock;
        synchronized (object) {
            if (RefCountMessage.isRefTraceEnabled()) {
                RefCountMessage.deferredDebug((Message)reference.getMessage(), (String)"Adding message back to delivering", (Object[])new Object[0]);
            }
            logger.trace("Message {} back to delivering", (Object)reference);
            this.deliveringRefs.addFirst(reference);
            this.metrics.addMessage(reference.getMessage().getEncodeSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MessageReference removeReferenceByID(long messageID) throws Exception {
        if (this.browseOnly) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.deliveringRefs.isEmpty()) {
                logger.trace("removeReferenceByID {} return null", (Object)messageID);
                return null;
            }
            if (this.deliveringRefs.peek().getMessage().getMessageID() == messageID) {
                MessageReference ref = this.deliveringRefs.poll();
                if (logger.isTraceEnabled()) {
                    logger.trace("Remove Message By ID {} return ref {} after peek call", (Object)messageID, (Object)ref);
                }
                return ref;
            }
            MessageReference ref = this.removeDeliveringRefById(messageID);
            if (logger.isTraceEnabled()) {
                logger.trace("Remove Message By ID {} return ref {} after scan call", (Object)messageID, (Object)ref);
            }
            return ref;
        }
    }

    private MessageReference removeDeliveringRefById(long messageID) {
        logger.trace("RemoveDeiveringRefByID {}", (Object)messageID);
        Iterator<MessageReference> iter = this.deliveringRefs.iterator();
        MessageReference ref = null;
        while (iter.hasNext()) {
            MessageReference theRef = iter.next();
            if (theRef.getMessage().getMessageID() != messageID) continue;
            iter.remove();
            ref = theRef;
            logger.trace("Returning {}", (Object)theRef);
            break;
        }
        return ref;
    }

    public AtomicInteger getAvailableCredits() {
        return this.availableCredits;
    }

    public String toString() {
        return "ServerConsumerImpl [id=" + this.id + ", filter=" + String.valueOf(this.filter) + ", binding=" + String.valueOf(this.binding) + ", closed=" + this.isClosed + "]";
    }

    @Override
    public String toManagementString() {
        return "ServerConsumer [id=" + String.valueOf(this.getConnectionID()) + ":" + this.getSessionID() + ":" + this.id + ", filter=" + String.valueOf(this.filter) + ", binding=" + this.binding.toManagementString() + "]";
    }

    @Override
    public void disconnect() {
        this.callback.disconnect(this, "Queue deleted: " + String.valueOf(this.getQueue().getName()));
    }

    @Override
    public void failed(Throwable t) {
        try {
            this.close(true);
        }
        catch (Throwable e2) {
            logger.warn(e2.getMessage(), e2);
        }
        if (this.callback != null) {
            this.callback.disconnect(this, t.getMessage());
        }
    }

    public float getRate() {
        float timeSlice = (float)(System.currentTimeMillis() - this.consumerRateCheckTime.getAndSet(System.currentTimeMillis())) / 1000.0f;
        long acks = this.metrics.getMessagesAcknowledged();
        if (timeSlice == 0.0f) {
            this.messageConsumedSnapshot.getAndSet(acks);
            return 0.0f;
        }
        return BigDecimal.valueOf((float)(acks - this.messageConsumedSnapshot.getAndSet(acks)) / timeSlice).setScale(2, 0).floatValue();
    }

    @Override
    public void promptDelivery() {
        if (this.largeMessageDeliverer != null) {
            this.resumeLargeMessage();
        } else {
            this.forceDelivery();
        }
    }

    private void forceDelivery() {
        if (this.browseOnly) {
            this.messageQueue.getExecutor().execute(this.browserDeliverer);
        } else {
            this.messageQueue.deliverAsync();
        }
    }

    private void resumeLargeMessage() {
        this.messageQueue.getExecutor().execute(this.resumeLargeMessageRunnable);
    }

    private void deliverStandardMessage(MessageReference ref) {
        this.applyPrefixForLegacyConsumer(ref.getMessage());
        int packetSize = this.callback.sendMessage(ref, this, ref.getDeliveryCount());
        if (this.availableCredits != null) {
            this.availableCredits.addAndGet(-packetSize);
            if (logger.isTraceEnabled()) {
                logger.trace("{}::FlowControl::delivery standard taking {} from credits, available now is {}", new Object[]{this, packetSize, this.availableCredits});
            }
        }
    }

    private void applyPrefixForLegacyConsumer(Message message) {
        if (this.requiresLegacyPrefix) {
            if (this.anycast) {
                if (!message.getAddress().startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString())) {
                    message.setAddress(String.valueOf(PacketImpl.OLD_QUEUE_PREFIX) + message.getAddress());
                }
            } else if (!message.getAddress().startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString())) {
                message.setAddress(String.valueOf(PacketImpl.OLD_TOPIC_PREFIX) + message.getAddress());
            }
        }
    }

    public void setPreAcknowledge(boolean preAcknowledge) {
        this.preAcknowledge = preAcknowledge;
    }

    @Override
    public long getSequentialID() {
        return this.sequentialID;
    }

    @Override
    public SimpleString getQueueName() {
        return this.getQueue().getName();
    }

    @Override
    public RoutingType getQueueType() {
        return this.getQueue().getRoutingType();
    }

    @Override
    public SimpleString getQueueAddress() {
        return this.getQueue().getAddress();
    }

    @Override
    public String getSessionName() {
        return this.session.getName();
    }

    @Override
    public String getConnectionClientID() {
        return this.session.getRemotingConnection().getClientID();
    }

    @Override
    public String getConnectionProtocolName() {
        return this.session.getRemotingConnection().getProtocolName();
    }

    @Override
    public String getConnectionLocalAddress() {
        return this.session.getRemotingConnection().getTransportConnection().getLocalAddress();
    }

    @Override
    public String getConnectionRemoteAddress() {
        if (this.session == null || this.session.getRemotingConnection() == null || this.session.getRemotingConnection().getTransportConnection() == null) {
            return null;
        }
        return this.session.getRemotingConnection().getTransportConnection().getRemoteAddress();
    }

    @Override
    public long getMessagesInTransitSize() {
        return this.metrics.getMessagesInTransitSize();
    }

    @Override
    public int getMessagesInTransit() {
        return this.deliveringRefs.size();
    }

    @Override
    public long getLastDeliveredTime() {
        return this.metrics.getLastDeliveredTime();
    }

    @Override
    public long getLastAcknowledgedTime() {
        return this.metrics.getLastAcknowledgedTime();
    }

    @Override
    public long getMessagesAcknowledged() {
        return this.metrics.getMessagesAcknowledged();
    }

    @Override
    public long getMessagesDeliveredSize() {
        return this.metrics.getMessagesDeliveredSize();
    }

    @Override
    public long getMessagesDelivered() {
        return this.metrics.getMessagesDelivered();
    }

    @Override
    public int getMessagesAcknowledgedAwaitingCommit() {
        return this.metrics.getMessagesAcknowledgedAwaitingCommit();
    }

    public SessionCallback getCallback() {
        return this.callback;
    }

    private final class CoreLargeMessageDeliverer {
        private long sizePendingLargeMessage;
        private LargeServerMessage largeMessage;
        private final MessageReference ref;
        private boolean sentInitialPacket = false;
        private long positionPendingLargeMessage;
        private LargeBodyReader context;
        private ByteBuffer chunkBytes;

        private CoreLargeMessageDeliverer(MessageReference ref) {
            this.ref = ref;
            this.largeMessage = (LargeServerMessage)ref.getMessage();
            this.largeMessage.toMessage().usageUp();
            this.chunkBytes = null;
        }

        public String toString() {
            return "ServerConsumerImpl$LargeMessageDeliverer[ref=[" + String.valueOf(this.ref) + "]]";
        }

        private ByteBuffer acquireHeapBodyBuffer(int requiredCapacity) {
            if (this.chunkBytes == null || this.chunkBytes.capacity() != requiredCapacity) {
                this.chunkBytes = ByteBuffer.allocate(requiredCapacity);
            } else {
                this.chunkBytes.clear();
            }
            return this.chunkBytes;
        }

        private void releaseHeapBodyBuffer() {
            this.chunkBytes = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean deliver() throws Exception {
            ServerConsumerImpl.this.pendingDelivery.countUp();
            try {
                if (!ServerConsumerImpl.this.started) {
                    boolean bl = false;
                    return bl;
                }
                LargeServerMessage currentLargeMessage = this.largeMessage;
                if (currentLargeMessage == null) {
                    boolean bl = true;
                    return bl;
                }
                if (ServerConsumerImpl.this.availableCredits != null && ServerConsumerImpl.this.availableCredits.get() <= 0) {
                    logger.trace("{}::FlowControl::delivery largeMessage interrupting as there are no more credits, available={}", (Object)this, (Object)ServerConsumerImpl.this.availableCredits);
                    this.releaseHeapBodyBuffer();
                    boolean bl = false;
                    return bl;
                }
                if (!this.sentInitialPacket) {
                    int credits;
                    this.context = currentLargeMessage.getLargeBodyReader();
                    this.sizePendingLargeMessage = this.context.getSize();
                    this.context.open();
                    this.sentInitialPacket = true;
                    int packetSize = ServerConsumerImpl.this.callback.sendLargeMessage(this.ref, ServerConsumerImpl.this, this.context.getSize(), this.ref.getDeliveryCount());
                    if (ServerConsumerImpl.this.availableCredits != null) {
                        credits = ServerConsumerImpl.this.availableCredits.addAndGet(-packetSize);
                        if (credits <= 0) {
                            this.releaseHeapBodyBuffer();
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("{}::FlowControl:: deliver initialpackage with {} delivered, available now = {}", new Object[]{this, packetSize, ServerConsumerImpl.this.availableCredits});
                        }
                    }
                    ServerConsumerImpl.this.resumeLargeMessage();
                    credits = 0;
                    return credits != 0;
                }
                if (ServerConsumerImpl.this.availableCredits != null && ServerConsumerImpl.this.availableCredits.get() <= 0) {
                    logger.trace("{}::FlowControl::deliverLargeMessage Leaving loop of send LargeMessage because of credits, available={}", (Object)this, (Object)ServerConsumerImpl.this.availableCredits);
                    this.releaseHeapBodyBuffer();
                    boolean packetSize = false;
                    return packetSize;
                }
                int localChunkLen = (int)Math.min(this.sizePendingLargeMessage - this.positionPendingLargeMessage, (long)ServerConsumerImpl.this.minLargeMessageSize);
                ByteBuffer bodyBuffer = this.acquireHeapBodyBuffer(localChunkLen);
                assert (bodyBuffer.remaining() == localChunkLen);
                int readBytes = this.context.readInto(bodyBuffer);
                assert (readBytes == localChunkLen) : "readBytes = " + readBytes + ", localChunkLen=" + localChunkLen + " on large message " + this.largeMessage.getMessageID() + ", hash = " + System.identityHashCode(this.largeMessage);
                byte[] body = bodyBuffer.array();
                assert (body.length == readBytes);
                int packetSize = ServerConsumerImpl.this.callback.sendLargeMessageContinuation(ServerConsumerImpl.this, body, this.positionPendingLargeMessage + (long)localChunkLen < this.sizePendingLargeMessage, false);
                int chunkLen = body.length;
                if (ServerConsumerImpl.this.availableCredits != null) {
                    int credits = ServerConsumerImpl.this.availableCredits.addAndGet(-packetSize);
                    if (credits <= 0) {
                        this.releaseHeapBodyBuffer();
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("{}::FlowControl::largeMessage deliver continuation, packetSize={} available now={}", new Object[]{this, packetSize, ServerConsumerImpl.this.availableCredits});
                    }
                }
                this.positionPendingLargeMessage += (long)chunkLen;
                if (this.positionPendingLargeMessage < this.sizePendingLargeMessage) {
                    ServerConsumerImpl.this.resumeLargeMessage();
                    boolean bl = false;
                    return bl;
                }
                logger.trace("Finished deliverLargeMessage");
                this.finish();
                boolean bl = true;
                return bl;
            }
            finally {
                ServerConsumerImpl.this.pendingDelivery.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() throws Exception {
            Object object = ServerConsumerImpl.this.lock;
            synchronized (object) {
                this.releaseHeapBodyBuffer();
                if (this.largeMessage == null) {
                    return;
                }
                if (this.context != null) {
                    this.context.close();
                    this.context = null;
                }
                this.largeMessage.releaseResources(false, false);
                this.largeMessage.toMessage().usageDown();
                ServerConsumerImpl.this.largeMessageDeliverer = null;
                this.largeMessage = null;
            }
        }
    }

    static class ServerConsumerMetrics
    extends TransactionOperationAbstract {
        private static final AtomicLongFieldUpdater<ServerConsumerMetrics> messagesInTransitSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerConsumerMetrics.class, "messagesInTransitSize");
        private volatile long messagesInTransitSize = 0L;
        private static final AtomicIntegerFieldUpdater<ServerConsumerMetrics> messagesAcknowledgedAwaitingCommitUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerConsumerMetrics.class, "messagesAcknowledgedAwaitingCommit");
        private volatile int messagesAcknowledgedAwaitingCommit = 0;
        private static final AtomicLongFieldUpdater<ServerConsumerMetrics> messagesDeliveredSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerConsumerMetrics.class, "messagesDeliveredSize");
        private volatile long messagesDeliveredSize = 0L;
        private volatile long lastDeliveredTime = 0L;
        private volatile long lastAcknowledgedTime = 0L;
        private static final AtomicLongFieldUpdater<ServerConsumerMetrics> messagesDeliveredUpdater = AtomicLongFieldUpdater.newUpdater(ServerConsumerMetrics.class, "messagesDelivered");
        private volatile long messagesDelivered = 0L;
        private static final AtomicLongFieldUpdater<ServerConsumerMetrics> messagesAcknowledgedUpdater = AtomicLongFieldUpdater.newUpdater(ServerConsumerMetrics.class, "messagesAcknowledged");
        private volatile long messagesAcknowledged = 0L;

        ServerConsumerMetrics() {
        }

        public long getMessagesInTransitSize() {
            return messagesInTransitSizeUpdater.get(this);
        }

        public long getMessagesDeliveredSize() {
            return messagesDeliveredSizeUpdater.get(this);
        }

        public long getLastDeliveredTime() {
            return this.lastDeliveredTime;
        }

        public long getLastAcknowledgedTime() {
            return this.lastAcknowledgedTime;
        }

        public long getMessagesDelivered() {
            return messagesDeliveredUpdater.get(this);
        }

        public long getMessagesAcknowledged() {
            return messagesAcknowledgedUpdater.get(this);
        }

        public int getMessagesAcknowledgedAwaitingCommit() {
            return messagesAcknowledgedAwaitingCommitUpdater.get(this);
        }

        public void addMessage(int encodeSize) {
            messagesInTransitSizeUpdater.addAndGet(this, encodeSize);
            messagesDeliveredSizeUpdater.addAndGet(this, encodeSize);
            messagesDeliveredUpdater.addAndGet(this, 1L);
            this.lastDeliveredTime = System.currentTimeMillis();
        }

        public void addAcknowledge(int encodeSize, Transaction tx) {
            messagesInTransitSizeUpdater.addAndGet(this, -encodeSize);
            messagesAcknowledgedUpdater.addAndGet(this, 1L);
            this.lastAcknowledgedTime = System.currentTimeMillis();
            if (tx != null) {
                this.addOperation(tx);
                messagesAcknowledgedAwaitingCommitUpdater.addAndGet(this, 1);
            }
        }

        @Override
        public void afterCommit(Transaction tx) {
            messagesAcknowledgedAwaitingCommitUpdater.set(this, 0);
        }

        @Override
        public void afterRollback(Transaction tx) {
            messagesAcknowledgedAwaitingCommitUpdater.set(this, 0);
        }

        public void addOperation(Transaction tx) {
            Object property = tx.getProperty(10);
            if (property == null) {
                tx.putProperty(10, this);
                tx.addOperation(this);
            }
        }
    }

    protected class BrowserDeliverer
    implements Runnable {
        protected MessageReference current = null;
        public final LinkedListIterator<MessageReference> iterator;

        public BrowserDeliverer(LinkedListIterator<MessageReference> iterator) {
            this.iterator = iterator;
        }

        public synchronized void close() {
            this.iterator.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            block13: {
                if (this.current != null) {
                    try {
                        HandleStatus status = ServerConsumerImpl.this.handle(this.current);
                        if (status == HandleStatus.BUSY) {
                            return;
                        }
                        if (status == HandleStatus.HANDLED) {
                            ServerConsumerImpl.this.proceedDeliver(this.current);
                        }
                        this.current = null;
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorBrowserHandlingMessage(this.current, e);
                        return;
                    }
                }
                MessageReference ref = null;
                try {
                    while (true) {
                        HandleStatus status;
                        ref = null;
                        Queue queue = ServerConsumerImpl.this.messageQueue;
                        synchronized (queue) {
                            if (!this.iterator.hasNext()) {
                                logger.trace("browser finished");
                                ServerConsumerImpl.this.callback.browserFinished(ServerConsumerImpl.this);
                                break block13;
                            }
                            ref = (MessageReference)this.iterator.next();
                            logger.trace("Receiving {}", (Object)ref.getMessage());
                            status = ServerConsumerImpl.this.handle(ref);
                        }
                        if (status == HandleStatus.HANDLED) {
                            ServerConsumerImpl.this.proceedDeliver(ref);
                            continue;
                        }
                        if (status == HandleStatus.BUSY) break;
                    }
                    this.current = ref;
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorBrowserHandlingMessage(ref, e);
                }
            }
        }

        public boolean isBrowsed() {
            ServerConsumerImpl.this.messageQueue.deliverAsync();
            boolean b = !this.iterator.hasNext();
            return b;
        }
    }
}

