/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logging;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;

public class LoggingLogger_$logger
extends DelegatingBasicLogger
implements LoggingLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LoggingLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final AtomicBoolean unresolvablePathExpressions_$Once = new AtomicBoolean(false);

    public LoggingLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void failedToCloseResource(Throwable cause, AutoCloseable closeable) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToCloseResource$str(), (Object)closeable);
    }

    protected String failedToCloseResource$str() {
        return "WFLYLOG0006: Failed to close resource %s";
    }

    @Override
    public final void invalidPropertyAttribute(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidPropertyAttribute$str(), (Object)name);
    }

    protected String invalidPropertyAttribute$str() {
        return "WFLYLOG0007: The attribute %s could not be set as it is not a configurable property value.";
    }

    protected String pathManagerServiceNotStarted$str() {
        return "WFLYLOG0008: The path manager service does not appear to be started. Any changes may be lost as a result of this.";
    }

    @Override
    public final String pathManagerServiceNotStarted() {
        return String.format(this.getLoggingLocale(), this.pathManagerServiceNotStarted$str(), new Object[0]);
    }

    @Override
    public final void loggingProfileNotFound(String loggingProfile, ResourceRoot deployment) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.loggingProfileNotFound$str(), (Object)loggingProfile, (Object)deployment);
    }

    protected String loggingProfileNotFound$str() {
        return "WFLYLOG0010: Logging profile '%s' was specified for deployment '%s' but was not found. Using system logging configuration.";
    }

    @Override
    public final void julConfigurationFileFound(String fileName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.julConfigurationFileFound$str(), (Object)fileName);
    }

    protected String julConfigurationFileFound$str() {
        return "WFLYLOG0011: The configuration file in '%s' appears to be a J.U.L. configuration file. The log manager does not allow this type of configuration file.";
    }

    @Override
    public final void replacingNamedHandler(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.replacingNamedHandler$str(), (Object)name);
    }

    protected String replacingNamedHandler$str() {
        return "WFLYLOG0012: Replacing handler '%s' during add operation. Either the handler type or the module name differs from the initial configuration.";
    }

    @Override
    public final void replacingConfigurator(Configurator c) {
        if (this.log.isEnabled(Logger.Level.WARN)) {
            Class<?> cClass = c == null ? null : c.getClass();
            this.log.logf(FQCN, Logger.Level.WARN, null, this.replacingConfigurator$str(), cClass);
        }
    }

    protected String replacingConfigurator$str() {
        return "WFLYLOG0013: A configurator class, '%s', is not a known configurator and will be replaced.";
    }

    @Override
    public final void logContextNotRemoved(LogContext logContext, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.logContextNotRemoved$str(), (Object)logContext, (Object)deploymentName);
    }

    protected String logContextNotRemoved$str() {
        return "WFLYLOG0014: The log context (%s) could not be removed for deployment %s";
    }

    @Override
    public final void perDeploymentPropertyDeprecated(String propertyName, String attributeName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.perDeploymentPropertyDeprecated$str(), (Object)propertyName, (Object)attributeName);
    }

    protected String perDeploymentPropertyDeprecated$str() {
        return "WFLYLOG0015: The per-logging deployment property (%s) has been deprecated. Please use the %s attribute to enable/disable per-deployment logging.";
    }

    @Override
    public final void perLoggingDeploymentIgnored(String propertyName, String attributeName, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.perLoggingDeploymentIgnored$str(), (Object)propertyName, (Object)attributeName, (Object)deploymentName);
    }

    protected String perLoggingDeploymentIgnored$str() {
        return "WFLYLOG0016: The per-logging deployment property (%s) is being ignored because the attribute %s has been set to ignore configuration files in the deployment %s.";
    }

    protected String cannotLoadModule$str() {
        return "WFLYLOG0019: Failed to load module '%s' for %s '%s'";
    }

    @Override
    public final IllegalArgumentException cannotLoadModule(Throwable cause, String moduleName, String description, String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotLoadModule$str(), moduleName, description, name), cause);
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String classNotFound$str() {
        return "WFLYLOG0021: Class '%s' could not be found.";
    }

    @Override
    public final String classNotFound(Throwable cause, String className) {
        return String.format(this.getLoggingLocale(), this.classNotFound$str(), className);
    }

    protected String handlerAlreadyDefined$str() {
        return "WFLYLOG0023: Handler %s is already assigned.";
    }

    @Override
    public final String handlerAlreadyDefined(String name) {
        return String.format(this.getLoggingLocale(), this.handlerAlreadyDefined$str(), name);
    }

    protected String invalidFilter$str() {
        return "WFLYLOG0025: Filter %s is invalid";
    }

    @Override
    public final String invalidFilter(String name) {
        return String.format(this.getLoggingLocale(), this.invalidFilter$str(), name);
    }

    protected String invalidLogLevel$str() {
        return "WFLYLOG0026: Log level %s is invalid.";
    }

    @Override
    public final String invalidLogLevel(String level) {
        return String.format(this.getLoggingLocale(), this.invalidLogLevel$str(), level);
    }

    protected String invalidOverflowAction$str() {
        return "WFLYLOG0027: Overflow action %s is invalid.";
    }

    @Override
    public final String invalidOverflowAction(String overflowAction) {
        return String.format(this.getLoggingLocale(), this.invalidOverflowAction$str(), overflowAction);
    }

    protected String invalidSize$str() {
        return "WFLYLOG0028: Invalid size %s";
    }

    @Override
    public final String invalidSize(String size) {
        return String.format(this.getLoggingLocale(), this.invalidSize$str(), size);
    }

    protected String loggerNotFound$str() {
        return "WFLYLOG0035: Logger '%s' was not found.";
    }

    @Override
    public final String loggerNotFound(String name) {
        return String.format(this.getLoggingLocale(), this.loggerNotFound$str(), name);
    }

    protected String invalidRelativeTo$str() {
        return "WFLYLOG0039: An absolute path (%s) cannot be specified for relative-to.";
    }

    @Override
    public final String invalidRelativeTo(String relativeTo) {
        return String.format(this.getLoggingLocale(), this.invalidRelativeTo$str(), relativeTo);
    }

    protected String invalidSuffix$str() {
        return "WFLYLOG0041: The suffix (%s) is invalid. A suffix must be a valid date format.";
    }

    @Override
    public final String invalidSuffix(String suffix) {
        return String.format(this.getLoggingLocale(), this.invalidSuffix$str(), suffix);
    }

    protected String failedToConfigureLogging$str() {
        return "WFLYLOG0042: Failed to configure logging using '%s' configuration file.";
    }

    @Override
    public final DeploymentUnitProcessingException failedToConfigureLogging(Throwable cause, String fileName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToConfigureLogging$str(), fileName), cause);
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorProcessingLoggingConfiguration$str() {
        return "WFLYLOG0043: Error occurred while searching for logging configuration files.";
    }

    @Override
    public final DeploymentUnitProcessingException errorProcessingLoggingConfiguration(Throwable cause) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.errorProcessingLoggingConfiguration$str(), new Object[0]), cause);
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String handlerAttachedToHandlers$str() {
        return "WFLYLOG0044: Handler %s is attached to the following handlers and cannot be removed; %s";
    }

    @Override
    public final OperationFailedException handlerAttachedToHandlers(String handlerName, Collection<String> handlers) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.handlerAttachedToHandlers$str(), handlerName, handlers));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String handlerAttachedToLoggers$str() {
        return "WFLYLOG0045: Handler %s is attached to the following loggers and cannot be removed; %s";
    }

    @Override
    public final OperationFailedException handlerAttachedToLoggers(String handlerName, Collection<String> loggers) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.handlerAttachedToLoggers$str(), handlerName, loggers));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotAddHandlerToSelf$str() {
        return "WFLYLOG0046: Cannot add handler (%s) to itself";
    }

    @Override
    public final String cannotAddHandlerToSelf(String handlerName) {
        return String.format(this.getLoggingLocale(), this.cannotAddHandlerToSelf$str(), handlerName);
    }

    protected String handlerClosed$str() {
        return "WFLYLOG0047: The handler is closed, cannot publish to a closed handler";
    }

    @Override
    public final IllegalStateException handlerClosed() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.handlerClosed$str(), new Object[0]));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String handlerConfigurationNotFound$str() {
        return "WFLYLOG0048: Configuration for handler '%s' could not be found.";
    }

    @Override
    public final String handlerConfigurationNotFound(String name) {
        return String.format(this.getLoggingLocale(), this.handlerConfigurationNotFound$str(), name);
    }

    protected String loggerConfigurationNotFound$str() {
        return "WFLYLOG0049: Configuration for logger '%s' could not be found.";
    }

    @Override
    public final String loggerConfigurationNotFound(String name) {
        return String.format(this.getLoggingLocale(), this.loggerConfigurationNotFound$str(), name);
    }

    protected String unsupportedMethod$str() {
        return "WFLYLOG0050: Method %s on class %s is not supported";
    }

    @Override
    public final UnsupportedOperationException unsupportedMethod(String methodName, String className) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedMethod$str(), methodName, className));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToWriteConfigurationFile$str() {
        return "WFLYLOG0051: Failed to write configuration file %s";
    }

    @Override
    public final RuntimeException failedToWriteConfigurationFile(Throwable e, File fileName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToWriteConfigurationFile$str(), fileName), e);
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String formatterNotFound$str() {
        return "WFLYLOG0061: Formatter '%s' is not found";
    }

    @Override
    public final String formatterNotFound(String name) {
        return String.format(this.getLoggingLocale(), this.formatterNotFound$str(), name);
    }

    protected String truncatedFilterExpression$str() {
        return "WFLYLOG0070: Truncated filter expression string";
    }

    @Override
    public final IllegalArgumentException truncatedFilterExpression() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.truncatedFilterExpression$str(), new Object[0]));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidEscapeFoundInFilterExpression$str() {
        return "WFLYLOG0071: Invalid escape found in filter expression string";
    }

    @Override
    public final IllegalArgumentException invalidEscapeFoundInFilterExpression() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidEscapeFoundInFilterExpression$str(), new Object[0]));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String filterNotFound$str() {
        return "WFLYLOG0072: Filter '%s' is not found";
    }

    @Override
    public final OperationFailedException filterNotFound(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.filterNotFound$str(), name));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String expectedIdentifier$str() {
        return "WFLYLOG0073: Expected identifier next in filter expression";
    }

    @Override
    public final IllegalArgumentException expectedIdentifier() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expectedIdentifier$str(), new Object[0]));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expectedString$str() {
        return "WFLYLOG0074: Expected string next in filter expression";
    }

    @Override
    public final IllegalArgumentException expectedString() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expectedString$str(), new Object[0]));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expected1$str() {
        return "WFLYLOG0075: Expected '%s' next in filter expression";
    }

    @Override
    public final IllegalArgumentException expected(String token) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expected1$str(), token));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expected2$str() {
        return "WFLYLOG0075: Expected '%s' or '%s' next in filter expression";
    }

    @Override
    public final IllegalArgumentException expected(String trueToken, String falseToken) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expected2$str(), trueToken, falseToken));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedEnd$str() {
        return "WFLYLOG0076: Unexpected end of filter expression";
    }

    @Override
    public final IllegalArgumentException unexpectedEnd() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unexpectedEnd$str(), new Object[0]));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String extensionNotInitialized$str() {
        return "WFLYLOG0078: The logging subsystem requires the log manager to be org.jboss.logmanager.LogManager. The subsystem has not be initialized and cannot be used. To use JBoss Log Manager you must add the system property \"java.util.logging.manager\" and set it to \"org.jboss.logmanager.LogManager\"";
    }

    @Override
    public final IllegalStateException extensionNotInitialized() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.extensionNotInitialized$str(), new Object[0]));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToReadLogFile$str() {
        return "WFLYLOG0079: Failed to read the log file '%s'";
    }

    @Override
    public final RuntimeException failedToReadLogFile(Throwable cause, String name) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToReadLogFile$str(), name), cause);
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String logFileNotFound$str() {
        return "WFLYLOG0080: File '%s' was not found and cannot be found in the %s directory.";
    }

    @Override
    public final Resource.NoSuchResourceException logFileNotFound(String name, String directoryProperty) {
        Resource.NoSuchResourceException result = new Resource.NoSuchResourceException(String.format(this.getLoggingLocale(), this.logFileNotFound$str(), name, directoryProperty));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String readNotAllowed$str() {
        return "WFLYLOG0081: File '%s' is not allowed to be read.";
    }

    @Override
    public final OperationFailedException readNotAllowed(String name) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.readNotAllowed$str(), name));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String suffixContainsMillis$str() {
        return "WFLYLOG0082: The suffix (%s) can not contain seconds or milliseconds.";
    }

    @Override
    public final String suffixContainsMillis(String suffix) {
        return String.format(this.getLoggingLocale(), this.suffixContainsMillis$str(), suffix);
    }

    protected String invalidLogFile$str() {
        return "WFLYLOG0083: Path '%s' is a directory and cannot be used as a log file.";
    }

    @Override
    public final OperationFailedException invalidLogFile(String path) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidLogFile$str(), path));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotRegisterResourceOfType$str() {
        return "WFLYLOG0084: Resources of type %s cannot be registered";
    }

    @Override
    public final UnsupportedOperationException cannotRegisterResourceOfType(String childType) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.cannotRegisterResourceOfType$str(), childType));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRemoveResourceOfType$str() {
        return "WFLYLOG0085: Resources of type %s cannot be removed";
    }

    @Override
    public final UnsupportedOperationException cannotRemoveResourceOfType(String childType) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.cannotRemoveResourceOfType$str(), childType));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String deploymentNameNotFound$str() {
        return "WFLYLOG0086: Could not determine deployment name from the address %s.";
    }

    @Override
    public final IllegalArgumentException deploymentNameNotFound(PathAddress address) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.deploymentNameNotFound$str(), address));
        LoggingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void errorProcessingLogDirectory(String logDir) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.errorProcessingLogDirectory$str(), (Object)logDir);
    }

    protected String errorProcessingLogDirectory$str() {
        return "WFLYLOG0087: Failed to process logging directory %s. Log files cannot be listed.";
    }

    @Override
    public final void errorDeterminingChildrenExist(Throwable cause, String childType) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorDeterminingChildrenExist$str(), (Object)childType);
    }

    protected String errorDeterminingChildrenExist$str() {
        return "WFLYLOG0088: Could not determine %s had any children resources.";
    }

    @Override
    public final void unknownLogManager(String logManagerName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unknownLogManager$str(), (Object)logManagerName);
    }

    protected String unknownLogManager$str() {
        return "WFLYLOG0089: The log manager check was skipped and the log manager system property, \"java.util.logging.manager\", does not appear to be set to \"org.jboss.logmanager.LogManager\". The current value is \"%s\". Some behavior of the logged output such as MDC and NDC may not work as expected.";
    }

    @Override
    public final void unresolvablePathExpressions(Set<String> unresolvableExpressions) {
        if (this.log.isEnabled(Logger.Level.WARN) && unresolvablePathExpressions_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.WARN, null, this.unresolvablePathExpressions$str(), unresolvableExpressions);
        }
    }

    protected String unresolvablePathExpressions$str() {
        return "WFLYLOG0090: The following path expressions could not be resolved while attempting to determine which log files are available to be read: %s";
    }

    protected String invalidExceptionOutputType$str() {
        return "WFLYLOG0091: Exception output type %s is invalid.";
    }

    @Override
    public final OperationFailedException invalidExceptionOutputType(String value) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidExceptionOutputType$str(), value));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidType$str() {
        return "WFLYLOG0092: Invalid type found. Expected %s but found %s.";
    }

    @Override
    public final OperationFailedException invalidType(Class<?> expected, Class<?> found) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidType$str(), expected, found));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToConfigureSslContext$str() {
        return "WFLYLOG0093: Failed to configure SSL context for %s %s.";
    }

    @Override
    public final OperationFailedException failedToConfigureSslContext(Throwable cause, String resourceName, String resourceValue) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.failedToConfigureSslContext$str(), resourceName, resourceValue), cause);
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String illegalFormatterName$str() {
        return "WFLYLOG0094: Formatter name cannot end with '-wfcore-pattern-formatter'";
    }

    @Override
    public final OperationFailedException illegalFormatterName() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.illegalFormatterName$str(), new Object[0]));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String reservedFilterName$str() {
        return "WFLYLOG0095: The name %s cannot be used as a filter name as it is a reserved filter name. Reserved names are: %s";
    }

    @Override
    public final OperationFailedException reservedFilterName(String name, Collection<String> reservedNames) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.reservedFilterName$str(), name, reservedNames));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFilterNameStart$str() {
        return "WFLYLOG0096: The name %s cannot be used as a filter name as it starts with an invalid character %s";
    }

    @Override
    public final OperationFailedException invalidFilterNameStart(String name, char invalidChar) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidFilterNameStart$str(), name, Character.valueOf(invalidChar)));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidFilterName$str() {
        return "WFLYLOG0097: The name %s cannot be used as a filter name as it contains an invalid character %s";
    }

    @Override
    public final OperationFailedException invalidFilterName(String name, char invalidChar) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidFilterName$str(), name, Character.valueOf(invalidChar)));
        LoggingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void usageOfAppender(String appenderType) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usageOfAppender$str(), (Object)appenderType);
    }

    protected String usageOfAppender$str() {
        return "WFLYLOG0099: Usage of a log4j appender (%s) found in a custom-handler. Support for using appenders as custom handlers has been deprecated and will be removed in a future release.";
    }

    @Override
    public final void usageOfLog4j1Config(String fileName, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usageOfLog4j1Config$str(), (Object)fileName, (Object)deploymentName);
    }

    protected String usageOfLog4j1Config$str() {
        return "WFLYLOG0100: Usage of a log4j configuration file (%s) was found in deployment %s. Support for log4j configuration files in deployments has been deprecated and will be removed in a future release.";
    }
}

