/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.internal.ProcedureParameterBindingImpl;
import org.hibernate.procedure.internal.ProcedureParameterMetadataImpl;
import org.hibernate.procedure.spi.ProcedureParameterBindingImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.procedure.ProcedureParameterBinding;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.jboss.logging.Logger;

public class ProcedureParamBindings
implements QueryParameterBindings {
    private static final Logger LOG = Logger.getLogger(QueryParameterBindings.class);
    private final ProcedureParameterMetadataImpl parameterMetadata;
    private final SessionFactoryImplementor sessionFactory;
    private final Map<ProcedureParameterImplementor<?>, ProcedureParameterBindingImplementor<?>> bindingMap = new HashMap();

    public ProcedureParamBindings(ProcedureParameterMetadataImpl parameterMetadata, SessionFactoryImplementor sessionFactory) {
        this.parameterMetadata = parameterMetadata;
        this.sessionFactory = sessionFactory;
    }

    public ProcedureParameterMetadataImpl getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public boolean isBound(QueryParameterImplementor<?> parameter) {
        return this.bindingMap.containsKey(parameter);
    }

    public <P> ProcedureParameterBinding<P> getBinding(QueryParameterImplementor<P> parameter) {
        return this.getQueryParamerBinding((ProcedureParameterImplementor)parameter);
    }

    public <P> ProcedureParameterBinding<P> getQueryParamerBinding(ProcedureParameterImplementor<P> parameter) {
        QueryParameterImplementor procParam = this.parameterMetadata.resolve(parameter);
        ProcedureParameterBindingImplementor<?> binding = this.bindingMap.get(procParam);
        if (binding == null) {
            if (!this.parameterMetadata.containsReference(parameter)) {
                throw new IllegalArgumentException("Passed parameter is not registered with this query");
            }
            binding = new ProcedureParameterBindingImpl((ProcedureParameterImplementor<?>)procParam, this.sessionFactory);
            this.bindingMap.put((ProcedureParameterImplementor<?>)procParam, binding);
        }
        return binding;
    }

    public <P> ProcedureParameterBinding<P> getBinding(String name) {
        QueryParameterImplementor parameter = this.parameterMetadata.getQueryParameter(name);
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter does not exist: " + name);
        }
        return this.getQueryParamerBinding((ProcedureParameterImplementor<P>)parameter);
    }

    public <P> ProcedureParameterBinding<P> getBinding(int position) {
        QueryParameterImplementor parameter = this.parameterMetadata.getQueryParameter(position);
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter at position " + position + "does not exist");
        }
        return this.getQueryParamerBinding((ProcedureParameterImplementor<P>)parameter);
    }

    @Override
    public void validate() {
        this.parameterMetadata.visitRegistrations(queryParameter -> {
            ProcedureParameterImplementor procParam = (ProcedureParameterImplementor)queryParameter;
            if (!(procParam.getMode() != ParameterMode.IN && procParam.getMode() != ParameterMode.INOUT || this.getBinding((QueryParameterImplementor)procParam).isBound())) {
                if (procParam.getPosition() != null) {
                    LOG.debugf("Procedure parameter at position %s is not bound", (Object)procParam.getPosition());
                } else {
                    LOG.debugf("Procedure parameter %s is not bound", (Object)procParam.getName());
                }
            }
        });
    }

    @Override
    public boolean hasAnyMultiValuedBindings() {
        return false;
    }

    @Override
    public void visitBindings(BiConsumer<QueryParameterImplementor<?>, QueryParameterBinding<?>> action) {
        this.bindingMap.forEach(action);
    }

    @Override
    public QueryKey.ParameterBindingsMemento generateQueryKeyMemento(SharedSessionContractImplementor persistenceContext) {
        return NO_PARAMETER_BINDING_MEMENTO;
    }
}

